/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.pipe.connector.payload.thrift.request;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public enum PipeRequestType {
    HANDSHAKE_CONFIGNODE_V1(0),
    HANDSHAKE_DATANODE_V1(1),
    HANDSHAKE_CONFIGNODE_V2(50),
    HANDSHAKE_DATANODE_V2(51),
    TRANSFER_TABLET_INSERT_NODE(2),
    TRANSFER_TABLET_RAW(3),
    TRANSFER_TS_FILE_PIECE(4),
    TRANSFER_TS_FILE_SEAL(5),
    TRANSFER_TABLET_BATCH(6),
    TRANSFER_TABLET_BINARY(7),
    TRANSFER_TS_FILE_PIECE_WITH_MOD(8),
    TRANSFER_TS_FILE_SEAL_WITH_MOD(9),
    TRANSFER_SCHEMA_PLAN(100),
    TRANSFER_SCHEMA_SNAPSHOT_PIECE(101),
    TRANSFER_SCHEMA_SNAPSHOT_SEAL(102),
    TRANSFER_CONFIG_PLAN(200),
    TRANSFER_CONFIG_SNAPSHOT_PIECE(201),
    TRANSFER_CONFIG_SNAPSHOT_SEAL(202);

    private final short type;
    private static final Map<Short, PipeRequestType> TYPE_MAP;

    private PipeRequestType(short type) {
        this.type = type;
    }

    public short getType() {
        return this.type;
    }

    public static boolean isValidatedRequestType(short type) {
        return TYPE_MAP.containsKey(type);
    }

    public static PipeRequestType valueOf(short type) {
        return TYPE_MAP.get(type);
    }

    static {
        TYPE_MAP = Arrays.stream(PipeRequestType.values()).collect(HashMap::new, (typeMap, pipeRequestType) -> typeMap.put(pipeRequestType.getType(), pipeRequestType), HashMap::putAll);
    }
}

