/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.subscription.broker;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.commons.pipe.event.EnrichedEvent;
import org.apache.iotdb.commons.subscription.config.SubscriptionConfig;
import org.apache.iotdb.rpc.subscription.payload.EnrichedTablets;
import org.apache.iotdb.rpc.subscription.payload.response.PipeSubscribePollResp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerializedEnrichedEvent {
    private static final Logger LOGGER = LoggerFactory.getLogger(SerializedEnrichedEvent.class);
    private static final long INVALID_TIMESTAMP = -1L;
    private final EnrichedTablets enrichedTablets;
    private final List<EnrichedEvent> enrichedEvents;
    private long lastPolledTimestamp;
    private long committedTimestamp;
    private ByteBuffer byteBuffer;

    public SerializedEnrichedEvent(EnrichedTablets enrichedTablets, List<EnrichedEvent> enrichedEvents) {
        this.enrichedTablets = enrichedTablets;
        this.enrichedEvents = enrichedEvents;
        this.lastPolledTimestamp = -1L;
        this.committedTimestamp = -1L;
    }

    public EnrichedTablets getEnrichedTablets() {
        return this.enrichedTablets;
    }

    public boolean serialize() {
        if (Objects.isNull(this.byteBuffer)) {
            try {
                this.byteBuffer = PipeSubscribePollResp.serializeEnrichedTablets((EnrichedTablets)this.enrichedTablets);
                return true;
            }
            catch (IOException e) {
                LOGGER.warn("Subscription: something unexpected happened when serializing EnrichedTablets {}, exception is {}", (Object)this.byteBuffer, (Object)e.getMessage());
                return false;
            }
        }
        return true;
    }

    public ByteBuffer getByteBuffer() {
        return this.byteBuffer;
    }

    public void resetByteBuffer() {
        this.byteBuffer = null;
    }

    public String getSubscriptionCommitId() {
        return this.enrichedTablets.getSubscriptionCommitId();
    }

    public void decreaseReferenceCount() {
        for (EnrichedEvent enrichedEvent : this.enrichedEvents) {
            enrichedEvent.decreaseReferenceCount(SerializedEnrichedEvent.class.getName(), true);
        }
    }

    public void recordCommittedTimestamp() {
        this.committedTimestamp = System.currentTimeMillis();
    }

    public boolean isCommitted() {
        return this.committedTimestamp != -1L;
    }

    public void recordLastPolledTimestamp() {
        this.lastPolledTimestamp = Math.max(this.lastPolledTimestamp, System.currentTimeMillis());
    }

    public boolean pollable() {
        if (this.lastPolledTimestamp == -1L) {
            return true;
        }
        return System.currentTimeMillis() - this.lastPolledTimestamp > (long)SubscriptionConfig.getInstance().getSubscriptionRecycleUncommittedEventIntervalMs();
    }
}

