/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.subscription.agent;

import java.util.Iterator;
import java.util.List;
import org.apache.iotdb.commons.subscription.meta.topic.TopicMeta;
import org.apache.iotdb.commons.subscription.meta.topic.TopicMetaKeeper;
import org.apache.iotdb.mpp.rpc.thrift.TPushTopicMetaRespExceptionMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscriptionTopicAgent {
    private static final Logger LOGGER = LoggerFactory.getLogger(SubscriptionTopicAgent.class);
    private final TopicMetaKeeper topicMetaKeeper = new TopicMetaKeeper();

    protected void acquireReadLock() {
        this.topicMetaKeeper.acquireReadLock();
    }

    protected void releaseReadLock() {
        this.topicMetaKeeper.releaseReadLock();
    }

    protected void acquireWriteLock() {
        this.topicMetaKeeper.acquireWriteLock();
    }

    protected void releaseWriteLock() {
        this.topicMetaKeeper.releaseWriteLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TPushTopicMetaRespExceptionMessage handleSingleTopicMetaChanges(TopicMeta topicMetaFromCoordinator) {
        this.acquireWriteLock();
        try {
            this.handleSingleTopicMetaChangesInternal(topicMetaFromCoordinator);
            TPushTopicMetaRespExceptionMessage tPushTopicMetaRespExceptionMessage = null;
            return tPushTopicMetaRespExceptionMessage;
        }
        catch (Exception e) {
            String topicName = topicMetaFromCoordinator.getTopicName();
            String exceptionMessage = String.format("Subscription: Failed to handle single topic meta changes for topic %s, because %s", topicName, e.getMessage());
            LOGGER.warn(exceptionMessage);
            TPushTopicMetaRespExceptionMessage tPushTopicMetaRespExceptionMessage = new TPushTopicMetaRespExceptionMessage(topicName, exceptionMessage, System.currentTimeMillis());
            return tPushTopicMetaRespExceptionMessage;
        }
        finally {
            this.releaseWriteLock();
        }
    }

    private void handleSingleTopicMetaChangesInternal(TopicMeta metaFromCoordinator) {
        String topicName = metaFromCoordinator.getTopicName();
        this.topicMetaKeeper.removeTopicMeta(topicName);
        this.topicMetaKeeper.addTopicMeta(topicName, metaFromCoordinator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TPushTopicMetaRespExceptionMessage handleTopicMetaChanges(List<TopicMeta> topicMetasFromCoordinator) {
        this.acquireWriteLock();
        try {
            for (TopicMeta topicMetaFromCoordinator : topicMetasFromCoordinator) {
                try {
                    this.handleSingleTopicMetaChangesInternal(topicMetaFromCoordinator);
                }
                catch (Exception e) {
                    String topicName = topicMetaFromCoordinator.getTopicName();
                    String exceptionMessage = String.format("Subscription: Failed to handle single topic meta changes for topic %s, because %s", topicName, e.getMessage());
                    LOGGER.warn(exceptionMessage);
                    TPushTopicMetaRespExceptionMessage tPushTopicMetaRespExceptionMessage = new TPushTopicMetaRespExceptionMessage(topicName, exceptionMessage, System.currentTimeMillis());
                    this.releaseWriteLock();
                    return tPushTopicMetaRespExceptionMessage;
                }
            }
            Iterator<TopicMeta> iterator = null;
            return iterator;
        }
        finally {
            this.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TPushTopicMetaRespExceptionMessage handleDropTopic(String topicName) {
        this.acquireWriteLock();
        try {
            this.handleDropTopicInternal(topicName);
            TPushTopicMetaRespExceptionMessage tPushTopicMetaRespExceptionMessage = null;
            return tPushTopicMetaRespExceptionMessage;
        }
        catch (Exception e) {
            String exceptionMessage = String.format("Subscription: Failed to drop topic %s, because %s", topicName, e.getMessage());
            LOGGER.warn(exceptionMessage);
            TPushTopicMetaRespExceptionMessage tPushTopicMetaRespExceptionMessage = new TPushTopicMetaRespExceptionMessage(topicName, exceptionMessage, System.currentTimeMillis());
            return tPushTopicMetaRespExceptionMessage;
        }
        finally {
            this.releaseWriteLock();
        }
    }

    private void handleDropTopicInternal(String topicName) {
        this.topicMetaKeeper.removeTopicMeta(topicName);
    }

    public boolean isTopicExisted(String topicName) {
        this.acquireReadLock();
        try {
            boolean bl = this.topicMetaKeeper.containsTopicMeta(topicName);
            return bl;
        }
        finally {
            this.releaseReadLock();
        }
    }
}

