/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.tsfile.timeindex;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Set;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.exception.PartitionViolationException;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.timeindex.TimeIndexLevel;
import org.apache.iotdb.tsfile.file.metadata.IDeviceID;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public interface ITimeIndex {
    public static final byte DEVICE_TIME_INDEX_TYPE = 1;
    public static final byte FILE_TIME_INDEX_TYPE = 2;

    public void serialize(OutputStream var1) throws IOException;

    public ITimeIndex deserialize(InputStream var1) throws IOException;

    public ITimeIndex deserialize(ByteBuffer var1);

    public void close();

    public Set<IDeviceID> getDevices(String var1, TsFileResource var2);

    public boolean endTimeEmpty();

    public boolean stillLives(long var1);

    public long calculateRamSize();

    public long getTimePartition(String var1);

    public long getTimePartitionWithCheck(String var1) throws PartitionViolationException;

    public boolean isSpanMultiTimePartitions();

    public void updateStartTime(IDeviceID var1, long var2);

    public void updateEndTime(IDeviceID var1, long var2);

    public void putStartTime(IDeviceID var1, long var2);

    public void putEndTime(IDeviceID var1, long var2);

    public long getStartTime(IDeviceID var1);

    public long getEndTime(IDeviceID var1);

    public boolean checkDeviceIdExist(IDeviceID var1);

    public long getMinStartTime();

    public long getMaxEndTime();

    public int compareDegradePriority(ITimeIndex var1);

    public boolean definitelyNotContains(IDeviceID var1);

    public long[] getStartAndEndTime(IDeviceID var1);

    public Pair<Long, Long> getPossibleStartTimeAndEndTime(PartialPath var1, Set<IDeviceID> var2);

    public byte getTimeIndexType();

    public static ITimeIndex createTimeIndex(InputStream inputStream) throws IOException {
        byte timeIndexType = ReadWriteIOUtils.readByte((InputStream)inputStream);
        if (timeIndexType == -1) {
            throw new IOException("The end of stream has been reached");
        }
        return TimeIndexLevel.valueOf(timeIndexType).getTimeIndex().deserialize(inputStream);
    }
}

