/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.tool;

import java.io.File;
import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.iotdb.db.storageengine.dataregion.compaction.tool.Interval;
import org.apache.iotdb.db.storageengine.dataregion.compaction.tool.SequenceFileTaskSummary;
import org.apache.iotdb.db.storageengine.dataregion.compaction.tool.TsFileStatisticReader;
import org.apache.iotdb.db.storageengine.dataregion.compaction.tool.UnseqSpaceStatistics;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.IDeviceID;

public class SingleSequenceFileTask
implements Callable<SequenceFileTaskSummary> {
    private UnseqSpaceStatistics unseqSpaceStatistics;
    private String seqFile;

    public SingleSequenceFileTask(UnseqSpaceStatistics unseqSpaceStatistics, String seqFile) {
        this.unseqSpaceStatistics = unseqSpaceStatistics;
        this.seqFile = seqFile;
    }

    @Override
    public SequenceFileTaskSummary call() throws Exception {
        return this.checkSeqFile(this.unseqSpaceStatistics, this.seqFile);
    }

    private SequenceFileTaskSummary checkSeqFile(UnseqSpaceStatistics unseqSpaceStatistics, String seqFile) {
        SequenceFileTaskSummary summary = new SequenceFileTaskSummary();
        File f = new File(seqFile);
        if (!f.exists()) {
            return summary;
        }
        summary.fileSize += f.length();
        try (TsFileStatisticReader reader = new TsFileStatisticReader(seqFile);){
            List<TsFileStatisticReader.ChunkGroupStatistics> chunkGroupStatisticsList = reader.getChunkGroupStatisticsList();
            for (TsFileStatisticReader.ChunkGroupStatistics chunkGroupStatistics : chunkGroupStatisticsList) {
                Interval deviceInterval;
                summary.totalChunks += (long)chunkGroupStatistics.getTotalChunkNum();
                IDeviceID deviceId = chunkGroupStatistics.getDeviceID();
                long deviceStartTime = Long.MAX_VALUE;
                long deviceEndTime = Long.MIN_VALUE;
                for (ChunkMetadata chunkMetadata : chunkGroupStatistics.getChunkMetadataList()) {
                    if (chunkMetadata.getStartTime() > chunkMetadata.getEndTime()) continue;
                    deviceStartTime = Math.min(deviceStartTime, chunkMetadata.getStartTime());
                    deviceEndTime = Math.max(deviceEndTime, chunkMetadata.getEndTime());
                    summary.setMinStartTime(deviceStartTime);
                    summary.setMaxEndTime(deviceEndTime);
                    Interval interval = new Interval(chunkMetadata.getStartTime(), chunkMetadata.getEndTime());
                    String measurementId = chunkMetadata.getMeasurementUid();
                    if (!unseqSpaceStatistics.chunkHasOverlap(deviceId, measurementId, interval)) continue;
                    ++summary.overlapChunk;
                }
                if (deviceStartTime > deviceEndTime || !unseqSpaceStatistics.chunkGroupHasOverlap(deviceId, deviceInterval = new Interval(deviceStartTime, deviceEndTime))) continue;
                ++summary.overlapChunkGroup;
            }
            summary.totalChunkGroups = chunkGroupStatisticsList.size();
        }
        catch (IOException e) {
            if (e instanceof NoSuchFileException) {
                System.out.println(seqFile + " is not exist");
                return new SequenceFileTaskSummary();
            }
            e.printStackTrace();
            return new SequenceFileTaskSummary();
        }
        return summary;
    }
}

