/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.schemafile;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.db.exception.metadata.schemafile.RecordDuplicatedException;
import org.apache.iotdb.db.exception.metadata.schemafile.SchemaPageOverflowException;
import org.apache.iotdb.db.exception.metadata.schemafile.SegmentNotFoundException;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.mnode.ICachedMNode;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.schemafile.ISchemaPage;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.schemafile.ISegment;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.schemafile.ISegmentedPage;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.schemafile.SchemaFile;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.schemafile.SchemaPage;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.schemafile.WrappedSegment;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class SegmentedPage
extends SchemaPage
implements ISegmentedPage {
    private final transient List<Short> segOffsetLst;
    private final transient Map<Short, ISegment<ByteBuffer, ICachedMNode>> segCacheMap = new ConcurrentHashMap<Short, ISegment<ByteBuffer, ICachedMNode>>();

    public SegmentedPage(ByteBuffer pageBuffer, AtomicInteger ai, ReadWriteLock rwl) {
        super(pageBuffer, ai, rwl);
        this.segOffsetLst = new ArrayList<Short>();
        pageBuffer.position(pageBuffer.capacity() - 2 * this.memberNum);
        for (int idx = 0; idx < this.memberNum; ++idx) {
            this.segOffsetLst.add(ReadWriteIOUtils.readShort((ByteBuffer)pageBuffer));
        }
    }

    public SegmentedPage(ByteBuffer pageBuffer) {
        super(pageBuffer, new AtomicInteger(), new ReentrantReadWriteLock());
        this.segOffsetLst = new ArrayList<Short>();
        pageBuffer.position(pageBuffer.capacity() - 2 * this.memberNum);
        for (int idx = 0; idx < this.memberNum; ++idx) {
            this.segOffsetLst.add(ReadWriteIOUtils.readShort((ByteBuffer)pageBuffer));
        }
    }

    @Override
    public long write(short segIdx, String key, ByteBuffer buffer) throws MetadataException {
        ISegment<ByteBuffer, ICachedMNode> tarSeg = this.getSegment(segIdx);
        if (tarSeg.insertRecord(key, buffer) < 0) {
            short spare = this.spareSize;
            if ((tarSeg = this.relocateSegment(tarSeg, segIdx, SchemaFile.reEstimateSegSize(tarSeg.size() + buffer.capacity()))) == null) {
                return -1L;
            }
            if (tarSeg.insertRecord(key, buffer) < 0) {
                throw new MetadataException("failed to insert buffer into relocated segment");
            }
            return spare >= this.spareSize ? 0L : (long)(this.spareSize - spare);
        }
        return 0L;
    }

    @Override
    public ICachedMNode read(short segIdx, String key) throws MetadataException {
        return this.getSegment(segIdx).getRecordByKey(key);
    }

    @Override
    public ICachedMNode readByAlias(short segIdx, String alias) throws MetadataException {
        return this.getSegment(segIdx).getRecordByAlias(alias);
    }

    @Override
    public long update(short segIdx, String key, ByteBuffer buffer) throws MetadataException {
        ISegment<ByteBuffer, ICachedMNode> seg = this.getSegment(segIdx);
        if (seg.updateRecord(key, buffer) < 0) {
            short spare = this.spareSize;
            if ((seg = this.relocateSegment(seg, segIdx, SchemaFile.reEstimateSegSize(seg.size() + buffer.capacity()))) == null) {
                return -1L;
            }
            if (seg.updateRecord(key, buffer) < 0) {
                throw new MetadataException("failed to update buffer upon relocated segment");
            }
            return spare >= this.spareSize ? 0L : (long)(this.spareSize - spare);
        }
        return 0L;
    }

    @Override
    public Queue<ICachedMNode> getChildren(short segId) throws MetadataException {
        return this.getSegment(segId).getAllRecords();
    }

    @Override
    public void removeRecord(short segId, String key) throws SegmentNotFoundException {
        this.getSegment(segId).removeRecord(key);
    }

    @Override
    public synchronized void deleteSegment(short segId) throws SegmentNotFoundException {
        this.spareSize = (short)(this.spareSize + this.getSegmentSize(segId));
        this.getSegment(segId).delete();
        this.segCacheMap.remove(segId);
        this.segOffsetLst.set(segId, (short)-1);
    }

    @Override
    public void purgeSegments() {
        this.segCacheMap.clear();
        this.segOffsetLst.clear();
        this.memberNum = 0;
        this.spareOffset = (short)32;
        this.spareSize = (short)(this.pageBuffer.capacity() - 32);
    }

    @Override
    public int validSegments() {
        return this.memberNum;
    }

    @Override
    public short getSpareSize() {
        return this.spareSize;
    }

    @Override
    public boolean isCapableForSegSize(short size) {
        return this.spareSize >= size + 2;
    }

    @Override
    public short getSegmentSize(short segId) throws SegmentNotFoundException {
        return this.getSegment(segId).size();
    }

    @Override
    public void getPageBuffer(ByteBuffer dst) {
        this.pageBuffer.clear();
        dst.put(this.pageBuffer);
    }

    @Override
    public synchronized short allocNewSegment(short size) throws MetadataException {
        ISegment<ByteBuffer, ICachedMNode> newSeg = WrappedSegment.initAsSegment(this.allocSpareBufferSlice(size));
        if (newSeg == null) {
            this.compactSegments();
            newSeg = WrappedSegment.initAsSegment(this.allocSpareBufferSlice(size));
        }
        if (newSeg == null) {
            throw new SchemaPageOverflowException(this.pageIndex);
        }
        return this.registerNewSegment(newSeg);
    }

    @Override
    public long transplantSegment(ISegmentedPage srcPage, short segId, short newSegSize) throws MetadataException {
        if (!this.isCapableForSegSize(newSegSize)) {
            throw new SchemaPageOverflowException(this.pageIndex);
        }
        if (this.maxAppendableSegmentSize() < newSegSize) {
            this.compactSegments();
        }
        ByteBuffer newBuf = ByteBuffer.allocate(newSegSize);
        srcPage.extendsSegmentTo(newBuf, segId);
        newBuf.clear();
        this.pageBuffer.clear();
        this.pageBuffer.position(this.spareOffset);
        this.pageBuffer.put(newBuf);
        this.pageBuffer.position(this.spareOffset);
        this.pageBuffer.limit(this.spareOffset + newSegSize);
        ISegment<ByteBuffer, ICachedMNode> newSeg = WrappedSegment.loadAsSegment(this.pageBuffer.slice());
        return SchemaFile.getGlobalIndex(this.pageIndex, this.registerNewSegment(newSeg));
    }

    @Override
    public void extendsSegmentTo(ByteBuffer dstBuffer, short segId) throws MetadataException {
        this.getSegment(segId).extendsTo(dstBuffer);
    }

    @Override
    public void setNextSegAddress(short segId, long address) throws SegmentNotFoundException {
        this.getSegment(segId).setNextSegAddress(address);
    }

    @Override
    public long getNextSegAddress(short segId) throws SegmentNotFoundException {
        return this.getSegment(segId).getNextSegAddress();
    }

    @Override
    public String splitWrappedSegment(String key, ByteBuffer recBuf, ISchemaPage dstPage, boolean inclineSplit) throws MetadataException {
        if (this.segOffsetLst.size() != 1 || this.segOffsetLst.get(0) != 32 || this.getSegment((short)0).size() != 16350) {
            throw new SegmentNotFoundException(this.pageIndex);
        }
        return this.getSegment((short)0).splitByKey(key, recBuf, dstPage.getEntireSegmentSlice(), inclineSplit);
    }

    @Override
    public String inspect() throws SegmentNotFoundException {
        this.syncPageBuffer();
        StringBuilder builder = new StringBuilder(String.format("page_id:%d, total_seg:%d, spare_from:%d, spare_size:%d%n", this.pageIndex, this.memberNum, this.spareOffset, this.spareSize));
        for (short idx = 0; idx < this.segOffsetLst.size(); idx = (short)(idx + 1)) {
            short offset = this.segOffsetLst.get(idx);
            if (offset < 0) {
                builder.append(String.format("seg_id:%d deleted, offset:%d%n", idx, offset));
                continue;
            }
            ISegment<ByteBuffer, ICachedMNode> seg = this.getSegment(idx);
            builder.append(String.format("seg_id:%d, offset:%d, address:%s, next_seg:%s, %s%n", idx, offset, Long.toHexString(SchemaFile.getGlobalIndex(this.pageIndex, idx)), seg.getNextSegAddress() == -1L ? Integer.valueOf(-1) : Long.toHexString(seg.getNextSegAddress()), seg.inspect()));
        }
        return builder.toString();
    }

    @Override
    public synchronized void syncPageBuffer() {
        super.syncPageBuffer();
        for (Map.Entry<Short, ISegment<ByteBuffer, ICachedMNode>> entry : this.segCacheMap.entrySet()) {
            entry.getValue().syncBuffer();
        }
        this.pageBuffer.position(16384 - this.memberNum * 2);
        Iterator<Object> iterator = this.segOffsetLst.iterator();
        while (iterator.hasNext()) {
            short offset = (Short)iterator.next();
            ReadWriteIOUtils.write((short)offset, (ByteBuffer)this.pageBuffer);
        }
    }

    @Override
    public ISegmentedPage getAsSegmentedPage() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBuffer getEntireSegmentSlice() throws MetadataException {
        if (this.segOffsetLst.size() != 1 || this.segOffsetLst.get(0) != 32 || this.spareSize != 0 || this.spareOffset != this.pageBuffer.capacity() - 2) {
            throw new MetadataException("SegmentedPage can share entire buffer slice only when it contains one MAX SIZE segment.");
        }
        this.segCacheMap.clear();
        ByteBuffer byteBuffer = this.pageBuffer;
        synchronized (byteBuffer) {
            this.pageBuffer.position(32);
            this.pageBuffer.limit(this.pageBuffer.capacity() - 2);
            return this.pageBuffer.slice();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ISegment<ByteBuffer, ICachedMNode> getSegment(short index) throws SegmentNotFoundException {
        ISegment<ByteBuffer, ICachedMNode> res;
        if (this.segOffsetLst.size() <= index || this.segOffsetLst.get(index) < 0) {
            throw new SegmentNotFoundException(this.pageIndex, index);
        }
        Map<Short, ISegment<ByteBuffer, ICachedMNode>> map = this.segCacheMap;
        synchronized (map) {
            if (this.segCacheMap.containsKey(index)) {
                return this.segCacheMap.get(index);
            }
        }
        ByteBuffer bufferR = this.pageBuffer.duplicate();
        bufferR.clear();
        bufferR.position(this.getSegmentOffset(index));
        bufferR.limit(bufferR.position() + WrappedSegment.getSegBufLen(bufferR));
        try {
            res = WrappedSegment.loadAsSegment(bufferR.slice());
        }
        catch (RecordDuplicatedException e) {
            throw new SegmentNotFoundException(e.getMessage());
        }
        Map<Short, ISegment<ByteBuffer, ICachedMNode>> map2 = this.segCacheMap;
        synchronized (map2) {
            if (this.segCacheMap.containsKey(index)) {
                return this.segCacheMap.get(index);
            }
            this.segCacheMap.put(index, res);
            return res;
        }
    }

    private short getSegmentOffset(short index) throws SegmentNotFoundException {
        if (index >= this.segOffsetLst.size() || this.segOffsetLst.get(index) < 0) {
            throw new SegmentNotFoundException(this.pageIndex, index);
        }
        return this.segOffsetLst.get(index);
    }

    private ISegment<ByteBuffer, ICachedMNode> relocateSegment(ISegment<?, ?> seg, short segIdx, short newSize) throws MetadataException {
        if (seg.size() == 16350 || this.getSpareSize() + seg.size() < newSize) {
            return null;
        }
        ByteBuffer newBuffer = this.allocSpareBufferSlice(newSize);
        if (newBuffer == null) {
            this.rearrangeSegments(segIdx);
            return this.extendSegmentInPlace(segIdx, seg.size(), newSize);
        }
        seg.extendsTo(newBuffer);
        ISegment<ByteBuffer, ICachedMNode> newSeg = WrappedSegment.loadAsSegment(newBuffer);
        this.segOffsetLst.set(segIdx, this.spareOffset);
        this.segCacheMap.put(segIdx, newSeg);
        this.spareOffset = (short)(this.spareOffset + newSeg.size());
        this.spareSize = (short)(this.spareSize - (short)(newSize - seg.size()));
        return newSeg;
    }

    private short maxAppendableSegmentSize() {
        return (short)(this.pageBuffer.limit() - 2 * (this.memberNum + 1) - this.spareOffset);
    }

    private ByteBuffer allocSpareBufferSlice(short size) {
        if (this.pageBuffer.capacity() - this.spareOffset - this.memberNum * 2 < size + 2) {
            return null;
        }
        this.pageBuffer.clear();
        this.pageBuffer.position(this.spareOffset);
        this.pageBuffer.limit(this.spareOffset + size);
        return this.pageBuffer.slice();
    }

    private void compactSegments() {
        this.rearrangeSegments((short)-1);
    }

    private synchronized void rearrangeSegments(short idx) {
        short len;
        this.syncPageBuffer();
        this.segCacheMap.clear();
        ByteBuffer mirrorPage = ByteBuffer.allocate(this.pageBuffer.capacity());
        this.pageBuffer.clear();
        mirrorPage.put(this.pageBuffer);
        this.pageBuffer.clear();
        this.spareOffset = (short)32;
        for (int i = 0; i < this.segOffsetLst.size(); i = (int)((short)(i + 1))) {
            if (this.segOffsetLst.get(i) < 0 || i == idx) continue;
            short offset = this.segOffsetLst.get(i);
            mirrorPage.clear();
            this.pageBuffer.clear();
            mirrorPage.position(offset);
            len = WrappedSegment.getSegBufLen(mirrorPage);
            mirrorPage.limit(offset + len);
            this.segOffsetLst.set(i, this.spareOffset);
            this.pageBuffer.position(this.spareOffset);
            this.pageBuffer.put(mirrorPage);
            this.spareOffset = (short)(this.spareOffset + len);
        }
        if (idx >= 0) {
            this.pageBuffer.clear();
            this.pageBuffer.position(this.spareOffset);
            mirrorPage.clear();
            mirrorPage.position(this.segOffsetLst.get(idx).shortValue());
            len = WrappedSegment.getSegBufLen(mirrorPage);
            mirrorPage.limit(mirrorPage.position() + len);
            this.pageBuffer.put(mirrorPage);
            this.segOffsetLst.set(idx, this.spareOffset);
            this.spareOffset = (short)(this.spareOffset + len);
        }
        this.spareSize = (short)(this.pageBuffer.capacity() - this.spareOffset - this.memberNum * 2);
    }

    private ISegment<ByteBuffer, ICachedMNode> extendSegmentInPlace(short segId, short oriSegSize, short newSize) throws MetadataException {
        short offset = this.getSegmentOffset(segId);
        if (offset + oriSegSize != this.spareOffset) {
            throw new SegmentNotFoundException(segId);
        }
        ByteBuffer newBuffer = ByteBuffer.allocate(newSize);
        this.getSegment(segId).extendsTo(newBuffer);
        this.pageBuffer.clear();
        this.pageBuffer.position(offset);
        newBuffer.clear();
        this.pageBuffer.put(newBuffer);
        this.pageBuffer.position(offset);
        this.pageBuffer.limit(offset + newSize);
        ISegment<ByteBuffer, ICachedMNode> newSeg = WrappedSegment.loadAsSegment(this.pageBuffer.slice());
        this.segOffsetLst.set(segId, offset);
        this.segCacheMap.put(segId, newSeg);
        this.spareOffset = (short)(offset + newSeg.size());
        this.spareSize = (short)(this.spareSize - (newSize - oriSegSize));
        return newSeg;
    }

    public void updateRecordSegAddr(short segId, String key, long newSegAddr) throws SegmentNotFoundException {
        ISegment<ByteBuffer, ICachedMNode> seg = this.getSegment(segId);
        ((WrappedSegment)seg).updateRecordSegAddr(key, newSegAddr);
    }

    private synchronized short registerNewSegment(ISegment<ByteBuffer, ICachedMNode> seg) throws MetadataException {
        short thisIndex = (short)this.segOffsetLst.size();
        if (this.segCacheMap.containsKey(thisIndex)) {
            throw new MetadataException(String.format("Segment cache map inconsistent with segment list in page %d.", this.pageIndex));
        }
        this.segCacheMap.put(thisIndex, seg);
        this.segOffsetLst.add(this.spareOffset);
        this.spareOffset = (short)(this.spareOffset + seg.size());
        this.spareSize = (short)(this.spareSize - (seg.size() + 2));
        this.memberNum = (short)(this.memberNum + 1);
        return thisIndex;
    }

    @Override
    public WrappedSegment getSegmentOnTest(short idx) throws SegmentNotFoundException {
        return (WrappedSegment)this.getSegment(idx);
    }
}

