/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.transformation.dag.column.binary;

import org.apache.iotdb.db.queryengine.transformation.dag.column.ColumnTransformer;
import org.apache.iotdb.db.queryengine.transformation.dag.column.binary.LogicBinaryColumnTransformer;
import org.apache.iotdb.tsfile.read.common.block.column.Column;
import org.apache.iotdb.tsfile.read.common.block.column.ColumnBuilder;
import org.apache.iotdb.tsfile.read.common.type.Type;

public class LogicAndColumnTransformer
extends LogicBinaryColumnTransformer {
    public LogicAndColumnTransformer(Type returnType, ColumnTransformer leftTransformer, ColumnTransformer rightTransformer) {
        super(returnType, leftTransformer, rightTransformer);
    }

    @Override
    protected void doTransform(Column leftColumn, Column rightColumn, ColumnBuilder builder, int positionCount) {
        for (int i = 0; i < positionCount; ++i) {
            if (!leftColumn.isNull(i) && !rightColumn.isNull(i)) {
                this.returnType.writeBoolean(builder, this.transform(this.leftTransformer.getType().getBoolean(leftColumn, i), this.rightTransformer.getType().getBoolean(rightColumn, i)));
                continue;
            }
            if (!leftColumn.isNull(i)) {
                if (this.leftTransformer.getType().getBoolean(leftColumn, i)) {
                    builder.appendNull();
                    continue;
                }
                this.returnType.writeBoolean(builder, false);
                continue;
            }
            if (!rightColumn.isNull(i)) {
                if (this.rightTransformer.getType().getBoolean(rightColumn, i)) {
                    builder.appendNull();
                    continue;
                }
                this.returnType.writeBoolean(builder, false);
                continue;
            }
            builder.appendNull();
        }
    }

    @Override
    protected boolean transform(boolean left, boolean right) {
        return left && right;
    }
}

