/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.statement.metadata;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.auth.entity.PrivilegeType;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.auth.AuthorityChecker;
import org.apache.iotdb.db.queryengine.plan.statement.Statement;
import org.apache.iotdb.db.queryengine.plan.statement.StatementType;
import org.apache.iotdb.db.queryengine.plan.statement.StatementVisitor;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;

public class CreateMultiTimeSeriesStatement
extends Statement {
    private List<PartialPath> paths;
    private List<TSDataType> dataTypes = new ArrayList<TSDataType>();
    private List<TSEncoding> encodings = new ArrayList<TSEncoding>();
    private List<CompressionType> compressors = new ArrayList<CompressionType>();
    private List<Map<String, String>> propsList;
    private List<String> aliasList;
    private List<Map<String, String>> tagsList;
    private List<Map<String, String>> attributesList;

    public CreateMultiTimeSeriesStatement() {
        this.statementType = StatementType.CREATE_MULTI_TIME_SERIES;
    }

    @Override
    public List<PartialPath> getPaths() {
        return this.paths;
    }

    @Override
    public TSStatus checkPermissionBeforeProcess(String userName) {
        if (AuthorityChecker.SUPER_USER.equals(userName)) {
            return new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
        }
        List<PartialPath> checkedPaths = this.getPaths();
        return AuthorityChecker.getTSStatus(AuthorityChecker.checkFullPathListPermission(userName, checkedPaths, PrivilegeType.WRITE_SCHEMA.ordinal()), checkedPaths, PrivilegeType.WRITE_SCHEMA);
    }

    public void setPaths(List<PartialPath> paths) {
        this.paths = paths;
    }

    public List<TSDataType> getDataTypes() {
        return this.dataTypes;
    }

    public void setDataTypes(List<TSDataType> dataTypes) {
        this.dataTypes = dataTypes;
    }

    public List<TSEncoding> getEncodings() {
        return this.encodings;
    }

    public void setEncodings(List<TSEncoding> encodings) {
        this.encodings = encodings;
    }

    public List<CompressionType> getCompressors() {
        return this.compressors;
    }

    public void setCompressors(List<CompressionType> compressors) {
        this.compressors = compressors;
    }

    public List<Map<String, String>> getPropsList() {
        return this.propsList;
    }

    public void setPropsList(List<Map<String, String>> propsList) {
        this.propsList = propsList;
    }

    public List<String> getAliasList() {
        return this.aliasList;
    }

    public void setAliasList(List<String> aliasList) {
        this.aliasList = aliasList;
    }

    public List<Map<String, String>> getTagsList() {
        return this.tagsList;
    }

    public void setTagsList(List<Map<String, String>> tagsList) {
        this.tagsList = tagsList;
    }

    public List<Map<String, String>> getAttributesList() {
        return this.attributesList;
    }

    public void setAttributesList(List<Map<String, String>> attributesList) {
        this.attributesList = attributesList;
    }

    public void addAttributesList(Map<String, String> attributes) {
        this.attributesList.add(attributes);
    }

    @Override
    public <R, C> R accept(StatementVisitor<R, C> visitor, C context) {
        return visitor.visitCreateMultiTimeseries(this, context);
    }

    public String toString() {
        return "CreateMultiTimeSeriesStatement{paths=" + this.paths + ", dataTypes=" + this.dataTypes + ", encodings=" + this.encodings + ", compressors=" + this.compressors + ", propsList=" + this.propsList + ", aliasList=" + this.aliasList + ", tagsList=" + this.tagsList + ", attributesList=" + this.attributesList + "}";
    }
}

