/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.planner.plan.node.metedata.write;

import com.google.common.collect.ImmutableList;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.queryengine.plan.analyze.Analysis;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.WritePlanNode;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.AlterTimeSeriesStatement;
import org.apache.iotdb.tsfile.exception.NotImplementedException;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class AlterTimeSeriesNode
extends WritePlanNode {
    private PartialPath path;
    private AlterTimeSeriesStatement.AlterType alterType;
    private Map<String, String> alterMap;
    private String alias;
    private Map<String, String> tagsMap;
    private Map<String, String> attributesMap;
    private boolean isAlterView;
    private TRegionReplicaSet regionReplicaSet;

    public AlterTimeSeriesNode(PlanNodeId id, PartialPath path, AlterTimeSeriesStatement.AlterType alterType, Map<String, String> alterMap, String alias, Map<String, String> tagsMap, Map<String, String> attributesMap, boolean isAlterView) {
        super(id);
        this.path = path;
        this.alterType = alterType;
        this.alterMap = alterMap;
        this.alias = alias;
        this.tagsMap = tagsMap;
        this.attributesMap = attributesMap;
        this.isAlterView = isAlterView;
    }

    public PartialPath getPath() {
        return this.path;
    }

    public void setPath(PartialPath path) {
        this.path = path;
    }

    public AlterTimeSeriesStatement.AlterType getAlterType() {
        return this.alterType;
    }

    public void setAlterType(AlterTimeSeriesStatement.AlterType alterType) {
        this.alterType = alterType;
    }

    public Map<String, String> getAlterMap() {
        return this.alterMap;
    }

    public void setAlterMap(Map<String, String> alterMap) {
        this.alterMap = alterMap;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public Map<String, String> getTagsMap() {
        return this.tagsMap;
    }

    public void setTagsMap(Map<String, String> tagsMap) {
        this.tagsMap = tagsMap;
    }

    public Map<String, String> getAttributesMap() {
        return this.attributesMap;
    }

    public void setAttributesMap(Map<String, String> attributesMap) {
        this.attributesMap = attributesMap;
    }

    public boolean isAlterView() {
        return this.isAlterView;
    }

    public void setAlterView(boolean alterView) {
        this.isAlterView = alterView;
    }

    @Override
    public List<PlanNode> getChildren() {
        return null;
    }

    @Override
    public void addChild(PlanNode child) {
    }

    @Override
    public PlanNodeType getType() {
        return PlanNodeType.ALTER_TIME_SERIES;
    }

    @Override
    public PlanNode clone() {
        throw new NotImplementedException("Clone of AlterTimeSeriesNode is not implemented");
    }

    @Override
    public int allowedChildCount() {
        return 0;
    }

    @Override
    public List<String> getOutputColumnNames() {
        return null;
    }

    public static AlterTimeSeriesNode deserialize(ByteBuffer byteBuffer) {
        byte label;
        PartialPath path;
        String alias = null;
        HashMap<String, String> alterMap = null;
        HashMap<String, String> tagsMap = null;
        HashMap<String, String> attributesMap = null;
        int length = byteBuffer.getInt();
        byte[] bytes = new byte[length];
        byteBuffer.get(bytes);
        try {
            path = new PartialPath(new String(bytes));
        }
        catch (IllegalPathException e) {
            throw new IllegalArgumentException("Can not deserialize AlterTimeSeriesNode", e);
        }
        boolean isAlterView = false;
        byte alterTypeOrdinal = byteBuffer.get();
        if (alterTypeOrdinal == -1) {
            isAlterView = true;
            alterTypeOrdinal = byteBuffer.get();
        }
        AlterTimeSeriesStatement.AlterType alterType = AlterTimeSeriesStatement.AlterType.values()[alterTypeOrdinal];
        if (byteBuffer.get() == 1) {
            alias = ReadWriteIOUtils.readString((ByteBuffer)byteBuffer);
        }
        if ((label = byteBuffer.get()) == 0) {
            alterMap = new HashMap();
        } else if (label == 1) {
            alterMap = ReadWriteIOUtils.readMap((ByteBuffer)byteBuffer);
        }
        label = byteBuffer.get();
        if (label == 0) {
            tagsMap = new HashMap();
        } else if (label == 1) {
            tagsMap = ReadWriteIOUtils.readMap((ByteBuffer)byteBuffer);
        }
        label = byteBuffer.get();
        if (label == 0) {
            attributesMap = new HashMap();
        } else if (label == 1) {
            attributesMap = ReadWriteIOUtils.readMap((ByteBuffer)byteBuffer);
        }
        String id = ReadWriteIOUtils.readString((ByteBuffer)byteBuffer);
        return new AlterTimeSeriesNode(new PlanNodeId(id), path, alterType, alterMap, alias, tagsMap, attributesMap, isAlterView);
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C schemaRegion) {
        return visitor.visitAlterTimeSeries(this, schemaRegion);
    }

    @Override
    protected void serializeAttributes(ByteBuffer byteBuffer) {
        PlanNodeType.ALTER_TIME_SERIES.serialize(byteBuffer);
        byte[] bytes = this.path.getFullPath().getBytes();
        ReadWriteIOUtils.write((int)bytes.length, (ByteBuffer)byteBuffer);
        byteBuffer.put(bytes);
        if (this.isAlterView) {
            byteBuffer.put((byte)-1);
        }
        byteBuffer.put((byte)this.alterType.ordinal());
        if (this.alias != null) {
            byteBuffer.put((byte)1);
            ReadWriteIOUtils.write((String)this.alias, (ByteBuffer)byteBuffer);
        } else {
            byteBuffer.put((byte)0);
        }
        if (this.alterMap == null) {
            byteBuffer.put((byte)-1);
        } else if (this.alterMap.isEmpty()) {
            byteBuffer.put((byte)0);
        } else {
            byteBuffer.put((byte)1);
            ReadWriteIOUtils.write(this.alterMap, (ByteBuffer)byteBuffer);
        }
        if (this.tagsMap == null) {
            byteBuffer.put((byte)-1);
        } else if (this.tagsMap.isEmpty()) {
            byteBuffer.put((byte)0);
        } else {
            byteBuffer.put((byte)1);
            ReadWriteIOUtils.write(this.tagsMap, (ByteBuffer)byteBuffer);
        }
        if (this.attributesMap == null) {
            byteBuffer.put((byte)-1);
        } else if (this.attributesMap.isEmpty()) {
            byteBuffer.put((byte)0);
        } else {
            byteBuffer.put((byte)1);
            ReadWriteIOUtils.write(this.attributesMap, (ByteBuffer)byteBuffer);
        }
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
        PlanNodeType.ALTER_TIME_SERIES.serialize(stream);
        byte[] bytes = this.path.getFullPath().getBytes();
        ReadWriteIOUtils.write((int)bytes.length, (OutputStream)stream);
        stream.write(bytes);
        if (this.isAlterView) {
            stream.write(-1);
        }
        stream.write((byte)this.alterType.ordinal());
        if (this.alias != null) {
            stream.write(1);
            ReadWriteIOUtils.write((String)this.alias, (OutputStream)stream);
        } else {
            stream.write(0);
        }
        if (this.alterMap == null) {
            stream.write(-1);
        } else if (this.alterMap.isEmpty()) {
            stream.write(0);
        } else {
            stream.write(1);
            ReadWriteIOUtils.write(this.alterMap, (OutputStream)stream);
        }
        if (this.tagsMap == null) {
            stream.write(-1);
        } else if (this.tagsMap.isEmpty()) {
            stream.write(0);
        } else {
            stream.write(1);
            ReadWriteIOUtils.write(this.tagsMap, (OutputStream)stream);
        }
        if (this.attributesMap == null) {
            stream.write(-1);
        } else if (this.attributesMap.isEmpty()) {
            stream.write(0);
        } else {
            stream.write(1);
            ReadWriteIOUtils.write(this.attributesMap, (OutputStream)stream);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AlterTimeSeriesNode that = (AlterTimeSeriesNode)o;
        return this.getPlanNodeId().equals(that.getPlanNodeId()) && Objects.equals(this.path, that.path) && this.alterType == that.alterType && Objects.equals(this.alterMap, that.alterMap) && Objects.equals(this.alias, that.alias) && Objects.equals(this.tagsMap, that.tagsMap) && Objects.equals(this.attributesMap, that.attributesMap);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.getPlanNodeId(), this.path, this.alias, this.alterType, this.alterMap, this.attributesMap, this.tagsMap});
    }

    @Override
    public TRegionReplicaSet getRegionReplicaSet() {
        return this.regionReplicaSet;
    }

    public void setRegionReplicaSet(TRegionReplicaSet regionReplicaSet) {
        this.regionReplicaSet = regionReplicaSet;
    }

    @Override
    public List<WritePlanNode> splitByPartition(Analysis analysis) {
        TRegionReplicaSet regionReplicaSet = analysis.getSchemaPartitionInfo().getSchemaRegionReplicaSet(this.path.getDevice());
        this.setRegionReplicaSet(regionReplicaSet);
        return ImmutableList.of((Object)this);
    }
}

