/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.planner;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.client.IClientManager;
import org.apache.iotdb.commons.client.async.AsyncDataNodeInternalServiceClient;
import org.apache.iotdb.commons.client.sync.SyncDataNodeInternalServiceClient;
import org.apache.iotdb.db.queryengine.common.MPPQueryContext;
import org.apache.iotdb.db.queryengine.execution.QueryStateMachine;
import org.apache.iotdb.db.queryengine.plan.analyze.Analysis;
import org.apache.iotdb.db.queryengine.plan.analyze.Analyzer;
import org.apache.iotdb.db.queryengine.plan.analyze.IAnalysis;
import org.apache.iotdb.db.queryengine.plan.analyze.IPartitionFetcher;
import org.apache.iotdb.db.queryengine.plan.analyze.schema.ISchemaFetcher;
import org.apache.iotdb.db.queryengine.plan.planner.IPlanner;
import org.apache.iotdb.db.queryengine.plan.planner.LogicalPlanner;
import org.apache.iotdb.db.queryengine.plan.planner.distribution.DistributionPlanner;
import org.apache.iotdb.db.queryengine.plan.planner.plan.DistributedQueryPlan;
import org.apache.iotdb.db.queryengine.plan.planner.plan.LogicalQueryPlan;
import org.apache.iotdb.db.queryengine.plan.scheduler.ClusterScheduler;
import org.apache.iotdb.db.queryengine.plan.scheduler.IScheduler;
import org.apache.iotdb.db.queryengine.plan.scheduler.load.LoadTsFileScheduler;
import org.apache.iotdb.db.queryengine.plan.statement.Statement;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertBaseStatement;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertMultiTabletsStatement;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertRowsStatement;
import org.apache.iotdb.db.queryengine.plan.statement.crud.LoadTsFileStatement;
import org.apache.iotdb.db.queryengine.plan.statement.pipe.PipeEnrichedStatement;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;

public class TreeModelPlanner
implements IPlanner {
    private final Statement statement;
    private final ExecutorService executor;
    private final ExecutorService writeOperationExecutor;
    private final ScheduledExecutorService scheduledExecutor;
    private final IPartitionFetcher partitionFetcher;
    private final ISchemaFetcher schemaFetcher;
    private final IClientManager<TEndPoint, SyncDataNodeInternalServiceClient> syncInternalServiceClientManager;
    private final IClientManager<TEndPoint, AsyncDataNodeInternalServiceClient> asyncInternalServiceClientManager;

    public TreeModelPlanner(Statement statement, ExecutorService executor, ExecutorService writeOperationExecutor, ScheduledExecutorService scheduledExecutor, IPartitionFetcher partitionFetcher, ISchemaFetcher schemaFetcher, IClientManager<TEndPoint, SyncDataNodeInternalServiceClient> syncInternalServiceClientManager, IClientManager<TEndPoint, AsyncDataNodeInternalServiceClient> asyncInternalServiceClientManager) {
        this.statement = statement;
        this.executor = executor;
        this.writeOperationExecutor = writeOperationExecutor;
        this.scheduledExecutor = scheduledExecutor;
        this.partitionFetcher = partitionFetcher;
        this.schemaFetcher = schemaFetcher;
        this.syncInternalServiceClientManager = syncInternalServiceClientManager;
        this.asyncInternalServiceClientManager = asyncInternalServiceClientManager;
    }

    @Override
    public IAnalysis analyze(MPPQueryContext context) {
        return new Analyzer(context, this.partitionFetcher, this.schemaFetcher).analyze(this.statement);
    }

    @Override
    public LogicalQueryPlan doLogicalPlan(IAnalysis analysis, MPPQueryContext context) {
        LogicalPlanner logicalPlanner = new LogicalPlanner(context);
        return logicalPlanner.plan((Analysis)analysis);
    }

    @Override
    public DistributedQueryPlan doDistributionPlan(IAnalysis analysis, LogicalQueryPlan logicalPlan) {
        DistributionPlanner planner = new DistributionPlanner((Analysis)analysis, logicalPlan);
        return planner.planFragments();
    }

    @Override
    public IScheduler doSchedule(IAnalysis analysis, DistributedQueryPlan distributedPlan, MPPQueryContext context, QueryStateMachine stateMachine) {
        boolean isPipeEnrichedTsFileLoad = this.statement instanceof PipeEnrichedStatement && ((PipeEnrichedStatement)this.statement).getInnerStatement() instanceof LoadTsFileStatement;
        IScheduler scheduler = this.statement instanceof LoadTsFileStatement || isPipeEnrichedTsFileLoad ? new LoadTsFileScheduler(distributedPlan, context, stateMachine, this.syncInternalServiceClientManager, this.partitionFetcher, isPipeEnrichedTsFileLoad) : new ClusterScheduler(context, stateMachine, distributedPlan.getInstances(), context.getQueryType(), this.executor, this.writeOperationExecutor, this.scheduledExecutor, this.syncInternalServiceClientManager, this.asyncInternalServiceClientManager);
        scheduler.start();
        return scheduler;
    }

    @Override
    public void invalidatePartitionCache() {
        this.partitionFetcher.invalidAllCache();
    }

    @Override
    public ScheduledExecutorService getScheduledExecutorService() {
        return this.scheduledExecutor;
    }

    @Override
    public void setRedirectInfo(IAnalysis iAnalysis, TEndPoint localEndPoint, TSStatus tsstatus, TSStatusCode statusCode) {
        Analysis analysis = (Analysis)iAnalysis;
        if (analysis.getStatement() instanceof InsertBaseStatement && !analysis.isFinishQueryAfterAnalyze()) {
            InsertBaseStatement insertStatement = (InsertBaseStatement)analysis.getStatement();
            List<TEndPoint> redirectNodeList = analysis.getRedirectNodeList();
            if (insertStatement instanceof InsertRowsStatement || insertStatement instanceof InsertMultiTabletsStatement) {
                if (statusCode == TSStatusCode.SUCCESS_STATUS) {
                    boolean needRedirect = false;
                    ArrayList<TSStatus> subStatus = new ArrayList<TSStatus>();
                    for (TEndPoint endPoint : redirectNodeList) {
                        if (!localEndPoint.equals(endPoint)) {
                            subStatus.add(RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS).setRedirectNode(endPoint));
                            needRedirect = true;
                            continue;
                        }
                        subStatus.add(RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS));
                    }
                    if (needRedirect) {
                        tsstatus.setCode(TSStatusCode.REDIRECTION_RECOMMEND.getStatusCode());
                        tsstatus.setSubStatus(subStatus);
                    }
                }
            } else {
                TEndPoint redirectEndPoint = redirectNodeList.get(0);
                if (!localEndPoint.equals(redirectEndPoint)) {
                    tsstatus.setRedirectNode(redirectEndPoint);
                }
            }
        }
    }
}

