/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.aggregation;

import com.google.common.base.Preconditions;
import org.apache.iotdb.db.queryengine.execution.aggregation.Accumulator;
import org.apache.iotdb.tsfile.exception.write.UnSupportedDataTypeException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.read.common.block.column.Column;
import org.apache.iotdb.tsfile.read.common.block.column.ColumnBuilder;
import org.apache.iotdb.tsfile.utils.BitMap;
import org.apache.iotdb.tsfile.utils.TsPrimitiveType;

public class MinValueAccumulator
implements Accumulator {
    private final TSDataType seriesDataType;
    private final TsPrimitiveType minResult;
    private boolean initResult = false;

    public MinValueAccumulator(TSDataType seriesDataType) {
        this.seriesDataType = seriesDataType;
        this.minResult = TsPrimitiveType.getByType((TSDataType)seriesDataType);
    }

    @Override
    public void addInput(Column[] columns, BitMap bitMap) {
        switch (this.seriesDataType) {
            case INT32: {
                this.addIntInput(columns, bitMap);
                return;
            }
            case INT64: {
                this.addLongInput(columns, bitMap);
                return;
            }
            case FLOAT: {
                this.addFloatInput(columns, bitMap);
                return;
            }
            case DOUBLE: {
                this.addDoubleInput(columns, bitMap);
                return;
            }
        }
        throw new UnSupportedDataTypeException(String.format("Unsupported data type in MinValue: %s", this.seriesDataType));
    }

    @Override
    public void addIntermediate(Column[] partialResult) {
        Preconditions.checkArgument((partialResult.length == 1 ? 1 : 0) != 0, (Object)"partialResult of MinValue should be 1");
        if (partialResult[0].isNull(0)) {
            return;
        }
        switch (this.seriesDataType) {
            case INT32: {
                this.updateIntResult(partialResult[0].getInt(0));
                break;
            }
            case INT64: {
                this.updateLongResult(partialResult[0].getLong(0));
                break;
            }
            case FLOAT: {
                this.updateFloatResult(partialResult[0].getFloat(0));
                break;
            }
            case DOUBLE: {
                this.updateDoubleResult(partialResult[0].getDouble(0));
                break;
            }
            default: {
                throw new UnSupportedDataTypeException(String.format("Unsupported data type in MinValue: %s", this.seriesDataType));
            }
        }
    }

    @Override
    public void addStatistics(Statistics statistics) {
        if (statistics == null) {
            return;
        }
        switch (this.seriesDataType) {
            case INT32: {
                this.updateIntResult((Integer)statistics.getMinValue());
                break;
            }
            case INT64: {
                this.updateLongResult((Long)statistics.getMinValue());
                break;
            }
            case FLOAT: {
                this.updateFloatResult(((Float)statistics.getMinValue()).floatValue());
                break;
            }
            case DOUBLE: {
                this.updateDoubleResult((Double)statistics.getMinValue());
                break;
            }
            default: {
                throw new UnSupportedDataTypeException(String.format("Unsupported data type in MinValue: %s", this.seriesDataType));
            }
        }
    }

    @Override
    public void setFinal(Column finalResult) {
        if (finalResult.isNull(0)) {
            return;
        }
        this.initResult = true;
        switch (this.seriesDataType) {
            case INT32: {
                this.minResult.setInt(finalResult.getInt(0));
                break;
            }
            case INT64: {
                this.minResult.setLong(finalResult.getLong(0));
                break;
            }
            case FLOAT: {
                this.minResult.setFloat(finalResult.getFloat(0));
                break;
            }
            case DOUBLE: {
                this.minResult.setDouble(finalResult.getDouble(0));
                break;
            }
            default: {
                throw new UnSupportedDataTypeException(String.format("Unsupported data type in MinValue: %s", this.seriesDataType));
            }
        }
    }

    @Override
    public void outputIntermediate(ColumnBuilder[] columnBuilders) {
        Preconditions.checkArgument((columnBuilders.length == 1 ? 1 : 0) != 0, (Object)"partialResult of MinValue should be 1");
        if (!this.initResult) {
            columnBuilders[0].appendNull();
            return;
        }
        switch (this.seriesDataType) {
            case INT32: {
                columnBuilders[0].writeInt(this.minResult.getInt());
                break;
            }
            case INT64: {
                columnBuilders[0].writeLong(this.minResult.getLong());
                break;
            }
            case FLOAT: {
                columnBuilders[0].writeFloat(this.minResult.getFloat());
                break;
            }
            case DOUBLE: {
                columnBuilders[0].writeDouble(this.minResult.getDouble());
                break;
            }
            default: {
                throw new UnSupportedDataTypeException(String.format("Unsupported data type in MinValue: %s", this.seriesDataType));
            }
        }
    }

    @Override
    public void outputFinal(ColumnBuilder columnBuilder) {
        if (!this.initResult) {
            columnBuilder.appendNull();
            return;
        }
        switch (this.seriesDataType) {
            case INT32: {
                columnBuilder.writeInt(this.minResult.getInt());
                break;
            }
            case INT64: {
                columnBuilder.writeLong(this.minResult.getLong());
                break;
            }
            case FLOAT: {
                columnBuilder.writeFloat(this.minResult.getFloat());
                break;
            }
            case DOUBLE: {
                columnBuilder.writeDouble(this.minResult.getDouble());
                break;
            }
            default: {
                throw new UnSupportedDataTypeException(String.format("Unsupported data type in MinValue: %s", this.seriesDataType));
            }
        }
    }

    @Override
    public void reset() {
        this.initResult = false;
        this.minResult.reset();
    }

    @Override
    public boolean hasFinalResult() {
        return false;
    }

    @Override
    public TSDataType[] getIntermediateType() {
        return new TSDataType[]{this.minResult.getDataType()};
    }

    @Override
    public TSDataType getFinalType() {
        return this.minResult.getDataType();
    }

    private void addIntInput(Column[] column, BitMap bitMap) {
        int count = column[0].getPositionCount();
        for (int i = 0; i < count; ++i) {
            if (bitMap != null && !bitMap.isMarked(i) || column[1].isNull(i)) continue;
            this.updateIntResult(column[1].getInt(i));
        }
    }

    private void updateIntResult(int minVal) {
        if (!this.initResult || minVal < this.minResult.getInt()) {
            this.initResult = true;
            this.minResult.setInt(minVal);
        }
    }

    private void addLongInput(Column[] column, BitMap bitMap) {
        int count = column[0].getPositionCount();
        for (int i = 0; i < count; ++i) {
            if (bitMap != null && !bitMap.isMarked(i) || column[1].isNull(i)) continue;
            this.updateLongResult(column[1].getLong(i));
        }
    }

    private void updateLongResult(long minVal) {
        if (!this.initResult || minVal < this.minResult.getLong()) {
            this.initResult = true;
            this.minResult.setLong(minVal);
        }
    }

    private void addFloatInput(Column[] column, BitMap bitMap) {
        int count = column[0].getPositionCount();
        for (int i = 0; i < count; ++i) {
            if (bitMap != null && !bitMap.isMarked(i) || column[1].isNull(i)) continue;
            this.updateFloatResult(column[1].getFloat(i));
        }
    }

    private void updateFloatResult(float minVal) {
        if (!this.initResult || minVal < this.minResult.getFloat()) {
            this.initResult = true;
            this.minResult.setFloat(minVal);
        }
    }

    private void addDoubleInput(Column[] column, BitMap bitMap) {
        int count = column[0].getPositionCount();
        for (int i = 0; i < count; ++i) {
            if (bitMap != null && !bitMap.isMarked(i) || column[1].isNull(i)) continue;
            this.updateDoubleResult(column[1].getDouble(i));
        }
    }

    private void updateDoubleResult(double minVal) {
        if (!this.initResult || minVal < this.minResult.getDouble()) {
            this.initResult = true;
            this.minResult.setDouble(minVal);
        }
    }
}

