/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.task.subtask.connector;

import org.apache.iotdb.commons.exception.pipe.PipeRuntimeException;
import org.apache.iotdb.commons.pipe.config.PipeConfig;
import org.apache.iotdb.commons.pipe.event.EnrichedEvent;
import org.apache.iotdb.commons.pipe.task.connection.BoundedBlockingPendingQueue;
import org.apache.iotdb.commons.pipe.task.subtask.PipeAbstractConnectorSubtask;
import org.apache.iotdb.db.pipe.agent.PipeAgent;
import org.apache.iotdb.db.pipe.connector.protocol.thrift.async.IoTDBDataRegionAsyncConnector;
import org.apache.iotdb.db.pipe.event.UserDefinedEnrichedEvent;
import org.apache.iotdb.db.pipe.event.common.heartbeat.PipeHeartbeatEvent;
import org.apache.iotdb.db.pipe.metric.PipeConnectorMetrics;
import org.apache.iotdb.db.pipe.task.connection.PipeEventCollector;
import org.apache.iotdb.db.utils.ErrorHandlingUtils;
import org.apache.iotdb.pipe.api.PipeConnector;
import org.apache.iotdb.pipe.api.event.Event;
import org.apache.iotdb.pipe.api.event.dml.insertion.TabletInsertionEvent;
import org.apache.iotdb.pipe.api.event.dml.insertion.TsFileInsertionEvent;
import org.apache.iotdb.pipe.api.exception.PipeConnectionException;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeConnectorSubtask
extends PipeAbstractConnectorSubtask {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeConnectorSubtask.class);
    protected final BoundedBlockingPendingQueue<Event> inputPendingQueue;
    private final String attributeSortedString;
    private final int connectorIndex;
    private static final PipeHeartbeatEvent CRON_HEARTBEAT_EVENT = new PipeHeartbeatEvent("cron", false);
    private static final long CRON_HEARTBEAT_EVENT_INJECT_INTERVAL_MILLISECONDS = PipeConfig.getInstance().getPipeSubtaskExecutorCronHeartbeatEventIntervalSeconds() * 1000L;
    private long lastHeartbeatEventInjectTime = System.currentTimeMillis();

    public PipeConnectorSubtask(String taskID, long creationTime, String attributeSortedString, int connectorIndex, BoundedBlockingPendingQueue<Event> inputPendingQueue, PipeConnector outputPipeConnector) {
        super(taskID, creationTime, outputPipeConnector);
        this.attributeSortedString = attributeSortedString;
        this.connectorIndex = connectorIndex;
        this.inputPendingQueue = inputPendingQueue;
        PipeConnectorMetrics.getInstance().register(this);
    }

    protected boolean executeOnce() {
        if (this.isClosed.get()) {
            return false;
        }
        Event event = this.lastEvent != null ? this.lastEvent : UserDefinedEnrichedEvent.maybeOf(this.inputPendingQueue.waitedPoll());
        this.setLastEvent(event);
        try {
            if (event == null) {
                if (System.currentTimeMillis() - this.lastHeartbeatEventInjectTime > CRON_HEARTBEAT_EVENT_INJECT_INTERVAL_MILLISECONDS) {
                    this.transferHeartbeatEvent(CRON_HEARTBEAT_EVENT);
                }
                return false;
            }
            if (event instanceof TabletInsertionEvent) {
                this.outputPipeConnector.transfer((TabletInsertionEvent)event);
                PipeConnectorMetrics.getInstance().markTabletEvent(this.taskID);
            } else if (event instanceof TsFileInsertionEvent) {
                this.outputPipeConnector.transfer((TsFileInsertionEvent)event);
                PipeConnectorMetrics.getInstance().markTsFileEvent(this.taskID);
            } else if (event instanceof PipeHeartbeatEvent) {
                this.transferHeartbeatEvent((PipeHeartbeatEvent)event);
            } else {
                this.outputPipeConnector.transfer((Event)(event instanceof UserDefinedEnrichedEvent ? ((UserDefinedEnrichedEvent)event).getUserDefinedEvent() : event));
            }
            this.decreaseReferenceCountAndReleaseLastEvent(true);
        }
        catch (PipeException e) {
            if (!this.isClosed.get()) {
                throw e;
            }
            LOGGER.info("{} in pipe transfer, ignored because pipe is dropped.", (Object)((Object)((Object)e)).getClass().getSimpleName(), (Object)e);
            this.clearReferenceCountAndReleaseLastEvent();
        }
        catch (Exception e) {
            if (!this.isClosed.get()) {
                throw new PipeException(String.format("Exception in pipe transfer, subtask: %s, last event: %s, root cause: %s", this.taskID, this.lastEvent instanceof EnrichedEvent ? ((EnrichedEvent)this.lastEvent).coreReportMessage() : this.lastEvent.toString(), ErrorHandlingUtils.getRootCause(e).getMessage()), (Throwable)e);
            }
            LOGGER.info("Exception in pipe transfer, ignored because pipe is dropped.", (Throwable)e);
            this.clearReferenceCountAndReleaseLastEvent();
        }
        return true;
    }

    private void transferHeartbeatEvent(PipeHeartbeatEvent event) {
        try {
            this.outputPipeConnector.heartbeat();
            this.outputPipeConnector.transfer((Event)event);
        }
        catch (Exception e) {
            throw new PipeConnectionException("PipeConnector: " + this.outputPipeConnector.getClass().getName() + " heartbeat failed, or encountered failure when transferring generic event. Failure: " + e.getMessage(), (Throwable)e);
        }
        this.lastHeartbeatEventInjectTime = System.currentTimeMillis();
        event.onTransferred();
        PipeConnectorMetrics.getInstance().markPipeHeartbeatEvent(this.taskID);
    }

    public void close() {
        PipeConnectorMetrics.getInstance().deregister(this.taskID);
        this.isClosed.set(true);
        try {
            this.outputPipeConnector.close();
        }
        catch (Exception e) {
            LOGGER.info("Exception occurred when closing pipe connector subtask {}, root cause: {}", new Object[]{this.taskID, ErrorHandlingUtils.getRootCause(e).getMessage(), e});
        }
        finally {
            this.inputPendingQueue.forEach(event -> {
                if (event instanceof EnrichedEvent) {
                    ((EnrichedEvent)event).clearReferenceCount(PipeEventCollector.class.getName());
                }
            });
            this.inputPendingQueue.clear();
            super.close();
        }
    }

    public void discardEventsOfPipe(String pipeNameToDrop) {
        if (this.outputPipeConnector instanceof IoTDBDataRegionAsyncConnector) {
            ((IoTDBDataRegionAsyncConnector)this.outputPipeConnector).discardEventsOfPipe(pipeNameToDrop);
        }
    }

    public String getAttributeSortedString() {
        return this.attributeSortedString;
    }

    public int getConnectorIndex() {
        return this.connectorIndex;
    }

    public int getTsFileInsertionEventCount() {
        return this.inputPendingQueue.getTsFileInsertionEventCount();
    }

    public int getTabletInsertionEventCount() {
        return this.inputPendingQueue.getTabletInsertionEventCount();
    }

    public int getPipeHeartbeatEventCount() {
        return this.inputPendingQueue.getPipeHeartbeatEventCount();
    }

    public int getAsyncConnectorRetryEventQueueSize() {
        return this.outputPipeConnector instanceof IoTDBDataRegionAsyncConnector ? ((IoTDBDataRegionAsyncConnector)this.outputPipeConnector).getRetryEventQueueSize() : 0;
    }

    protected String getRootCause(Throwable throwable) {
        return ErrorHandlingUtils.getRootCause(throwable).getMessage();
    }

    protected void report(EnrichedEvent event, PipeRuntimeException exception) {
        PipeAgent.runtime().report(event, exception);
    }
}

