/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.processor.twostage.operator;

import java.util.Queue;
import org.apache.iotdb.db.pipe.processor.twostage.operator.Operator;
import org.apache.iotdb.db.pipe.processor.twostage.state.CountState;
import org.apache.iotdb.db.pipe.processor.twostage.state.State;
import org.apache.iotdb.tsfile.utils.Pair;

public class CountOperator
implements Operator {
    private final long onCompletionTimestamp;
    private long globalCount;
    private final Queue<Pair<Long, Long>> globalCountQueue;

    public CountOperator(String combineId, Queue<Pair<Long, Long>> globalCountQueue) {
        this.onCompletionTimestamp = Long.parseLong(combineId);
        this.globalCount = 0L;
        this.globalCountQueue = globalCountQueue;
    }

    @Override
    public void combine(State state) {
        this.globalCount += ((CountState)state).getCount();
    }

    @Override
    public void onComplete() {
        this.globalCountQueue.add((Pair<Long, Long>)new Pair((Object)this.onCompletionTimestamp, (Object)this.globalCount));
    }
}

