/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.extractor.dataregion.realtime.listener;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.iotdb.db.pipe.extractor.dataregion.realtime.PipeRealtimeDataRegionExtractor;
import org.apache.iotdb.tsfile.utils.Pair;
import org.checkerframework.checker.nullness.qual.NonNull;

public class PipeTimePartitionListener {
    private final Map<String, Map<String, PipeRealtimeDataRegionExtractor>> dataRegionId2Extractors = new ConcurrentHashMap<String, Map<String, PipeRealtimeDataRegionExtractor>>();
    private final Map<String, Pair<Long, Long>> dataRegionId2TimePartitionIdBound = new ConcurrentHashMap<String, Pair<Long, Long>>();

    public synchronized void startListen(String dataRegionId, PipeRealtimeDataRegionExtractor extractor) {
        this.dataRegionId2Extractors.computeIfAbsent(dataRegionId, o -> new HashMap()).put(extractor.getTaskID(), extractor);
        Pair<Long, Long> timePartitionIdBound = this.dataRegionId2TimePartitionIdBound.get(dataRegionId);
        if (Objects.nonNull(timePartitionIdBound)) {
            extractor.setDataRegionTimePartitionIdBound(timePartitionIdBound);
        }
    }

    public synchronized void stopListen(String dataRegionId, PipeRealtimeDataRegionExtractor extractor) {
        Map<String, PipeRealtimeDataRegionExtractor> extractors = this.dataRegionId2Extractors.get(dataRegionId);
        if (Objects.isNull(extractors)) {
            return;
        }
        extractors.remove(extractor.getTaskID());
        if (extractors.isEmpty()) {
            this.dataRegionId2Extractors.remove(dataRegionId);
        }
    }

    public synchronized void listenToTimePartitionGrow(String dataRegionId, @NonNull Pair<Long, Long> newTimePartitionIdBound) {
        boolean shouldBroadcastTimePartitionChange = false;
        Pair<Long, Long> oldTimePartitionIdBound = this.dataRegionId2TimePartitionIdBound.get(dataRegionId);
        if (Objects.isNull(oldTimePartitionIdBound)) {
            this.dataRegionId2TimePartitionIdBound.put(dataRegionId, newTimePartitionIdBound);
            shouldBroadcastTimePartitionChange = true;
        } else if ((Long)newTimePartitionIdBound.left < (Long)oldTimePartitionIdBound.left || (Long)oldTimePartitionIdBound.right < (Long)newTimePartitionIdBound.right) {
            this.dataRegionId2TimePartitionIdBound.put(dataRegionId, (Pair<Long, Long>)new Pair((Object)Math.min((Long)oldTimePartitionIdBound.left, (Long)newTimePartitionIdBound.left), (Object)Math.max((Long)oldTimePartitionIdBound.right, (Long)newTimePartitionIdBound.right)));
            shouldBroadcastTimePartitionChange = true;
        }
        if (shouldBroadcastTimePartitionChange) {
            Map<String, PipeRealtimeDataRegionExtractor> extractors = this.dataRegionId2Extractors.get(dataRegionId);
            if (Objects.isNull(extractors)) {
                return;
            }
            Pair<Long, Long> timePartitionIdBound = this.dataRegionId2TimePartitionIdBound.get(dataRegionId);
            extractors.forEach((id, extractor) -> extractor.setDataRegionTimePartitionIdBound(timePartitionIdBound));
        }
    }

    public static PipeTimePartitionListener getInstance() {
        return PipeTimePartitionListenerHolder.INSTANCE;
    }

    private PipeTimePartitionListener() {
    }

    private static class PipeTimePartitionListenerHolder {
        private static final PipeTimePartitionListener INSTANCE = new PipeTimePartitionListener();

        private PipeTimePartitionListenerHolder() {
        }
    }
}

