/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tool;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.iotdb.cli.type.ExitType;
import org.apache.iotdb.cli.utils.CliContext;
import org.apache.iotdb.cli.utils.IoTPrinter;
import org.apache.iotdb.cli.utils.JlineUtils;
import org.apache.iotdb.exception.ArgsErrorException;
import org.apache.iotdb.isession.SessionDataSet;
import org.apache.iotdb.rpc.IoTDBConnectionException;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.StatementExecutionException;
import org.apache.iotdb.session.Session;
import org.apache.iotdb.tool.AbstractDataTool;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.Field;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.read.common.RowRecord;
import org.apache.thrift.TException;
import org.jline.reader.LineReader;

public class ExportData
extends AbstractDataTool {
    private static final String TARGET_DIR_ARGS = "td";
    private static final String TARGET_DIR_NAME = "targetDirectory";
    private static final String TARGET_FILE_ARGS = "f";
    private static final String TARGET_FILE_NAME = "targetFile";
    private static final String SQL_FILE_ARGS = "s";
    private static final String SQL_FILE_NAME = "sqlfile";
    private static final String DATA_TYPE_ARGS = "datatype";
    private static final String DATA_TYPE_NAME = "datatype";
    private static final String QUERY_COMMAND_ARGS = "q";
    private static final String QUERY_COMMAND_NAME = "queryCommand";
    private static final String EXPORT_TYPE_ARGS = "type";
    private static final String EXPORT_TYPE_NAME = "exportType";
    private static final String EXPORT_SQL_TYPE_NAME = "sql";
    private static final String ALIGNED_ARGS = "aligned";
    private static final String ALIGNED_NAME = "export aligned insert sql";
    private static final String LINES_PER_FILE_ARGS = "linesPerFile";
    private static final String LINES_PER_FILE_ARGS_NAME = "Lines Per File";
    private static final String TSFILEDB_CLI_PREFIX = "ExportData";
    private static final String DUMP_FILE_NAME_DEFAULT = "dump";
    private static String targetFile = "dump";
    private static String targetDirectory;
    private static Boolean needDataTypePrinted;
    private static String queryCommand;
    private static String timestampPrecision;
    private static int linesPerFile;
    private static long timeout;
    private static Boolean aligned;
    private static final IoTPrinter ioTPrinter;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        Options options = ExportData.createOptions();
        HelpFormatter hf = new HelpFormatter();
        CommandLine commandLine = null;
        DefaultParser parser = new DefaultParser();
        hf.setOptionComparator(null);
        hf.setWidth(92);
        if (args == null || args.length == 0) {
            ioTPrinter.println("Too few params input, please check the following hint.");
            hf.printHelp(TSFILEDB_CLI_PREFIX, options, true);
            System.exit(1);
        }
        try {
            commandLine = parser.parse(options, args);
        }
        catch (ParseException e) {
            ioTPrinter.println(e.getMessage());
            hf.printHelp(TSFILEDB_CLI_PREFIX, options, true);
            System.exit(1);
        }
        if (commandLine.hasOption("help")) {
            hf.printHelp(TSFILEDB_CLI_PREFIX, options, true);
            System.exit(1);
        }
        int exitCode = 0;
        try {
            ExportData.parseBasicParams(commandLine);
            ExportData.parseSpecialParams(commandLine);
            if (!ExportData.checkTimeFormat()) {
                System.exit(1);
            }
            session = new Session(host, Integer.parseInt(port), username, password);
            session.open(false);
            timestampPrecision = session.getTimestampPrecision();
            ExportData.setTimeZone();
            if (queryCommand == null) {
                String sqlFile = commandLine.getOptionValue(SQL_FILE_ARGS);
                if (sqlFile == null) {
                    LineReader lineReader = JlineUtils.getLineReader(new CliContext(System.in, System.out, System.err, ExitType.EXCEPTION), username, host, port);
                    String sql = lineReader.readLine("ExportData> please input query: ");
                    ioTPrinter.println(sql);
                    String[] values = sql.trim().split(";");
                    for (int i = 0; i < values.length; ++i) {
                        ExportData.dumpResult(values[i], i);
                    }
                } else {
                    ExportData.dumpFromSqlFile(sqlFile);
                }
            } else {
                ExportData.dumpResult(queryCommand, 0);
            }
        }
        catch (IOException e) {
            ioTPrinter.println("Failed to operate on file, because " + e.getMessage());
            exitCode = 1;
        }
        catch (ArgsErrorException e) {
            ioTPrinter.println("Invalid args: " + e.getMessage());
            exitCode = 1;
        }
        catch (IoTDBConnectionException | StatementExecutionException e) {
            ioTPrinter.println("Connect failed because " + e.getMessage());
            exitCode = 1;
        }
        catch (TException e) {
            ioTPrinter.println("Can not get the timestamp precision from server because " + e.getMessage());
            exitCode = 1;
        }
        finally {
            if (session != null) {
                try {
                    session.close();
                }
                catch (IoTDBConnectionException e) {
                    exitCode = 1;
                    ioTPrinter.println("Encounter an error when closing session, error is: " + e.getMessage());
                }
            }
        }
        System.exit(exitCode);
    }

    private static void parseSpecialParams(CommandLine commandLine) throws ArgsErrorException {
        targetDirectory = ExportData.checkRequiredArg(TARGET_DIR_ARGS, TARGET_DIR_NAME, commandLine);
        targetFile = commandLine.getOptionValue(TARGET_FILE_ARGS);
        needDataTypePrinted = Boolean.valueOf(commandLine.getOptionValue("datatype"));
        queryCommand = commandLine.getOptionValue(QUERY_COMMAND_ARGS);
        exportType = commandLine.getOptionValue(EXPORT_TYPE_ARGS);
        String timeoutString = commandLine.getOptionValue("t");
        if (timeoutString != null) {
            timeout = Long.parseLong(timeoutString);
        }
        if (needDataTypePrinted == null) {
            needDataTypePrinted = true;
        }
        if (targetFile == null) {
            targetFile = DUMP_FILE_NAME_DEFAULT;
        }
        if ((timeFormat = commandLine.getOptionValue("tf")) == null) {
            timeFormat = "default";
        }
        timeZoneID = commandLine.getOptionValue("tz");
        if (!targetDirectory.endsWith("/") && !targetDirectory.endsWith("\\")) {
            targetDirectory = targetDirectory + File.separator;
        }
        if (commandLine.getOptionValue(LINES_PER_FILE_ARGS) != null) {
            linesPerFile = Integer.parseInt(commandLine.getOptionValue(LINES_PER_FILE_ARGS));
        }
        if (commandLine.getOptionValue(ALIGNED_ARGS) != null) {
            aligned = Boolean.valueOf(commandLine.getOptionValue(ALIGNED_ARGS));
        }
    }

    private static Options createOptions() {
        Options options = ExportData.createNewOptions();
        Option opTargetFile = Option.builder((String)TARGET_DIR_ARGS).required().argName(TARGET_DIR_NAME).hasArg().desc("Target File Directory (required)").build();
        options.addOption(opTargetFile);
        Option targetFileName = Option.builder((String)TARGET_FILE_ARGS).argName(TARGET_FILE_NAME).hasArg().desc("Export file name (optional)").build();
        options.addOption(targetFileName);
        Option opSqlFile = Option.builder((String)SQL_FILE_ARGS).argName(SQL_FILE_NAME).hasArg().desc("SQL File Path (optional)").build();
        options.addOption(opSqlFile);
        Option opTimeFormat = Option.builder((String)"tf").argName("timeformat").hasArg().desc("Output time Format in csv file. You can choose 1) timestamp, number, long 2) ISO8601, default 3) user-defined pattern like yyyy-MM-dd HH:mm:ss, default ISO8601.\n OutPut timestamp in sql file, No matter what time format is set(optional)").build();
        options.addOption(opTimeFormat);
        Option opTimeZone = Option.builder((String)"tz").argName("timeZone").hasArg().desc("Time Zone eg. +08:00 or -01:00 (optional)").build();
        options.addOption(opTimeZone);
        Option opDataType = Option.builder((String)"datatype").argName("datatype").hasArg().desc("Will the data type of timeseries be printed in the head line of the CSV file?\nYou can choose true) or false) . (optional)").build();
        options.addOption(opDataType);
        Option opQuery = Option.builder((String)QUERY_COMMAND_ARGS).argName(QUERY_COMMAND_NAME).hasArg().desc("The query command that you want to execute. (optional)").build();
        options.addOption(opQuery);
        Option opTypeQuery = Option.builder((String)EXPORT_TYPE_ARGS).argName(EXPORT_TYPE_NAME).hasArg().desc("Export file type ?\nYou can choose csv) or sql) . (optional)").build();
        options.addOption(opTypeQuery);
        Option opAligned = Option.builder((String)ALIGNED_ARGS).argName(ALIGNED_NAME).hasArg().desc("Whether export to sql of aligned (only sql optional)").build();
        options.addOption(opAligned);
        Option opLinesPerFile = Option.builder((String)LINES_PER_FILE_ARGS).argName(LINES_PER_FILE_ARGS_NAME).hasArg().desc("Lines per dump file.").build();
        options.addOption(opLinesPerFile);
        Option opHelp = Option.builder((String)"help").longOpt("help").hasArg(false).desc("Display help information").build();
        options.addOption(opHelp);
        Option opTimeout = Option.builder((String)"t").longOpt("timeout").hasArg().desc("Timeout for session query").build();
        options.addOption(opTimeout);
        return options;
    }

    private static void dumpFromSqlFile(String filePath) throws IOException {
        try (BufferedReader reader = new BufferedReader(new FileReader(filePath));){
            String sql;
            int index = 0;
            while ((sql = reader.readLine()) != null) {
                ExportData.dumpResult(sql, index);
                ++index;
            }
        }
    }

    private static void dumpResult(String sql, int index) {
        if (EXPORT_SQL_TYPE_NAME.equalsIgnoreCase(exportType)) {
            ExportData.legalCheck(sql);
        }
        String path = targetDirectory + targetFile + index;
        try {
            SessionDataSet sessionDataSet = session.executeQueryStatement(sql, timeout);
            ArrayList<Object> headers = new ArrayList<Object>();
            List names = sessionDataSet.getColumnNames();
            List types = sessionDataSet.getColumnTypes();
            if (EXPORT_SQL_TYPE_NAME.equalsIgnoreCase(exportType)) {
                ExportData.writeSqlFile(sessionDataSet, path, names, linesPerFile);
            } else {
                if (Boolean.TRUE.equals(needDataTypePrinted)) {
                    for (int i = 0; i < names.size(); ++i) {
                        if (!"Time".equals(names.get(i)) && !"Device".equals(names.get(i))) {
                            headers.add(String.format("%s(%s)", names.get(i), types.get(i)));
                            continue;
                        }
                        headers.add(names.get(i));
                    }
                } else {
                    headers.addAll(names);
                }
                ExportData.writeCsvFile(sessionDataSet, path, headers, linesPerFile);
            }
            sessionDataSet.closeOperationHandle();
            ioTPrinter.println("Export completely!");
        }
        catch (IOException | IoTDBConnectionException | StatementExecutionException e) {
            ioTPrinter.println("Cannot dump result because: " + e.getMessage());
        }
    }

    private static void legalCheck(String sql) {
        String aggregatePattern = "\\b(count|sum|avg|extreme|max_value|min_value|first_value|last_value|max_time|min_time|stddev|stddev_pop|stddev_samp|variance|var_pop|var_samp|max_by|min_by)\\b\\s*\\(";
        Pattern pattern = Pattern.compile(aggregatePattern, 2);
        Matcher matcher = pattern.matcher(sql.toUpperCase(Locale.ROOT));
        if (matcher.find()) {
            ioTPrinter.println("The sql you entered is invalid, please don't use aggregate query.");
        }
    }

    public static String timeTrans(Long time) {
        switch (timeFormat) {
            case "default": {
                return RpcUtils.parseLongToDateWithPrecision((DateTimeFormatter)DateTimeFormatter.ISO_OFFSET_DATE_TIME, (long)time, (ZoneId)zoneId, (String)timestampPrecision);
            }
            case "timestamp": 
            case "long": 
            case "number": {
                return String.valueOf(time);
            }
        }
        return ZonedDateTime.ofInstant(Instant.ofEpochMilli(time), zoneId).format(DateTimeFormatter.ofPattern(timeFormat));
    }

    public static void writeCsvFile(SessionDataSet sessionDataSet, String filePath, List<Object> headers, int linesPerFile) throws IOException, IoTDBConnectionException, StatementExecutionException {
        int fileIndex = 0;
        boolean hasNext = true;
        while (hasNext) {
            int i = 0;
            String finalFilePath = filePath + "_" + fileIndex + ".csv";
            AbstractDataTool.CSVPrinterWrapper csvPrinterWrapper = new AbstractDataTool.CSVPrinterWrapper(finalFilePath);
            csvPrinterWrapper.printRecord(headers);
            while (i++ < linesPerFile) {
                if (sessionDataSet.hasNext()) {
                    RowRecord rowRecord = sessionDataSet.next();
                    if (rowRecord.getTimestamp() != 0L) {
                        csvPrinterWrapper.print(ExportData.timeTrans(rowRecord.getTimestamp()));
                    }
                    rowRecord.getFields().forEach(field -> {
                        String fieldStringValue = field.getStringValue();
                        if (!"null".equals(field.getStringValue())) {
                            if (field.getDataType() == TSDataType.TEXT && !fieldStringValue.startsWith("root.")) {
                                fieldStringValue = "\"" + fieldStringValue + "\"";
                            }
                            csvPrinterWrapper.print(fieldStringValue);
                        } else {
                            csvPrinterWrapper.print("");
                        }
                    });
                    csvPrinterWrapper.println();
                    continue;
                }
                hasNext = false;
                break;
            }
            ++fileIndex;
            csvPrinterWrapper.flush();
            csvPrinterWrapper.close();
        }
    }

    public static void writeSqlFile(SessionDataSet sessionDataSet, String filePath, List<String> headers, int linesPerFile) throws IOException, IoTDBConnectionException, StatementExecutionException {
        int i;
        int fileIndex = 0;
        String deviceName = null;
        boolean writeNull = false;
        ArrayList<String> seriesList = new ArrayList<String>(headers);
        if (CollectionUtils.isEmpty(headers) || headers.size() <= 1) {
            writeNull = true;
        } else if (headers.contains("Device")) {
            seriesList.remove("Time");
            seriesList.remove("Device");
        } else {
            Path path = new Path((String)seriesList.get(1), true);
            deviceName = path.getDevice();
            seriesList.remove("Time");
            for (i = 0; i < seriesList.size(); ++i) {
                String series = (String)seriesList.get(i);
                path = new Path(series, true);
                seriesList.set(i, path.getMeasurement());
            }
        }
        boolean hasNext = true;
        while (hasNext) {
            i = 0;
            String finalFilePath = filePath + "_" + fileIndex + ".sql";
            FileWriter writer = new FileWriter(finalFilePath);
            if (writeNull) break;
            while (i++ < linesPerFile) {
                if (sessionDataSet.hasNext()) {
                    RowRecord rowRecord = sessionDataSet.next();
                    List fields = rowRecord.getFields();
                    ArrayList<String> headersTemp = new ArrayList<String>(seriesList);
                    ArrayList<String> timeseries = new ArrayList<String>();
                    if (headers.contains("Device")) {
                        deviceName = ((Field)fields.get(0)).toString();
                        if (deviceName.startsWith("root.__system")) continue;
                        for (String header : headersTemp) {
                            timeseries.add(deviceName + "." + header);
                        }
                    } else {
                        if (headers.get(1).startsWith("root.__system")) continue;
                        timeseries.addAll(headers);
                        timeseries.remove(0);
                    }
                    String sqlMiddle = null;
                    sqlMiddle = Boolean.TRUE.equals(aligned) ? " ALIGNED VALUES (" + rowRecord.getTimestamp() + "," : " VALUES (" + rowRecord.getTimestamp() + ",";
                    ArrayList<String> values = new ArrayList<String>();
                    if (headers.contains("Device")) {
                        fields.remove(0);
                    }
                    for (int index = 0; index < fields.size(); ++index) {
                        RowRecord next = session.executeQueryStatement("SHOW TIMESERIES " + (String)timeseries.get(index), timeout).next();
                        if (ObjectUtils.isNotEmpty((Object)next)) {
                            List timeseriesList = next.getFields();
                            String value = ((Field)fields.get(index)).toString();
                            if (value.equals("null")) {
                                headersTemp.remove(seriesList.get(index));
                                continue;
                            }
                            if ("TEXT".equalsIgnoreCase(((Field)timeseriesList.get(3)).getStringValue())) {
                                values.add("\"" + value + "\"");
                                continue;
                            }
                            values.add(value);
                            continue;
                        }
                        headersTemp.remove(seriesList.get(index));
                    }
                    if (!CollectionUtils.isNotEmpty(headersTemp)) continue;
                    writer.write("INSERT INTO " + deviceName + "(TIMESTAMP," + String.join((CharSequence)",", headersTemp) + ")" + sqlMiddle + String.join((CharSequence)",", values) + ");\n");
                    continue;
                }
                hasNext = false;
                break;
            }
            ++fileIndex;
            writer.flush();
            writer.close();
        }
    }

    static {
        linesPerFile = 10000;
        timeout = -1L;
        aligned = false;
        ioTPrinter = new IoTPrinter(System.out);
    }
}

