/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.write.record.datapoint;

import java.io.IOException;
import org.apache.iotdb.tsfile.common.conf.TSFileConfig;
import org.apache.iotdb.tsfile.exception.write.UnSupportedDataTypeException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.utils.StringContainer;
import org.apache.iotdb.tsfile.write.chunk.ChunkWriterImpl;
import org.apache.iotdb.tsfile.write.record.datapoint.BooleanDataPoint;
import org.apache.iotdb.tsfile.write.record.datapoint.DoubleDataPoint;
import org.apache.iotdb.tsfile.write.record.datapoint.FloatDataPoint;
import org.apache.iotdb.tsfile.write.record.datapoint.IntDataPoint;
import org.apache.iotdb.tsfile.write.record.datapoint.LongDataPoint;
import org.apache.iotdb.tsfile.write.record.datapoint.StringDataPoint;

public abstract class DataPoint {
    protected final TSDataType type;
    protected final String measurementId;

    protected DataPoint(TSDataType type, String measurementId) {
        this.type = type;
        this.measurementId = measurementId;
    }

    public static DataPoint getDataPoint(TSDataType dataType, String measurementId, String value) {
        DataPoint dataPoint = null;
        try {
            switch (dataType) {
                case INT32: {
                    dataPoint = new IntDataPoint(measurementId, Integer.parseInt(value));
                    break;
                }
                case INT64: {
                    dataPoint = new LongDataPoint(measurementId, Long.parseLong(value));
                    break;
                }
                case FLOAT: {
                    dataPoint = new FloatDataPoint(measurementId, Float.parseFloat(value));
                    break;
                }
                case DOUBLE: {
                    dataPoint = new DoubleDataPoint(measurementId, Double.parseDouble(value));
                    break;
                }
                case BOOLEAN: {
                    dataPoint = new BooleanDataPoint(measurementId, Boolean.parseBoolean(value));
                    break;
                }
                case TEXT: {
                    dataPoint = new StringDataPoint(measurementId, new Binary(value, TSFileConfig.STRING_CHARSET));
                    break;
                }
                default: {
                    throw new UnSupportedDataTypeException(String.format("Data type %s is not supported.", new Object[]{dataType}));
                }
            }
        }
        catch (Exception e) {
            throw new UnSupportedDataTypeException(String.format("Data type of %s is %s, but input value is %s", new Object[]{measurementId, dataType, value}));
        }
        return dataPoint;
    }

    public abstract void writeTo(long var1, ChunkWriterImpl var3) throws IOException;

    public String getMeasurementId() {
        return this.measurementId;
    }

    public abstract Object getValue();

    public TSDataType getType() {
        return this.type;
    }

    public String toString() {
        StringContainer sc = new StringContainer(" ");
        sc.addTail(new Object[]{"{measurement id:", this.measurementId, "type:", this.type, "value:", this.getValue(), "}"});
        return sc.toString();
    }

    public void setInteger(int value) {
        throw new UnsupportedOperationException("set Integer not support in DataPoint");
    }

    public void setLong(long value) {
        throw new UnsupportedOperationException("set Long not support in DataPoint");
    }

    public void setBoolean(boolean value) {
        throw new UnsupportedOperationException("set Boolean not support in DataPoint");
    }

    public void setFloat(float value) {
        throw new UnsupportedOperationException("set Float not support in DataPoint");
    }

    public void setDouble(double value) {
        throw new UnsupportedOperationException("set Double not support in DataPoint");
    }

    public void setString(Binary value) {
        throw new UnsupportedOperationException("set String not support in DataPoint");
    }
}

