/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.read.common.parser;

import java.util.List;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.iotdb.tsfile.common.constant.TsFileConstant;
import org.apache.tsfile.parser.PathParser;
import org.apache.tsfile.parser.PathParserBaseVisitor;

public class PathVisitor
extends PathParserBaseVisitor<String[]> {
    @Override
    public String[] visitPath(PathParser.PathContext ctx) {
        if (ctx.prefixPath() != null) {
            return this.visitPrefixPath(ctx.prefixPath());
        }
        return this.visitSuffixPath(ctx.suffixPath());
    }

    @Override
    public String[] visitPrefixPath(PathParser.PrefixPathContext ctx) {
        List<PathParser.NodeNameContext> nodeNames = ctx.nodeName();
        String[] path = new String[nodeNames.size() + 1];
        path[0] = ctx.ROOT().getText();
        for (int i = 0; i < nodeNames.size(); ++i) {
            path[i + 1] = this.parseNodeName(nodeNames.get(i));
        }
        return path;
    }

    @Override
    public String[] visitSuffixPath(PathParser.SuffixPathContext ctx) {
        List<PathParser.NodeNameContext> nodeNames = ctx.nodeName();
        String[] path = new String[nodeNames.size()];
        for (int i = 0; i < nodeNames.size(); ++i) {
            path[i] = this.parseNodeName(nodeNames.get(i));
        }
        return path;
    }

    private String parseNodeName(PathParser.NodeNameContext ctx) {
        String nodeName = ctx.getText();
        if (nodeName.startsWith("`") && nodeName.endsWith("`")) {
            String unWrapped = nodeName.substring(1, nodeName.length() - 1);
            if (PathVisitor.isRealNumber(unWrapped) || !TsFileConstant.IDENTIFIER_PATTERN.matcher(unWrapped).matches()) {
                return nodeName;
            }
            return unWrapped;
        }
        return nodeName;
    }

    public static boolean isRealNumber(String str) {
        if (str.startsWith("+") || str.startsWith("-")) {
            String removeSign = str.substring(1);
            if (removeSign.startsWith("+") || removeSign.startsWith("-")) {
                return false;
            }
            str = removeSign;
        }
        int index = 0;
        int n = str.length();
        for (int i = 0; i < n; ++i) {
            if (str.charAt(i) == '0') continue;
            index = i;
            break;
        }
        if (index > 0 && (str.charAt(index) == 'e' || str.charAt(index) == 'E')) {
            return NumberUtils.isCreatable(str.substring(index - 1));
        }
        return NumberUtils.isCreatable(str.substring(index));
    }
}

