/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.read.common.block.column;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.block.column.Column;
import org.apache.iotdb.tsfile.read.common.block.column.ColumnEncoder;
import org.apache.iotdb.tsfile.read.common.block.column.FloatColumn;
import org.apache.iotdb.tsfile.read.common.block.column.IntColumn;

public class Int32ArrayColumnEncoder
implements ColumnEncoder {
    @Override
    public Column readColumn(ByteBuffer input, TSDataType dataType, int positionCount) {
        boolean[] nullIndicators = ColumnEncoder.deserializeNullIndicators(input, positionCount);
        if (TSDataType.INT32.equals((Object)dataType)) {
            int[] values = new int[positionCount];
            if (nullIndicators == null) {
                for (int i = 0; i < positionCount; ++i) {
                    values[i] = input.getInt();
                }
            } else {
                for (int i = 0; i < positionCount; ++i) {
                    if (nullIndicators[i]) continue;
                    values[i] = input.getInt();
                }
            }
            return new IntColumn(0, positionCount, nullIndicators, values);
        }
        if (TSDataType.FLOAT.equals((Object)dataType)) {
            float[] values = new float[positionCount];
            if (nullIndicators == null) {
                for (int i = 0; i < positionCount; ++i) {
                    values[i] = Float.intBitsToFloat(input.getInt());
                }
            } else {
                for (int i = 0; i < positionCount; ++i) {
                    if (nullIndicators[i]) continue;
                    values[i] = Float.intBitsToFloat(input.getInt());
                }
            }
            return new FloatColumn(0, positionCount, nullIndicators, values);
        }
        throw new IllegalArgumentException("Invalid data type: " + (Object)((Object)dataType));
    }

    @Override
    public void writeColumn(DataOutputStream output, Column column) throws IOException {
        ColumnEncoder.serializeNullIndicators(output, column);
        TSDataType dataType = column.getDataType();
        int positionCount = column.getPositionCount();
        if (TSDataType.INT32.equals((Object)dataType)) {
            if (column.mayHaveNull()) {
                for (int i = 0; i < positionCount; ++i) {
                    if (column.isNull(i)) continue;
                    output.writeInt(column.getInt(i));
                }
            } else {
                for (int i = 0; i < positionCount; ++i) {
                    output.writeInt(column.getInt(i));
                }
            }
        } else if (TSDataType.FLOAT.equals((Object)dataType)) {
            if (column.mayHaveNull()) {
                for (int i = 0; i < positionCount; ++i) {
                    if (column.isNull(i)) continue;
                    output.writeInt(Float.floatToIntBits(column.getFloat(i)));
                }
            } else {
                for (int i = 0; i < positionCount; ++i) {
                    output.writeInt(Float.floatToIntBits(column.getFloat(i)));
                }
            }
        } else {
            throw new IllegalArgumentException("Invalid data type: " + (Object)((Object)dataType));
        }
    }
}

