/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.file.metadata.statistics;

import io.airlift.slice.SizeOf;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.iotdb.tsfile.common.conf.TSFileConfig;
import org.apache.iotdb.tsfile.exception.filter.StatisticsClassException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.openjdk.jol.info.ClassLayout;

public class BinaryStatistics
extends Statistics<Binary> {
    public static final int INSTANCE_SIZE = ClassLayout.parseClass(BinaryStatistics.class).instanceSize() + 2 * ClassLayout.parseClass(Binary.class).instanceSize();
    private static final Binary EMPTY_VALUE = new Binary("", TSFileConfig.STRING_CHARSET);
    private Binary firstValue = EMPTY_VALUE;
    private Binary lastValue = EMPTY_VALUE;

    @Override
    public TSDataType getType() {
        return TSDataType.TEXT;
    }

    @Override
    public int getStatsSize() {
        return 4 + this.firstValue.getValues().length + 4 + this.lastValue.getValues().length;
    }

    @Override
    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + SizeOf.sizeOfCharArray(this.firstValue.getLength()) + SizeOf.sizeOfCharArray(this.lastValue.getLength());
    }

    public void initializeStats(Binary first, Binary last) {
        this.firstValue = first;
        this.lastValue = last;
    }

    private void updateLastStats(Binary lastValue) {
        this.lastValue = lastValue;
    }

    private void updateStats(Binary firstValue, Binary lastValue, long startTime, long endTime) {
        if (startTime <= this.getStartTime()) {
            this.firstValue = firstValue;
        }
        if (endTime >= this.getEndTime()) {
            this.lastValue = lastValue;
        }
    }

    @Override
    public Binary getMinValue() {
        throw new StatisticsClassException(String.format("%s statistics does not support: %s", new Object[]{TSDataType.TEXT, "min"}));
    }

    @Override
    public Binary getMaxValue() {
        throw new StatisticsClassException(String.format("%s statistics does not support: %s", new Object[]{TSDataType.TEXT, "max"}));
    }

    @Override
    public Binary getFirstValue() {
        return this.firstValue;
    }

    @Override
    public Binary getLastValue() {
        return this.lastValue;
    }

    @Override
    public double getSumDoubleValue() {
        throw new StatisticsClassException(String.format("%s statistics does not support: %s", new Object[]{TSDataType.TEXT, "double sum"}));
    }

    @Override
    public long getSumLongValue() {
        throw new StatisticsClassException(String.format("%s statistics does not support: %s", new Object[]{TSDataType.TEXT, "long sum"}));
    }

    @Override
    protected void mergeStatisticsValue(Statistics<Binary> stats) {
        BinaryStatistics stringStats = (BinaryStatistics)stats;
        if (this.isEmpty) {
            this.initializeStats(stringStats.getFirstValue(), stringStats.getLastValue());
            this.isEmpty = false;
        } else {
            this.updateStats(stringStats.getFirstValue(), stringStats.getLastValue(), stats.getStartTime(), stats.getEndTime());
        }
    }

    @Override
    void updateStats(Binary value) {
        if (this.isEmpty) {
            this.initializeStats(value, value);
            this.isEmpty = false;
        } else {
            this.updateLastStats(value);
        }
    }

    @Override
    void updateStats(Binary[] values, int batchSize) {
        for (int i = 0; i < batchSize; ++i) {
            this.updateStats(values[i]);
        }
    }

    @Override
    public int serializeStats(OutputStream outputStream) throws IOException {
        int byteLen = 0;
        byteLen += ReadWriteIOUtils.write(this.firstValue, outputStream);
        return byteLen += ReadWriteIOUtils.write(this.lastValue, outputStream);
    }

    @Override
    public void deserialize(InputStream inputStream) throws IOException {
        this.firstValue = ReadWriteIOUtils.readBinary(inputStream);
        this.lastValue = ReadWriteIOUtils.readBinary(inputStream);
    }

    @Override
    public void deserialize(ByteBuffer byteBuffer) {
        this.firstValue = ReadWriteIOUtils.readBinary(byteBuffer);
        this.lastValue = ReadWriteIOUtils.readBinary(byteBuffer);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BinaryStatistics that = (BinaryStatistics)o;
        return Objects.equals(this.firstValue, that.firstValue) && Objects.equals(this.lastValue, that.lastValue);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.firstValue, this.lastValue);
    }

    @Override
    public String toString() {
        return super.toString() + " [firstValue:" + this.firstValue + ",lastValue:" + this.lastValue + "]";
    }
}

