/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.encoding.decoder;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.iotdb.tsfile.encoding.decoder.GorillaDecoderV1;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DoublePrecisionDecoderV1
extends GorillaDecoderV1 {
    private static final Logger logger = LoggerFactory.getLogger(DoublePrecisionDecoderV1.class);
    private long preValue;

    @Override
    public double readDouble(ByteBuffer buffer) {
        if (!this.flag) {
            this.flag = true;
            try {
                int[] buf = new int[8];
                for (int i = 0; i < 8; ++i) {
                    buf[i] = ReadWriteIOUtils.read(buffer);
                }
                long res = 0L;
                for (int i = 0; i < 8; ++i) {
                    res += (long)buf[i] << i * 8;
                }
                this.preValue = res;
                double tmp = Double.longBitsToDouble(this.preValue);
                this.leadingZeroNum = Long.numberOfLeadingZeros(this.preValue);
                this.tailingZeroNum = Long.numberOfTrailingZeros(this.preValue);
                this.fillBuffer(buffer);
                this.getNextValue(buffer);
                return tmp;
            }
            catch (IOException e) {
                logger.error("DoublePrecisionDecoderV1 cannot read first double number", e);
            }
        } else {
            try {
                double tmp = Double.longBitsToDouble(this.preValue);
                this.getNextValue(buffer);
                return tmp;
            }
            catch (IOException e) {
                logger.error("DoublePrecisionDecoderV1 cannot read following double number", e);
            }
        }
        return Double.NaN;
    }

    private void getNextValue(ByteBuffer buffer) throws IOException {
        this.nextFlag1 = this.readBit(buffer);
        if (!this.nextFlag1) {
            return;
        }
        this.nextFlag2 = this.readBit(buffer);
        if (!this.nextFlag2) {
            long tmp = 0L;
            for (int i = 0; i < 64 - this.leadingZeroNum - this.tailingZeroNum; ++i) {
                long bit = this.readBit(buffer) ? 1L : 0L;
                tmp |= bit << 63 - this.leadingZeroNum - i;
            }
            this.preValue = tmp ^= this.preValue;
        } else {
            int leadingZeroNumTmp = this.readIntFromStream(buffer, 6);
            int lenTmp = this.readIntFromStream(buffer, 7);
            long tmp = this.readLongFromStream(buffer, lenTmp);
            tmp <<= 64 - leadingZeroNumTmp - lenTmp;
            this.preValue = tmp ^= this.preValue;
        }
        this.leadingZeroNum = Long.numberOfLeadingZeros(this.preValue);
        this.tailingZeroNum = Long.numberOfTrailingZeros(this.preValue);
        if (Double.isNaN(Double.longBitsToDouble(this.preValue))) {
            this.isEnd = true;
        }
    }
}

