/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.metrics.metricsets.jvm;

import com.sun.management.GarbageCollectionNotificationInfo;
import com.sun.management.GcInfo;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.lang.management.MemoryUsage;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.ListenerNotFoundException;
import javax.management.NotificationEmitter;
import javax.management.NotificationListener;
import javax.management.openmbean.CompositeData;
import org.apache.iotdb.metrics.AbstractMetricService;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.iotdb.metrics.metricsets.jvm.JvmUtils;
import org.apache.iotdb.metrics.type.Counter;
import org.apache.iotdb.metrics.type.Timer;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.metrics.utils.MetricType;
import org.apache.iotdb.metrics.utils.SystemMetric;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JvmGcMetrics
implements IMetricSet,
AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(JvmGcMetrics.class);
    private final List<Runnable> notificationListenerCleanUpRunnables = new CopyOnWriteArrayList<Runnable>();
    private String firstYoungGenPoolName;
    private String oldGenPoolName;
    private String nonGenerationalMemoryPool;
    private final Map<String, AtomicLong> lastGcTotalDurationMap = new ConcurrentHashMap<String, AtomicLong>();

    public JvmGcMetrics() {
        for (MemoryPoolMXBean mbean : ManagementFactory.getMemoryPoolMXBeans()) {
            String name = mbean.getName();
            if (JvmGcMetrics.isFirstYoungGenPool(name)) {
                this.firstYoungGenPoolName = name;
                continue;
            }
            if (JvmGcMetrics.isOldGenPool(name)) {
                this.oldGenPoolName = name;
                continue;
            }
            if (!JvmGcMetrics.isNonGenerationalHeapPool(name)) continue;
            this.nonGenerationalMemoryPool = name;
        }
    }

    private static boolean isPartiallyConcurrentGC(GarbageCollectorMXBean gc) {
        switch (gc.getName()) {
            case "Copy": 
            case "MarkSweepCompact": 
            case "PS MarkSweep": 
            case "PS Scavenge": 
            case "G1 Young Generation": 
            case "ParNew": {
                return false;
            }
            case "ConcurrentMarkSweep": 
            case "G1 Old Generation": {
                return true;
            }
        }
        return true;
    }

    private static boolean isFirstYoungGenPool(String name) {
        return name != null && name.endsWith("Eden Space");
    }

    private static boolean isOldGenPool(String name) {
        return name != null && (name.endsWith("Old Gen") || name.endsWith("Tenured Gen"));
    }

    private static boolean isNonGenerationalHeapPool(String name) {
        return "Shenandoah".equals(name) || "ZHeap".equals(name);
    }

    @Override
    public void bindTo(AbstractMetricService metricService) {
        if (!this.preCheck()) {
            return;
        }
        double maxLongLivedPoolBytes = ManagementFactory.getPlatformMXBeans(MemoryPoolMXBean.class).stream().filter(mem -> MemoryType.HEAP.equals((Object)mem.getType())).filter(mem -> JvmGcMetrics.isOldGenPool(mem.getName()) || JvmGcMetrics.isNonGenerationalHeapPool(mem.getName())).findAny().map(mem -> JvmUtils.getUsageValue(mem, MemoryUsage::getMax)).orElse(0.0);
        AtomicLong maxDataSize = new AtomicLong((long)maxLongLivedPoolBytes);
        metricService.createAutoGauge(SystemMetric.JVM_GC_MAX_DATA_SIZE_BYTES.toString(), MetricLevel.CORE, maxDataSize, AtomicLong::get, new String[0]);
        AtomicLong liveDataSize = new AtomicLong();
        metricService.createAutoGauge(SystemMetric.JVM_GC_LIVE_DATA_SIZE_BYTES.toString(), MetricLevel.CORE, liveDataSize, AtomicLong::get, new String[0]);
        Counter promotedBytes = this.oldGenPoolName == null ? null : metricService.getOrCreateCounter(SystemMetric.JVM_GC_MEMORY_PROMOTED_BYTES.toString(), MetricLevel.CORE, new String[0]);
        Counter nonGenAllocatedBytes = this.nonGenerationalMemoryPool == null ? null : metricService.getOrCreateCounter(SystemMetric.JVM_GC_NON_GEN_MEMORY_ALLOCATED_BYTES.toString(), MetricLevel.CORE, new String[0]);
        Counter oldGenAllocatedBytes = this.oldGenPoolName == null ? null : metricService.getOrCreateCounter(SystemMetric.JVM_GC_OLD_MEMORY_ALLOCATED_BYTES.toString(), MetricLevel.CORE, new String[0]);
        Counter youngGenAllocatedBytes = this.firstYoungGenPoolName == null ? null : metricService.getOrCreateCounter(SystemMetric.JVM_GC_YOUNG_MEMORY_ALLOCATED_BYTES.toString(), MetricLevel.CORE, new String[0]);
        AtomicLong firstYoungHeapPoolSizeAfterGc = new AtomicLong();
        AtomicLong longLivedHeapPoolSizeAfterGc = new AtomicLong();
        for (GarbageCollectorMXBean mbean : ManagementFactory.getGarbageCollectorMXBeans()) {
            if (!(mbean instanceof NotificationEmitter)) continue;
            NotificationListener notificationListener = (notification, ref) -> {
                CompositeData cd2 = (CompositeData)notification.getUserData();
                GarbageCollectionNotificationInfo notificationInfo = GarbageCollectionNotificationInfo.from(cd2);
                String gcCause = notificationInfo.getGcCause();
                String gcAction = notificationInfo.getGcAction();
                GcInfo gcInfo = notificationInfo.getGcInfo();
                long duration = gcInfo.getDuration();
                if (JvmGcMetrics.isPartiallyConcurrentGC(mbean)) {
                    AtomicLong previousTotal = this.lastGcTotalDurationMap.computeIfAbsent(mbean.getName(), k -> new AtomicLong());
                    long total = mbean.getCollectionTime();
                    duration = total - previousTotal.get();
                    previousTotal.set(total);
                }
                Timer timer = metricService.getOrCreateTimer(SystemMetric.JVM_GC_PAUSE.toString(), MetricLevel.CORE, "action", gcAction, "cause", gcCause);
                timer.update(duration, TimeUnit.MILLISECONDS);
                if (mbean.getName().equals("ZGC Cycles")) {
                    Counter cyclesCount = metricService.getOrCreateCounter(SystemMetric.JVM_ZGC_CYCLES_COUNT.toString(), MetricLevel.CORE, new String[0]);
                    cyclesCount.inc();
                } else if (mbean.getName().equals("ZGC Pauses")) {
                    Counter pausesCount = metricService.getOrCreateCounter(SystemMetric.JVM_ZGC_PAUSES_COUNT.toString(), MetricLevel.CORE, new String[0]);
                    pausesCount.inc();
                }
                Map<String, MemoryUsage> before = gcInfo.getMemoryUsageBeforeGc();
                Map<String, MemoryUsage> after = gcInfo.getMemoryUsageAfterGc();
                if (this.nonGenerationalMemoryPool != null) {
                    this.countPoolSizeDelta(gcInfo.getMemoryUsageBeforeGc(), gcInfo.getMemoryUsageAfterGc(), nonGenAllocatedBytes, longLivedHeapPoolSizeAfterGc, this.nonGenerationalMemoryPool);
                    if (after.get(this.nonGenerationalMemoryPool).getUsed() < before.get(this.nonGenerationalMemoryPool).getUsed()) {
                        liveDataSize.set(after.get(this.nonGenerationalMemoryPool).getUsed());
                        long longLivedMaxAfter = after.get(this.nonGenerationalMemoryPool).getMax();
                        maxDataSize.set(longLivedMaxAfter);
                    }
                } else {
                    if (this.oldGenPoolName != null) {
                        long oldBefore = before.get(this.oldGenPoolName).getUsed();
                        long oldAfter = after.get(this.oldGenPoolName).getUsed();
                        long delta = oldAfter - oldBefore;
                        if (delta > 0L && promotedBytes != null) {
                            promotedBytes.inc(delta);
                        }
                        if (oldAfter < oldBefore || GcGenerationAge.fromName(notificationInfo.getGcName()) == GcGenerationAge.OLD) {
                            liveDataSize.set(oldAfter);
                            long oldMaxAfter = after.get(this.oldGenPoolName).getMax();
                            maxDataSize.set(oldMaxAfter);
                        }
                        this.countPoolSizeDelta(gcInfo.getMemoryUsageBeforeGc(), gcInfo.getMemoryUsageAfterGc(), oldGenAllocatedBytes, longLivedHeapPoolSizeAfterGc, this.oldGenPoolName);
                    }
                    if (this.firstYoungGenPoolName != null) {
                        this.countPoolSizeDelta(gcInfo.getMemoryUsageBeforeGc(), gcInfo.getMemoryUsageAfterGc(), youngGenAllocatedBytes, firstYoungHeapPoolSizeAfterGc, this.firstYoungGenPoolName);
                    }
                }
            };
            NotificationEmitter notificationEmitter = (NotificationEmitter)((Object)mbean);
            notificationEmitter.addNotificationListener(notificationListener, notification -> notification.getType().equals("com.sun.management.gc.notification"), null);
            this.notificationListenerCleanUpRunnables.add(() -> {
                try {
                    notificationEmitter.removeNotificationListener(notificationListener);
                }
                catch (ListenerNotFoundException listenerNotFoundException) {
                    // empty catch block
                }
            });
        }
    }

    @Override
    public void unbindFrom(AbstractMetricService metricService) {
        if (!this.preCheck()) {
            return;
        }
        metricService.remove(MetricType.AUTO_GAUGE, SystemMetric.JVM_GC_MAX_DATA_SIZE_BYTES.toString(), new String[0]);
        metricService.remove(MetricType.AUTO_GAUGE, SystemMetric.JVM_GC_LIVE_DATA_SIZE_BYTES.toString(), new String[0]);
        if (this.nonGenerationalMemoryPool != null) {
            metricService.remove(MetricType.COUNTER, SystemMetric.JVM_GC_NON_GEN_MEMORY_ALLOCATED_BYTES.toString(), new String[0]);
        } else {
            if (this.oldGenPoolName != null) {
                metricService.remove(MetricType.COUNTER, SystemMetric.JVM_GC_MEMORY_PROMOTED_BYTES.toString(), new String[0]);
                metricService.remove(MetricType.COUNTER, SystemMetric.JVM_GC_OLD_MEMORY_ALLOCATED_BYTES.toString(), new String[0]);
            }
            if (this.firstYoungGenPoolName != null) {
                metricService.remove(MetricType.COUNTER, SystemMetric.JVM_GC_YOUNG_MEMORY_ALLOCATED_BYTES.toString(), new String[0]);
            }
        }
        for (GarbageCollectorMXBean mbean : ManagementFactory.getGarbageCollectorMXBeans()) {
            if (!(mbean instanceof NotificationEmitter)) continue;
            NotificationListener notificationListener = (notification, ref) -> {
                CompositeData cd2 = (CompositeData)notification.getUserData();
                GarbageCollectionNotificationInfo notificationInfo = GarbageCollectionNotificationInfo.from(cd2);
                String gcCause = notificationInfo.getGcCause();
                String gcAction = notificationInfo.getGcAction();
                metricService.remove(MetricType.TIMER, SystemMetric.JVM_GC_PAUSE.toString(), "action", gcAction, "cause", gcCause);
                if (mbean.getName().equals("ZGC Cycles")) {
                    metricService.remove(MetricType.COUNTER, SystemMetric.JVM_ZGC_CYCLES_COUNT.toString(), new String[0]);
                } else if (mbean.getName().equals("ZGC Pauses")) {
                    metricService.remove(MetricType.COUNTER, SystemMetric.JVM_ZGC_PAUSES_COUNT.toString(), new String[0]);
                }
            };
            NotificationEmitter notificationEmitter = (NotificationEmitter)((Object)mbean);
            notificationEmitter.addNotificationListener(notificationListener, notification -> notification.getType().equals("com.sun.management.gc.notification"), null);
            this.notificationListenerCleanUpRunnables.add(() -> {
                try {
                    notificationEmitter.removeNotificationListener(notificationListener);
                }
                catch (ListenerNotFoundException listenerNotFoundException) {
                    // empty catch block
                }
            });
        }
    }

    private boolean preCheck() {
        if (ManagementFactory.getMemoryPoolMXBeans().isEmpty()) {
            logger.warn("GC notifications will not be available because MemoryPoolMXBeans are not provided by the JVM");
            return false;
        }
        try {
            Class.forName("com.sun.management.GarbageCollectionNotificationInfo", false, MemoryPoolMXBean.class.getClassLoader());
        }
        catch (Exception e) {
            logger.warn("GC notifications will not be available because com.sun.management.GarbageCollectionNotificationInfo is not present");
            return false;
        }
        return true;
    }

    private void countPoolSizeDelta(Map<String, MemoryUsage> before, Map<String, MemoryUsage> after, Counter counter, AtomicLong previousPoolSize, String poolName) {
        long beforeBytes = before.get(poolName).getUsed();
        long afterBytes = after.get(poolName).getUsed();
        long delta = beforeBytes - previousPoolSize.get();
        previousPoolSize.set(afterBytes);
        if (delta > 0L) {
            counter.inc(delta);
        }
    }

    @Override
    public void close() {
        this.notificationListenerCleanUpRunnables.forEach(Runnable::run);
    }

    static enum GcGenerationAge {
        OLD,
        YOUNG,
        UNKNOWN;

        private static final Map<String, GcGenerationAge> knownCollectors;

        static GcGenerationAge fromName(String name) {
            return knownCollectors.getOrDefault(name, UNKNOWN);
        }

        static {
            knownCollectors = new HashMap<String, GcGenerationAge>();
            knownCollectors.put("ConcurrentMarkSweep", OLD);
            knownCollectors.put("Copy", YOUNG);
            knownCollectors.put("G1 Old Generation", OLD);
            knownCollectors.put("G1 Young Generation", YOUNG);
            knownCollectors.put("MarkSweepCompact", OLD);
            knownCollectors.put("PS MarkSweep", OLD);
            knownCollectors.put("PS Scavenge", YOUNG);
            knownCollectors.put("ParNew", YOUNG);
        }
    }
}

