/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.metrics.metricsets.disk;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Scanner;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.iotdb.metrics.config.MetricConfigDescriptor;
import org.apache.iotdb.metrics.metricsets.disk.IDiskMetricsManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinuxDiskMetricsManager
implements IDiskMetricsManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(LinuxDiskMetricsManager.class);
    private static final String DISK_STATUS_FILE_PATH = "/proc/diskstats";
    private static final String DISK_ID_PATH = "/sys/block";
    private static final String DISK_SECTOR_SIZE_PATH = "/sys/block/%s/queue/hw_sector_size";
    private final String processIoStatusPath = String.format("/proc/%s/io", MetricConfigDescriptor.getInstance().getMetricConfig().getPid());
    private static final int DISK_ID_OFFSET = 3;
    private static final int DISK_READ_COUNT_OFFSET = 4;
    private static final int DISK_MERGED_READ_COUNT_OFFSET = 5;
    private static final int DISK_SECTOR_READ_COUNT_OFFSET = 6;
    private static final int DISK_READ_TIME_OFFSET = 7;
    private static final int DISK_WRITE_COUNT_OFFSET = 8;
    private static final int DISK_MERGED_WRITE_COUNT_OFFSET = 9;
    private static final int DISK_SECTOR_WRITE_COUNT_OFFSET = 10;
    private static final int DISK_WRITE_TIME_COST_OFFSET = 11;
    private static final int DISK_IO_TOTAL_TIME_OFFSET = 13;
    private static final int DISK_TIME_IN_QUEUE_OFFSET = 14;
    private static final int DEFAULT_SECTOR_SIZE = 512;
    private static final double BYTES_PER_KB = 1024.0;
    private static final long UPDATE_SMALLEST_INTERVAL = 10000L;
    private Set<String> diskIdSet;
    private final Map<String, Integer> diskSectorSizeMap;
    private long lastUpdateTime = 0L;
    private long updateInterval = 1L;
    private final Map<String, Long> lastReadOperationCountForDisk;
    private final Map<String, Long> lastWriteOperationCountForDisk;
    private final Map<String, Long> lastReadTimeCostForDisk;
    private final Map<String, Long> lastWriteTimeCostForDisk;
    private final Map<String, Long> lastMergedReadCountForDisk;
    private final Map<String, Long> lastMergedWriteCountForDisk;
    private final Map<String, Long> lastReadSectorCountForDisk;
    private final Map<String, Long> lastWriteSectorCountForDisk;
    private final Map<String, Long> lastIoBusyTimeForDisk;
    private final Map<String, Long> lastTimeInQueueForDisk;
    private final Map<String, Long> incrementReadOperationCountForDisk;
    private final Map<String, Long> incrementWriteOperationCountForDisk;
    private final Map<String, Long> incrementMergedReadOperationCountForDisk;
    private final Map<String, Long> incrementMergedWriteOperationCountForDisk;
    private final Map<String, Long> incrementReadTimeCostForDisk;
    private final Map<String, Long> incrementWriteTimeCostForDisk;
    private final Map<String, Long> incrementReadSectorCountForDisk;
    private final Map<String, Long> incrementWriteSectorCountForDisk;
    private final Map<String, Long> incrementIoBusyTimeForDisk;
    private final Map<String, Long> incrementTimeInQueueForDisk;
    private long lastReallyReadSizeForProcess = 0L;
    private long lastReallyWriteSizeForProcess = 0L;
    private long lastAttemptReadSizeForProcess = 0L;
    private long lastAttemptWriteSizeForProcess = 0L;
    private long lastReadOpsCountForProcess = 0L;
    private long lastWriteOpsCountForProcess = 0L;

    public LinuxDiskMetricsManager() {
        this.collectDiskId();
        this.diskSectorSizeMap = new HashMap<String, Integer>(this.diskIdSet.size() + 1, 1.0f);
        this.collectDiskInfo();
        this.lastReadOperationCountForDisk = new HashMap<String, Long>(this.diskIdSet.size() + 1, 1.0f);
        this.lastWriteOperationCountForDisk = new HashMap<String, Long>(this.diskIdSet.size() + 1, 1.0f);
        this.lastReadTimeCostForDisk = new HashMap<String, Long>(this.diskIdSet.size() + 1, 1.0f);
        this.lastWriteTimeCostForDisk = new HashMap<String, Long>(this.diskIdSet.size() + 1, 1.0f);
        this.lastMergedReadCountForDisk = new HashMap<String, Long>(this.diskIdSet.size() + 1, 1.0f);
        this.lastMergedWriteCountForDisk = new HashMap<String, Long>(this.diskIdSet.size() + 1, 1.0f);
        this.lastReadSectorCountForDisk = new HashMap<String, Long>(this.diskIdSet.size() + 1, 1.0f);
        this.lastWriteSectorCountForDisk = new HashMap<String, Long>(this.diskIdSet.size() + 1, 1.0f);
        this.lastIoBusyTimeForDisk = new HashMap<String, Long>(this.diskIdSet.size() + 1, 1.0f);
        this.lastTimeInQueueForDisk = new HashMap<String, Long>(this.diskIdSet.size() + 1, 1.0f);
        this.incrementReadOperationCountForDisk = new HashMap<String, Long>(this.diskIdSet.size() + 1, 1.0f);
        this.incrementWriteOperationCountForDisk = new HashMap<String, Long>(this.diskIdSet.size() + 1, 1.0f);
        this.incrementMergedReadOperationCountForDisk = new HashMap<String, Long>(this.diskIdSet.size() + 1, 1.0f);
        this.incrementMergedWriteOperationCountForDisk = new HashMap<String, Long>(this.diskIdSet.size() + 1, 1.0f);
        this.incrementReadTimeCostForDisk = new HashMap<String, Long>(this.diskIdSet.size() + 1, 1.0f);
        this.incrementWriteTimeCostForDisk = new HashMap<String, Long>(this.diskIdSet.size() + 1, 1.0f);
        this.incrementReadSectorCountForDisk = new HashMap<String, Long>(this.diskIdSet.size() + 1, 1.0f);
        this.incrementWriteSectorCountForDisk = new HashMap<String, Long>(this.diskIdSet.size() + 1, 1.0f);
        this.incrementIoBusyTimeForDisk = new HashMap<String, Long>(this.diskIdSet.size() + 1, 1.0f);
        this.incrementTimeInQueueForDisk = new HashMap<String, Long>(this.diskIdSet.size() + 1, 1.0f);
    }

    @Override
    public Map<String, Double> getReadDataSizeForDisk() {
        this.checkUpdate();
        HashMap<String, Double> readDataMap = new HashMap<String, Double>(this.diskIdSet.size());
        for (Map.Entry<String, Long> entry : this.lastReadSectorCountForDisk.entrySet()) {
            int sectorSize = this.diskSectorSizeMap.getOrDefault(entry.getKey(), 512);
            readDataMap.put(entry.getKey(), (double)(entry.getValue() * (long)sectorSize) / 1024.0);
        }
        return readDataMap;
    }

    @Override
    public Map<String, Double> getWriteDataSizeForDisk() {
        this.checkUpdate();
        HashMap<String, Double> writeDataMap = new HashMap<String, Double>(this.diskIdSet.size());
        for (Map.Entry<String, Long> entry : this.lastWriteSectorCountForDisk.entrySet()) {
            int sectorSize = this.diskSectorSizeMap.getOrDefault(entry.getKey(), 512);
            writeDataMap.put(entry.getKey(), (double)(entry.getValue() * (long)sectorSize) / 1024.0);
        }
        return writeDataMap;
    }

    @Override
    public Map<String, Long> getReadOperationCountForDisk() {
        this.checkUpdate();
        return this.lastReadOperationCountForDisk;
    }

    @Override
    public Map<String, Long> getWriteOperationCountForDisk() {
        return this.lastWriteOperationCountForDisk;
    }

    @Override
    public Map<String, Long> getReadCostTimeForDisk() {
        return this.lastReadTimeCostForDisk;
    }

    @Override
    public Map<String, Long> getWriteCostTimeForDisk() {
        return this.lastWriteTimeCostForDisk;
    }

    @Override
    public Map<String, Double> getIoUtilsPercentage() {
        HashMap<String, Double> utilsMap = new HashMap<String, Double>(this.diskIdSet.size());
        for (Map.Entry<String, Long> entry : this.incrementIoBusyTimeForDisk.entrySet()) {
            utilsMap.put(entry.getKey(), (double)entry.getValue().longValue() / (double)this.updateInterval);
        }
        return utilsMap;
    }

    @Override
    public Map<String, Double> getAvgReadCostTimeOfEachOpsForDisk() {
        HashMap<String, Double> avgReadTimeCostMap = new HashMap<String, Double>(this.diskIdSet.size());
        for (Map.Entry<String, Long> readCostEntry : this.incrementReadTimeCostForDisk.entrySet()) {
            long readOpsCount = Long.max(this.incrementReadOperationCountForDisk.getOrDefault(readCostEntry.getKey(), 1L) + this.incrementMergedReadOperationCountForDisk.getOrDefault(readCostEntry.getKey(), 1L), 1L);
            avgReadTimeCostMap.put(readCostEntry.getKey(), (double)readCostEntry.getValue().longValue() / (double)readOpsCount);
        }
        return avgReadTimeCostMap;
    }

    @Override
    public Map<String, Double> getAvgWriteCostTimeOfEachOpsForDisk() {
        HashMap<String, Double> avgWriteTimeCostMap = new HashMap<String, Double>(this.diskIdSet.size());
        for (Map.Entry<String, Long> writeCostEntry : this.incrementWriteTimeCostForDisk.entrySet()) {
            long writeOpsCount = Long.max(this.incrementWriteOperationCountForDisk.getOrDefault(writeCostEntry.getKey(), 1L) + this.incrementMergedWriteOperationCountForDisk.getOrDefault(writeCostEntry.getKey(), 1L), 1L);
            avgWriteTimeCostMap.put(writeCostEntry.getKey(), (double)writeCostEntry.getValue().longValue() / (double)writeOpsCount);
        }
        return avgWriteTimeCostMap;
    }

    @Override
    public Map<String, Double> getAvgSizeOfEachReadForDisk() {
        HashMap<String, Double> avgSizeOfReadMap = new HashMap<String, Double>(this.diskIdSet.size());
        for (Map.Entry<String, Long> readSectorSizeEntry : this.incrementReadSectorCountForDisk.entrySet()) {
            long readOpsCount = Long.max(this.incrementReadOperationCountForDisk.getOrDefault(readSectorSizeEntry.getKey(), 1L) + this.incrementMergedReadOperationCountForDisk.getOrDefault(readSectorSizeEntry.getKey(), 1L), 1L);
            int sectorSize = this.diskSectorSizeMap.getOrDefault(readSectorSizeEntry.getKey(), 512);
            avgSizeOfReadMap.put(readSectorSizeEntry.getKey(), (double)readSectorSizeEntry.getValue().longValue() / (double)readOpsCount * (double)sectorSize);
        }
        return avgSizeOfReadMap;
    }

    @Override
    public Map<String, Double> getAvgSizeOfEachWriteForDisk() {
        HashMap<String, Double> avgSizeOfWriteMap = new HashMap<String, Double>(this.diskIdSet.size());
        for (Map.Entry<String, Long> writeSectorSizeEntry : this.incrementWriteSectorCountForDisk.entrySet()) {
            long writeOpsCount = Long.max(this.incrementWriteOperationCountForDisk.getOrDefault(writeSectorSizeEntry.getKey(), 1L) + this.incrementMergedWriteOperationCountForDisk.getOrDefault(writeSectorSizeEntry.getKey(), 1L), 1L);
            int sectorSize = this.diskSectorSizeMap.getOrDefault(writeSectorSizeEntry.getKey(), 512);
            avgSizeOfWriteMap.put(writeSectorSizeEntry.getKey(), (double)writeSectorSizeEntry.getValue().longValue() / (double)writeOpsCount * (double)sectorSize);
        }
        return avgSizeOfWriteMap;
    }

    @Override
    public Map<String, Long> getMergedWriteOperationForDisk() {
        return this.lastMergedWriteCountForDisk;
    }

    @Override
    public Map<String, Long> getMergedReadOperationForDisk() {
        return this.lastMergedReadCountForDisk;
    }

    @Override
    public Map<String, Double> getQueueSizeForDisk() {
        HashMap<String, Double> avgQueueSizeMap = new HashMap<String, Double>(this.diskIdSet.size());
        for (Map.Entry<String, Long> entry : this.incrementTimeInQueueForDisk.entrySet()) {
            avgQueueSizeMap.put(entry.getKey(), (double)entry.getValue().longValue() / (double)this.updateInterval);
        }
        return avgQueueSizeMap;
    }

    @Override
    public double getActualReadDataSizeForProcess() {
        return (double)this.lastReallyReadSizeForProcess / 1024.0;
    }

    @Override
    public double getActualWriteDataSizeForProcess() {
        return (double)this.lastReallyWriteSizeForProcess / 1024.0;
    }

    @Override
    public long getReadOpsCountForProcess() {
        return this.lastReadOpsCountForProcess;
    }

    @Override
    public long getWriteOpsCountForProcess() {
        return this.lastWriteOpsCountForProcess;
    }

    @Override
    public double getAttemptReadSizeForProcess() {
        return (double)this.lastAttemptReadSizeForProcess / 1024.0;
    }

    @Override
    public double getAttemptWriteSizeForProcess() {
        return (double)this.lastAttemptWriteSizeForProcess / 1024.0;
    }

    @Override
    public Set<String> getDiskIds() {
        return this.diskIdSet;
    }

    private void collectDiskId() {
        File diskIdFolder = new File(DISK_ID_PATH);
        if (!diskIdFolder.exists()) {
            return;
        }
        this.diskIdSet = new ArrayList<File>(Arrays.asList(Objects.requireNonNull(diskIdFolder.listFiles()))).stream().filter(x -> !x.getName().startsWith("loop") && !x.getName().startsWith("ram")).map(File::getName).collect(Collectors.toSet());
    }

    private void collectDiskInfo() {
        for (String diskId : this.diskIdSet) {
            String diskSectorSizePath = String.format(DISK_SECTOR_SIZE_PATH, diskId);
            File diskSectorSizeFile = new File(diskSectorSizePath);
            try (Scanner scanner = new Scanner(Files.newInputStream(diskSectorSizeFile.toPath(), new OpenOption[0]));){
                if (scanner.hasNext()) {
                    int sectorSize = Integer.parseInt(scanner.nextLine());
                    this.diskSectorSizeMap.put(diskId, sectorSize);
                    continue;
                }
                this.diskSectorSizeMap.put(diskId, 512);
            }
            catch (IOException e) {
                LOGGER.warn("Failed to get the sector size of {}", (Object)diskId, (Object)e);
                this.diskSectorSizeMap.put(diskId, 512);
            }
        }
    }

    private void updateInfo() {
        long currentTime = System.currentTimeMillis();
        this.updateInterval = currentTime - this.lastUpdateTime;
        this.lastUpdateTime = currentTime;
        this.updateDiskInfo();
        this.updateProcessInfo();
    }

    private void updateDiskInfo() {
        File diskStatsFile = new File(DISK_STATUS_FILE_PATH);
        if (!diskStatsFile.exists()) {
            LOGGER.warn("Cannot find disk io status file {}", (Object)DISK_STATUS_FILE_PATH);
            return;
        }
        try (Scanner diskStatsScanner = new Scanner(Files.newInputStream(diskStatsFile.toPath(), new OpenOption[0]));){
            while (diskStatsScanner.hasNextLine()) {
                String[] diskInfo = diskStatsScanner.nextLine().split("\\s+");
                String diskId = diskInfo[3];
                if (!this.diskIdSet.contains(diskId)) continue;
                int[] offsetArray = new int[]{4, 8, 5, 9, 6, 10, 7, 11, 13, 14};
                Map[] lastMapArray = new Map[]{this.lastReadOperationCountForDisk, this.lastWriteOperationCountForDisk, this.lastMergedReadCountForDisk, this.lastMergedWriteCountForDisk, this.lastReadSectorCountForDisk, this.lastWriteSectorCountForDisk, this.lastReadTimeCostForDisk, this.lastWriteTimeCostForDisk, this.lastIoBusyTimeForDisk, this.lastTimeInQueueForDisk};
                Map[] incrementMapArray = new Map[]{this.incrementReadOperationCountForDisk, this.incrementWriteOperationCountForDisk, this.incrementMergedReadOperationCountForDisk, this.incrementMergedWriteOperationCountForDisk, this.incrementReadSectorCountForDisk, this.incrementWriteSectorCountForDisk, this.incrementReadTimeCostForDisk, this.incrementWriteTimeCostForDisk, this.incrementIoBusyTimeForDisk, this.incrementTimeInQueueForDisk};
                int length = offsetArray.length;
                for (int index = 0; index < length; ++index) {
                    this.updateSingleDiskInfo(diskId, diskInfo, offsetArray[index], lastMapArray[index], incrementMapArray[index]);
                }
            }
        }
        catch (IOException e) {
            LOGGER.error("Meets error while updating disk io info", e);
        }
    }

    private void updateSingleDiskInfo(String diskId, String[] diskInfo, int offset, Map<String, Long> lastMap, Map<String, Long> incrementMap) {
        long currentValue = Long.parseLong(diskInfo[offset]);
        if (incrementMap != null) {
            long lastValue = lastMap.getOrDefault(diskId, 0L);
            if (lastValue != 0L) {
                incrementMap.put(diskId, currentValue - lastValue);
            } else {
                incrementMap.put(diskId, 0L);
            }
        }
        lastMap.put(diskId, currentValue);
    }

    private void updateProcessInfo() {
        File processStatInfoFile = new File(this.processIoStatusPath);
        if (!processStatInfoFile.exists()) {
            LOGGER.warn("Cannot find process io status file {}", (Object)this.processIoStatusPath);
        }
        try (Scanner processStatsScanner = new Scanner(Files.newInputStream(processStatInfoFile.toPath(), new OpenOption[0]));){
            while (processStatsScanner.hasNextLine()) {
                String infoLine = processStatsScanner.nextLine();
                if (infoLine.startsWith("syscr")) {
                    this.lastReadOpsCountForProcess = Long.parseLong(infoLine.split(":\\s")[1]);
                    continue;
                }
                if (infoLine.startsWith("syscw")) {
                    this.lastWriteOpsCountForProcess = Long.parseLong(infoLine.split(":\\s")[1]);
                    continue;
                }
                if (infoLine.startsWith("read_bytes")) {
                    this.lastReallyReadSizeForProcess = Long.parseLong(infoLine.split(":\\s")[1]);
                    continue;
                }
                if (infoLine.startsWith("write_bytes")) {
                    this.lastReallyWriteSizeForProcess = Long.parseLong(infoLine.split(":\\s")[1]);
                    continue;
                }
                if (infoLine.startsWith("rchar")) {
                    this.lastAttemptReadSizeForProcess = Long.parseLong(infoLine.split(":\\s")[1]);
                    continue;
                }
                if (!infoLine.startsWith("wchar")) continue;
                this.lastAttemptWriteSizeForProcess = Long.parseLong(infoLine.split(":\\s")[1]);
            }
        }
        catch (IOException e) {
            LOGGER.error("Meets error while updating process io info", e);
        }
    }

    private void checkUpdate() {
        if (System.currentTimeMillis() - this.lastUpdateTime > 10000L) {
            this.updateInfo();
        }
    }
}

