/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.metrics.core.type;

import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.distribution.HistogramSnapshot;
import java.util.concurrent.TimeUnit;
import javax.management.ObjectName;

public class IoTDBTimerHistogramSnapshot
implements org.apache.iotdb.metrics.type.HistogramSnapshot {
    Timer timer;
    HistogramSnapshot histogramSnapshot;
    private final TimeUnit baseTimeUnit;

    public IoTDBTimerHistogramSnapshot(Timer timer) {
        this.timer = timer;
        this.histogramSnapshot = timer.takeSnapshot();
        this.baseTimeUnit = timer.baseTimeUnit();
    }

    @Override
    public double getValue(double quantile) {
        int prevIndex = 0;
        for (int i = 0; i < this.histogramSnapshot.percentileValues().length; ++i) {
            if (this.histogramSnapshot.percentileValues()[i].percentile() <= quantile) {
                prevIndex = i;
            }
            if (this.histogramSnapshot.percentileValues()[i].percentile() >= quantile) break;
        }
        return this.histogramSnapshot.percentileValues()[prevIndex].value(this.baseTimeUnit);
    }

    @Override
    public double getSum() {
        return this.timer.totalTime(this.baseTimeUnit);
    }

    @Override
    public int size() {
        return this.histogramSnapshot.percentileValues().length;
    }

    @Override
    public double getMax() {
        return this.histogramSnapshot.max(this.baseTimeUnit);
    }

    @Override
    public double getMean() {
        return this.histogramSnapshot.mean(this.baseTimeUnit);
    }

    @Override
    public void setObjectName(ObjectName objectName) {
    }
}

