/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.metrics.core.reporter;

import java.lang.management.ManagementFactory;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.apache.iotdb.metrics.AbstractMetricManager;
import org.apache.iotdb.metrics.core.IoTDBMetricManager;
import org.apache.iotdb.metrics.core.uitls.IoTDBMetricObjNameFactory;
import org.apache.iotdb.metrics.core.uitls.ObjectNameFactory;
import org.apache.iotdb.metrics.reporter.JmxReporter;
import org.apache.iotdb.metrics.type.IMetric;
import org.apache.iotdb.metrics.utils.MetricInfo;
import org.apache.iotdb.metrics.utils.ReporterType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IoTDBJmxReporter
implements JmxReporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(IoTDBJmxReporter.class);
    private static final String DOMAIN = "org.apache.iotdb.metrics";
    private final AbstractMetricManager metricManager;
    private final ObjectNameFactory objectNameFactory;
    private final Map<ObjectName, ObjectName> registered;
    private final MBeanServer mBeanServer;

    private void registerMBean(Object mBean, ObjectName objectName) throws JMException {
        if (!this.mBeanServer.isRegistered(objectName)) {
            ObjectInstance objectInstance = this.mBeanServer.registerMBean(mBean, objectName);
            if (objectInstance != null) {
                this.registered.put(objectName, objectInstance.getObjectName());
            } else {
                this.registered.put(objectName, objectName);
            }
        }
    }

    private void unregisterMBean(ObjectName originalObjectName) throws InstanceNotFoundException, MBeanRegistrationException {
        ObjectName storedObjectName = this.registered.remove(originalObjectName);
        if (storedObjectName != null) {
            if (this.mBeanServer.isRegistered(storedObjectName)) {
                this.mBeanServer.unregisterMBean(storedObjectName);
            }
        } else if (this.mBeanServer.isRegistered(originalObjectName)) {
            this.mBeanServer.unregisterMBean(originalObjectName);
        }
    }

    @Override
    public void registerMetric(IMetric metric, MetricInfo metricInfo) {
        String metricName = metric.getClass().getSimpleName();
        try {
            ObjectName objectName = this.createName(metricName, metricInfo);
            metric.setObjectName(objectName);
            this.registerMBean(metric, objectName);
        }
        catch (Exception e) {
            LOGGER.warn("IoTDB Metric: Unable to register " + metricName, e);
        }
    }

    @Override
    public void unregisterMetric(IMetric metric, MetricInfo metricInfo) {
        String metricName = metric.getClass().getSimpleName();
        try {
            ObjectName objectName = this.createName(metricName, metricInfo);
            this.unregisterMBean(objectName);
        }
        catch (InstanceNotFoundException e) {
            LOGGER.debug("IoTDB Metric: Unable to unregister: ", e);
        }
        catch (MBeanRegistrationException e) {
            LOGGER.warn("IoTDB Metric: Unable to unregister: ", e);
        }
    }

    private ObjectName createName(String type, MetricInfo metricInfo) {
        String name = metricInfo.getName();
        return this.objectNameFactory.createName(type, DOMAIN, name);
    }

    void unregisterAll() throws InstanceNotFoundException, MBeanRegistrationException {
        for (ObjectName name : this.registered.keySet()) {
            this.unregisterMBean(name);
        }
        this.registered.clear();
    }

    private IoTDBJmxReporter(AbstractMetricManager metricManager, MBeanServer mBeanServer, ObjectNameFactory objectNameFactory) {
        this.metricManager = metricManager;
        this.mBeanServer = mBeanServer;
        this.objectNameFactory = objectNameFactory;
        this.registered = new ConcurrentHashMap<ObjectName, ObjectName>();
    }

    @Override
    public boolean start() {
        try {
            if (!this.registered.isEmpty()) {
                LOGGER.warn("IoTDB Metric: JmxReporter already start!");
                return false;
            }
            this.metricManager.getAllMetrics().forEach((key, value) -> this.registerMetric((IMetric)value, (MetricInfo)key));
        }
        catch (Exception e) {
            LOGGER.warn("IoTDB Metric: JmxReporter failed to start, because ", e);
            return false;
        }
        LOGGER.info("IoTDB Metric: JmxReporter start!");
        return true;
    }

    @Override
    public boolean stop() {
        try {
            this.unregisterAll();
        }
        catch (Exception e) {
            LOGGER.warn("IoTDB Metric: JmxReporter failed to stop, because ", e);
            return false;
        }
        LOGGER.info("IoTDB Metric: JmxReporter stop!");
        return true;
    }

    @Override
    public ReporterType getReporterType() {
        return ReporterType.JMX;
    }

    public static IoTDBJmxReporter getInstance() {
        return IoTDBJmxReporterHolder.INSTANCE;
    }

    private static class IoTDBJmxReporterHolder {
        private static final IoTDBJmxReporter INSTANCE = new IoTDBJmxReporter(IoTDBMetricManager.getInstance(), ManagementFactory.getPlatformMBeanServer(), IoTDBMetricObjNameFactory.getInstance());

        private IoTDBJmxReporterHolder() {
        }
    }
}

