/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.metrics.config;

import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.iotdb.metrics.config.MetricConfig;
import org.apache.iotdb.metrics.config.ReloadLevel;
import org.apache.iotdb.metrics.utils.InternalReporterType;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.metrics.utils.ReporterType;

public class MetricConfigDescriptor {
    private static final MetricConfig metricConfig = new MetricConfig();

    private MetricConfigDescriptor() {
    }

    public void loadProps(Properties properties) {
        MetricConfig loadConfig = this.generateFromProperties(properties);
        metricConfig.copy(loadConfig);
    }

    public ReloadLevel loadHotProps(Properties properties) {
        MetricConfig newMetricConfig = this.generateFromProperties(properties);
        ReloadLevel reloadLevel = ReloadLevel.NOTHING;
        if (!metricConfig.equals(newMetricConfig)) {
            reloadLevel = !metricConfig.getMetricLevel().equals((Object)newMetricConfig.getMetricLevel()) || !metricConfig.getAsyncCollectPeriodInSecond().equals(newMetricConfig.getAsyncCollectPeriodInSecond()) ? ReloadLevel.RESTART_METRIC : (!metricConfig.getInternalReportType().equals((Object)newMetricConfig.getInternalReportType()) ? ReloadLevel.RESTART_INTERNAL_REPORTER : ReloadLevel.RESTART_REPORTER);
            metricConfig.copy(newMetricConfig);
        }
        return reloadLevel;
    }

    private MetricConfig generateFromProperties(Properties properties) {
        MetricConfig loadConfig = new MetricConfig();
        String reporterList = this.getProperty("metric_reporter_list", String.join((CharSequence)",", loadConfig.getMetricReporterList().stream().map(ReporterType::toString).collect(Collectors.toSet())), properties);
        loadConfig.setMetricReporterList(reporterList);
        loadConfig.setMetricLevel(MetricLevel.valueOf(this.getProperty("metric_level", String.valueOf((Object)loadConfig.getMetricLevel()), properties)));
        loadConfig.setAsyncCollectPeriodInSecond(Integer.parseInt(this.getProperty("metric_async_collect_period", String.valueOf(loadConfig.getAsyncCollectPeriodInSecond()), properties)));
        loadConfig.setPrometheusReporterPort(Integer.parseInt(this.getProperty("metric_prometheus_reporter_port", String.valueOf(loadConfig.getPrometheusReporterPort()), properties)));
        MetricConfig.IoTDBReporterConfig reporterConfig = loadConfig.getIoTDBReporterConfig();
        reporterConfig.setHost(this.getProperty("metric_iotdb_reporter_host", reporterConfig.getHost(), properties));
        reporterConfig.setPort(Integer.valueOf(this.getProperty("metric_iotdb_reporter_port", String.valueOf(reporterConfig.getPort()), properties)));
        reporterConfig.setUsername(this.getProperty("metric_iotdb_reporter_username", reporterConfig.getUsername(), properties));
        reporterConfig.setPassword(this.getProperty("metric_iotdb_reporter_password", reporterConfig.getPassword(), properties));
        reporterConfig.setMaxConnectionNumber(Integer.valueOf(this.getProperty("metric_iotdb_reporter_max_connection_number", String.valueOf(reporterConfig.getMaxConnectionNumber()), properties)));
        reporterConfig.setLocation(this.getProperty("metric_iotdb_reporter_location", reporterConfig.getLocation(), properties));
        reporterConfig.setPushPeriodInSecond(Integer.valueOf(this.getProperty("metric_iotdb_reporter_push_period", String.valueOf(reporterConfig.getPushPeriodInSecond()), properties)));
        loadConfig.setInternalReportType(InternalReporterType.valueOf(properties.getProperty("dn_metric_internal_reporter_type", loadConfig.getInternalReportType().toString())));
        return loadConfig;
    }

    private String getProperty(String target, String defaultValue, Properties properties) {
        return properties.getProperty("dn_" + target, properties.getProperty("cn_" + target, defaultValue));
    }

    public static MetricConfigDescriptor getInstance() {
        return MetricConfigDescriptorHolder.INSTANCE;
    }

    public MetricConfig getMetricConfig() {
        return metricConfig;
    }

    private static class MetricConfigDescriptorHolder {
        private static final MetricConfigDescriptor INSTANCE = new MetricConfigDescriptor();

        private MetricConfigDescriptorHolder() {
        }
    }
}

