/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.flink.sql.function;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.streaming.api.functions.source.RichSourceFunction;
import org.apache.flink.streaming.api.functions.source.SourceFunction;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.DataType;
import org.apache.iotdb.flink.sql.client.IoTDBWebSocketClient;
import org.apache.iotdb.flink.sql.common.Options;
import org.apache.iotdb.flink.sql.common.Utils;
import org.apache.iotdb.flink.sql.exception.IllegalOptionException;
import org.apache.iotdb.flink.sql.exception.IllegalSchemaException;
import org.apache.iotdb.flink.sql.wrapper.SchemaWrapper;
import org.apache.iotdb.flink.sql.wrapper.TabletWrapper;
import org.apache.iotdb.isession.SessionDataSet;
import org.apache.iotdb.session.Session;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.RowRecord;
import org.apache.iotdb.tsfile.utils.BitMap;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.write.record.Tablet;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.enums.ReadyState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IoTDBCDCSourceFunction
extends RichSourceFunction<RowData> {
    private static final Logger LOGGER = LoggerFactory.getLogger(IoTDBCDCSourceFunction.class);
    private final List<IoTDBWebSocketClient> socketClients = new ArrayList<IoTDBWebSocketClient>();
    private final int cdcPort;
    private final List<String> nodeUrls;
    private final String taskName;
    private final String pattern;
    private final String user;
    private final String password;
    private final List<String> timeseriesList;
    private final BlockingQueue<TabletWrapper> tabletWrappers;
    private final List<Tuple2<String, DataType>> tableSchema;
    private final String pipeName;
    private final Options.CDCMode mode;
    private transient ExecutorService consumeExecutor;

    public IoTDBCDCSourceFunction(ReadableConfig options, SchemaWrapper schemaWrapper) {
        this.tableSchema = schemaWrapper.getSchema();
        this.pattern = (String)options.get(Options.PATTERN);
        this.cdcPort = (Integer)options.get(Options.CDC_PORT);
        this.nodeUrls = Arrays.asList(((String)options.get(Options.NODE_URLS)).split(","));
        this.taskName = (String)options.get(Options.CDC_TASK_NAME);
        this.pipeName = String.format("flink_cdc_%s", this.taskName);
        this.user = (String)options.get(Options.USER);
        this.password = (String)options.get(Options.PASSWORD);
        this.timeseriesList = this.tableSchema.stream().map(field -> String.valueOf(field.f0)).collect(Collectors.toList());
        this.mode = (Options.CDCMode)((Object)options.get(Options.CDC_MODE));
        this.tabletWrappers = new ArrayBlockingQueue<TabletWrapper>(this.nodeUrls.size() * 10);
    }

    public void open(Configuration parameters) throws Exception {
        super.open(parameters);
        Session session = new Session.Builder().username(this.user).password(this.password).nodeUrls(this.nodeUrls).build();
        session.open(false);
        try (SessionDataSet dataSet = session.executeQueryStatement(String.format("show pipe %s", this.pipeName));){
            if (!dataSet.hasNext()) {
                String createPipeCommand = Options.CDCMode.REALTIME.equals((Object)this.mode) ? String.format("CREATE PIPE %s\nWITH EXTRACTOR (\n'extractor' = 'iotdb-extractor',\n'extractor.history.enable' = 'false',\n'extractor.pattern' = '%s',\n) WITH CONNECTOR (\n'connector' = 'websocket-connector',\n'connector.websocket.port' = '%d',\n'connector.websocket.id' = '%d')", this.pipeName, this.pattern, this.cdcPort, System.currentTimeMillis()) : String.format("CREATE PIPE %s\nWITH EXTRACTOR (\n'extractor' = 'iotdb-extractor',\n'extractor.pattern' = '%s',\n) WITH CONNECTOR (\n'connector' = 'websocket-connector',\n'connector.websocket.port' = '%d',\n'connector.websocket.id' = '%d')", this.pipeName, this.pattern, this.cdcPort, System.currentTimeMillis());
                session.executeNonQueryStatement(createPipeCommand);
                session.executeNonQueryStatement(String.format("start pipe %s", this.pipeName));
            } else {
                RowRecord pipe = dataSet.next();
                String pipePattern = pipe.getFields().get(3).getStringValue().split(",")[0].split("=")[1];
                if (!pipePattern.equals(this.pattern)) {
                    throw new IllegalOptionException(String.format("The CDC task `%s` has been created by pattern `%s`.", this.taskName, this.pattern));
                }
                String status = pipe.getFields().get(2).getStringValue();
                if ("STOPPED".equals(status)) {
                    session.executeNonQueryStatement(String.format("start pipe %s", this.pipeName));
                }
            }
        }
        session.close();
        this.consumeExecutor = Executors.newFixedThreadPool(1);
        for (String nodeUrl : this.nodeUrls) {
            URI uri = new URI(String.format("ws://%s:%s", nodeUrl.split(":")[0], this.cdcPort));
            this.socketClients.add(this.initAndGet(uri));
        }
    }

    public void run(SourceFunction.SourceContext<RowData> ctx) throws InterruptedException {
        this.consumeExecutor.execute(new ConsumeRunnable(ctx));
        this.consumeExecutor.shutdown();
        block0: while (true) {
            if (this.consumeExecutor.isTerminated()) {
                System.exit(1);
            }
            Iterator<IoTDBWebSocketClient> iterator = this.socketClients.iterator();
            while (true) {
                if (!iterator.hasNext()) continue block0;
                IoTDBWebSocketClient socketClient = iterator.next();
                if (socketClient.getReadyState().equals((Object)ReadyState.CLOSED)) {
                    while (!Utils.isURIAvailable(socketClient.getURI())) {
                        String log = String.format("The URI %s:%d is not available now, sleep 5 seconds.", socketClient.getURI().getHost(), socketClient.getURI().getPort());
                        LOGGER.warn(log);
                        Thread.sleep(5000L);
                    }
                    socketClient.reconnect();
                    while (!socketClient.getReadyState().equals((Object)ReadyState.OPEN)) {
                        Thread.sleep(1000L);
                    }
                    socketClient.send(String.format("BIND:%s", this.pipeName));
                    continue;
                }
                Thread.sleep(1000L);
            }
            break;
        }
    }

    public void cancel() {
        this.socketClients.forEach(WebSocketClient::close);
    }

    public void addTabletWrapper(TabletWrapper tabletWrapper) {
        try {
            this.tabletWrappers.put(tabletWrapper);
        }
        catch (InterruptedException e) {
            String host = tabletWrapper.getWebSocketClient().getRemoteSocketAddress().getHostName();
            int port = tabletWrapper.getWebSocketClient().getRemoteSocketAddress().getPort();
            String log = String.format("The tablet from %s:%d can't be put into queue, because: %s", host, port, e.getMessage());
            LOGGER.warn(log);
            Thread.currentThread().interrupt();
        }
    }

    private IoTDBWebSocketClient initAndGet(URI uri) throws InterruptedException {
        while (!Utils.isURIAvailable(uri)) {
            String log = String.format("The URI %s:%d is not available now, sleep 5 seconds.", uri.getHost(), uri.getPort());
            LOGGER.warn(log);
            Thread.sleep(5000L);
        }
        IoTDBWebSocketClient client = new IoTDBWebSocketClient(uri, this);
        client.connect();
        while (!client.getReadyState().equals((Object)ReadyState.OPEN)) {
            Thread.sleep(1000L);
        }
        client.send(String.format("BIND:%s", this.pipeName));
        while (IoTDBWebSocketClient.Status.WAITING == client.getStatus()) {
            Thread.sleep(1000L);
        }
        if (IoTDBWebSocketClient.Status.ERROR == client.getStatus()) {
            throw new IllegalOptionException("An exception occurred during binding. The CDC task is running. Please stop it first.");
        }
        return client;
    }

    public void collectTablet(Tablet tablet, SourceFunction.SourceContext<RowData> ctx) {
        List<MeasurementSchema> schemas = tablet.getSchemas();
        int rowSize = tablet.rowSize;
        HashMap<Object, Pair<BitMap, List<Object>>> values = new HashMap<Object, Pair<BitMap, List<Object>>>();
        for (MeasurementSchema schema : schemas) {
            String timeseries = String.format("%s.%s", tablet.deviceId, schema.getMeasurementId());
            TSDataType iotdbType = schema.getType();
            int index = this.timeseriesList.indexOf(timeseries);
            if (index == -1) {
                return;
            }
            DataType flinkType = (DataType)this.tableSchema.get((int)index).f1;
            if (!Utils.isTypeEqual(iotdbType, flinkType)) {
                throw new IllegalSchemaException(String.format("The data type of column `%s` is different in IoTDB and Flink", timeseries));
            }
            values.put(timeseries, new Pair<BitMap, List<Object>>(tablet.bitMaps[schemas.indexOf(schema)], Utils.object2List(tablet.values[schemas.indexOf(schema)], iotdbType)));
        }
        for (int i = 0; i < rowSize; ++i) {
            ArrayList<Long> row = new ArrayList<Long>();
            row.add(tablet.timestamps[i]);
            for (String timeseries : this.timeseriesList) {
                if (values.containsKey(timeseries) && (((Pair)values.get(timeseries)).getLeft() == null || !((BitMap)((Pair)values.get(timeseries)).getLeft()).isMarked(i))) {
                    row.add((Long)((List)((Pair)values.get(timeseries)).getRight()).get(i));
                    continue;
                }
                row.add(null);
            }
            GenericRowData rowData = GenericRowData.of((Object[])row.toArray());
            ctx.collect((Object)rowData);
        }
    }

    private class ConsumeRunnable
    implements Runnable {
        SourceFunction.SourceContext<RowData> context;

        public ConsumeRunnable(SourceFunction.SourceContext<RowData> context) {
            this.context = context;
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        TabletWrapper tabletWrapper = (TabletWrapper)IoTDBCDCSourceFunction.this.tabletWrappers.take();
                        IoTDBCDCSourceFunction.this.collectTablet(tabletWrapper.getTablet(), this.context);
                        tabletWrapper.getWebSocketClient().send(String.format("ACK:%d", tabletWrapper.getCommitId()));
                    }
                }
                catch (InterruptedException e) {
                    LOGGER.warn("The tablet can't be taken from queue!");
                    Thread.currentThread().interrupt();
                    continue;
                }
                break;
            }
        }
    }
}

