/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.flink.sql.common;

import java.io.IOException;
import java.lang.reflect.Array;
import java.net.Socket;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.types.DataType;
import org.apache.iotdb.flink.sql.exception.UnsupportedDataTypeException;
import org.apache.iotdb.tsfile.common.conf.TSFileConfig;
import org.apache.iotdb.tsfile.exception.NullFieldException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.Field;
import org.apache.iotdb.tsfile.read.common.RowRecord;
import org.apache.iotdb.tsfile.utils.Binary;

public class Utils {
    private static final Pattern pattern = Pattern.compile("\\d*");
    private static final Map<TSDataType, DataType> typeMap = new HashMap<TSDataType, DataType>();

    private Utils() {
    }

    public static Object getValue(Field value, String dataType) {
        try {
            if ("INT32".equals(dataType)) {
                return value.getIntV();
            }
            if ("INT64".equals(dataType)) {
                return value.getLongV();
            }
            if ("FLOAT".equals(dataType)) {
                return Float.valueOf(value.getFloatV());
            }
            if ("DOUBLE".equals(dataType)) {
                return value.getDoubleV();
            }
            if ("BOOLEAN".equals(dataType)) {
                return value.getBoolV();
            }
            if ("TEXT".equals(dataType)) {
                return StringData.fromString((String)value.getStringValue());
            }
            String exception = String.format("IoTDB doesn't support the data type: %s", dataType);
            throw new UnsupportedDataTypeException(exception);
        }
        catch (NullFieldException e) {
            return null;
        }
    }

    public static Object getValue(Field value, DataType dataType) {
        if (value.getDataType() == null) {
            return null;
        }
        if (dataType.equals((Object)DataTypes.INT())) {
            return value.getIntV();
        }
        if (dataType.equals((Object)DataTypes.BIGINT())) {
            return value.getLongV();
        }
        if (dataType.equals((Object)DataTypes.FLOAT())) {
            return Float.valueOf(value.getFloatV());
        }
        if (dataType.equals((Object)DataTypes.DOUBLE())) {
            return value.getDoubleV();
        }
        if (dataType.equals((Object)DataTypes.BOOLEAN())) {
            return value.getBoolV();
        }
        if (dataType.equals((Object)DataTypes.STRING())) {
            return StringData.fromString((String)value.getStringValue());
        }
        throw new UnsupportedDataTypeException("IoTDB doesn't support the data type: " + dataType);
    }

    public static Object getValue(RowData value, DataType dataType, int index) {
        try {
            if (dataType.equals((Object)DataTypes.INT())) {
                return value.getInt(index);
            }
            if (dataType.equals((Object)DataTypes.BIGINT())) {
                return value.getLong(index);
            }
            if (dataType.equals((Object)DataTypes.FLOAT())) {
                return Float.valueOf(value.getFloat(index));
            }
            if (dataType.equals((Object)DataTypes.DOUBLE())) {
                return value.getDouble(index);
            }
            if (dataType.equals((Object)DataTypes.BOOLEAN())) {
                return value.getBoolean(index);
            }
            if (dataType.equals((Object)DataTypes.STRING())) {
                return value.getString(index).toString();
            }
            throw new UnsupportedDataTypeException("IoTDB don't support the data type: " + dataType);
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    public static boolean isNumeric(String s2) {
        return pattern.matcher(s2).matches();
    }

    public static RowData convert(RowRecord rowRecord, List<String> columnNames, List<Tuple2<String, DataType>> tableSchema) {
        ArrayList<Object> values = new ArrayList<Object>();
        values.add(rowRecord.getTimestamp());
        List<Field> fields = rowRecord.getFields();
        for (Tuple2<String, DataType> field : tableSchema) {
            if (!columnNames.contains(field.f0)) {
                values.add(null);
                continue;
            }
            values.add(Utils.getValue(fields.get(columnNames.indexOf(field.f0) - 1), (DataType)field.f1));
        }
        return GenericRowData.of((Object[])values.toArray());
    }

    public static List<Object> object2List(Object obj, TSDataType dataType) {
        ArrayList<Object> objects = new ArrayList<Object>();
        int length = Array.getLength(obj);
        for (int i = 0; i < length; ++i) {
            if (dataType == TSDataType.TEXT) {
                objects.add(StringData.fromString((String)((Binary)Array.get(obj, i)).getStringValue(TSFileConfig.STRING_CHARSET)));
                continue;
            }
            objects.add(Array.get(obj, i));
        }
        return objects;
    }

    public static boolean isURIAvailable(URI uri) {
        try {
            new Socket(uri.getHost(), uri.getPort()).close();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static boolean isTypeEqual(@Nullable TSDataType iotdbType, DataType flinkType) {
        return typeMap.get((Object)iotdbType).equals((Object)flinkType);
    }

    static {
        typeMap.put(TSDataType.INT32, DataTypes.INT());
        typeMap.put(TSDataType.INT64, DataTypes.BIGINT());
        typeMap.put(TSDataType.FLOAT, DataTypes.FLOAT());
        typeMap.put(TSDataType.DOUBLE, DataTypes.DOUBLE());
        typeMap.put(TSDataType.BOOLEAN, DataTypes.BOOLEAN());
        typeMap.put(TSDataType.TEXT, DataTypes.STRING());
    }
}

