/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.utils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.util.Arrays;
import java.util.Objects;
import org.apache.iotdb.commons.file.SystemFileFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileUtils.class);
    private static final int BUFFER_SIZE = 1024;

    private FileUtils() {
    }

    public static boolean deleteFileIfExist(File file) {
        try {
            Files.deleteIfExists(file.toPath());
            return true;
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), e);
            return false;
        }
    }

    public static void deleteDirectory(File folder) {
        if (folder.isDirectory()) {
            for (File file : folder.listFiles()) {
                FileUtils.deleteDirectory(file);
            }
        }
        try {
            Files.delete(folder.toPath());
        }
        catch (DirectoryNotEmptyException | NoSuchFileException e) {
            LOGGER.warn("{}: {}", e.getMessage(), Arrays.toString(folder.list()), e);
        }
        catch (Exception e) {
            LOGGER.warn("{}: {}", e.getMessage(), folder.getName(), e);
        }
    }

    public static void deleteDirectoryAndEmptyParent(File folder) {
        FileUtils.deleteDirectory(folder);
        File parentFolder = folder.getParentFile();
        if (parentFolder.isDirectory() && Objects.requireNonNull(parentFolder.listFiles()).length == 0 && !parentFolder.delete()) {
            LOGGER.warn("Delete folder failed: {}", (Object)parentFolder.getAbsolutePath());
        }
    }

    public static boolean copyDir(File sourceDir, File targetDir) throws IOException {
        File[] files;
        if (!sourceDir.exists() || !sourceDir.isDirectory()) {
            LOGGER.error("Failed to copy folder, because source folder [{}] doesn't exist.", (Object)sourceDir.getAbsolutePath());
            return false;
        }
        if (!targetDir.exists()) {
            if (!targetDir.mkdirs()) {
                LOGGER.error("Failed to copy folder, because failed to create target folder[{}].", (Object)targetDir.getAbsolutePath());
                return false;
            }
        } else if (!targetDir.isDirectory()) {
            LOGGER.error("Failed to copy folder, because target folder [{}] already exist.", (Object)targetDir.getAbsolutePath());
            return false;
        }
        if ((files = sourceDir.listFiles()) == null || files.length == 0) {
            return true;
        }
        boolean result = true;
        for (File file : files) {
            if (!file.exists()) continue;
            File targetFile = new File(targetDir, file.getName());
            if (file.isDirectory()) {
                result &= FileUtils.copyDir(file.getAbsoluteFile(), targetFile);
                continue;
            }
            try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
                 FileOutputStream fileOutputStream = new FileOutputStream(targetFile);
                 BufferedOutputStream out = new BufferedOutputStream(fileOutputStream);){
                byte[] bytes = new byte[1024];
                int size = 0;
                while ((size = in.read(bytes)) > 0) {
                    out.write(bytes, 0, size);
                }
                out.flush();
                fileOutputStream.getFD().sync();
            }
            catch (IOException e) {
                LOGGER.warn("get ioexception on file {}", (Object)file.getAbsolutePath(), (Object)e);
                throw e;
            }
        }
        return result;
    }

    public static long getDirSize(String path) {
        long sum = 0L;
        File file = SystemFileFactory.INSTANCE.getFile(path);
        if (file.isDirectory()) {
            String[] list;
            for (String item : list = file.list()) {
                String subPath = path + File.separator + item;
                sum += FileUtils.getDirSize(subPath);
            }
        } else {
            sum += file.length();
        }
        return sum;
    }

    public static void recursiveDeleteFolder(String path) throws IOException {
        File file = new File(path);
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            if (files == null || files.length == 0) {
                org.apache.commons.io.FileUtils.deleteDirectory(file);
            } else {
                for (File f : files) {
                    FileUtils.recursiveDeleteFolder(f.getAbsolutePath());
                }
                org.apache.commons.io.FileUtils.deleteDirectory(file);
            }
        } else {
            org.apache.commons.io.FileUtils.delete(file);
        }
    }

    public static String addPrefix2FilePath(String prefix, String file) {
        if (!new File(file).isAbsolute() && prefix != null && prefix.length() > 0) {
            file = !prefix.endsWith(File.separator) ? prefix + File.separatorChar + file : prefix + file;
        }
        return file;
    }
}

