/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.udf.builtin;

import java.io.IOException;
import java.util.HashMap;
import org.apache.commons.jexl3.JexlBuilder;
import org.apache.commons.jexl3.JexlEngine;
import org.apache.commons.jexl3.JexlScript;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.udf.utils.UDFDataTypeTransformer;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.udf.api.UDTF;
import org.apache.iotdb.udf.api.access.Row;
import org.apache.iotdb.udf.api.collector.PointCollector;
import org.apache.iotdb.udf.api.customizer.config.UDTFConfigurations;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameterValidator;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameters;
import org.apache.iotdb.udf.api.customizer.strategy.RowByRowAccessStrategy;
import org.apache.iotdb.udf.api.exception.UDFException;
import org.apache.iotdb.udf.api.exception.UDFInputSeriesDataTypeNotValidException;
import org.apache.iotdb.udf.api.exception.UDFOutputSeriesDataTypeNotValidException;
import org.apache.iotdb.udf.api.type.Type;

public class UDTFJexl
implements UDTF {
    private int inputSeriesNumber;
    private TSDataType[] inputDataType;
    private TSDataType outputDataType;
    private JexlScript script;
    private Evaluator evaluator;

    @Override
    public void validate(UDFParameterValidator validator) throws UDFException {
        this.inputSeriesNumber = validator.getParameters().getChildExpressionsSize();
        for (int i = 0; i < this.inputSeriesNumber; ++i) {
            validator.validateInputSeriesDataType(i, Type.INT32, Type.INT64, Type.FLOAT, Type.DOUBLE, Type.TEXT, Type.BOOLEAN);
        }
        validator.validateRequiredAttribute("expr");
    }

    @Override
    public void beforeStart(UDFParameters parameters, UDTFConfigurations configurations) throws UDFInputSeriesDataTypeNotValidException, UDFOutputSeriesDataTypeNotValidException, MetadataException {
        block10: {
            block9: {
                String expr = parameters.getString("expr");
                JexlEngine jexl = new JexlBuilder().create();
                this.script = jexl.createScript(expr);
                this.inputDataType = new TSDataType[this.inputSeriesNumber];
                for (int i = 0; i < this.inputSeriesNumber; ++i) {
                    this.inputDataType[i] = UDFDataTypeTransformer.transformToTsDataType(parameters.getDataType(i));
                }
                this.outputDataType = this.probeOutputDataType();
                if (this.inputSeriesNumber != 1) break block9;
                switch (this.inputDataType[0]) {
                    case INT32: {
                        this.evaluator = new EvaluatorIntInput();
                        break block10;
                    }
                    case INT64: {
                        this.evaluator = new EvaluatorLongInput();
                        break block10;
                    }
                    case FLOAT: {
                        this.evaluator = new EvaluatorFloatInput();
                        break block10;
                    }
                    case DOUBLE: {
                        this.evaluator = new EvaluatorDoubleInput();
                        break block10;
                    }
                    case TEXT: {
                        this.evaluator = new EvaluatorStringInput();
                        break block10;
                    }
                    case BOOLEAN: {
                        this.evaluator = new EvaluatorBooleanInput();
                        break block10;
                    }
                    default: {
                        throw new UDFInputSeriesDataTypeNotValidException(0, UDFDataTypeTransformer.transformToUDFDataType(this.inputDataType[0]), Type.INT32, Type.INT64, Type.FLOAT, Type.DOUBLE, Type.TEXT, Type.BOOLEAN);
                    }
                }
            }
            this.evaluator = new EvaluatorMulInput();
        }
        configurations.setAccessStrategy(new RowByRowAccessStrategy()).setOutputDataType(UDFDataTypeTransformer.transformToUDFDataType(this.outputDataType));
    }

    private HashMap<TSDataType, Object> initialMap() {
        HashMap<TSDataType, Object> map = new HashMap<TSDataType, Object>();
        map.put(TSDataType.INT32, 23);
        map.put(TSDataType.INT64, 23L);
        map.put(TSDataType.FLOAT, Float.valueOf(23.0f));
        map.put(TSDataType.DOUBLE, 23.0);
        map.put(TSDataType.TEXT, "string");
        map.put(TSDataType.BOOLEAN, true);
        return map;
    }

    private TSDataType probeOutputDataType() throws UDFOutputSeriesDataTypeNotValidException {
        HashMap<TSDataType, Object> map = this.initialMap();
        Object[] inputHardCodes = new Object[this.inputSeriesNumber];
        for (int i = 0; i < this.inputSeriesNumber; ++i) {
            inputHardCodes[i] = map.get((Object)this.inputDataType[i]);
        }
        Object o = this.script.execute(null, inputHardCodes);
        if (o instanceof Number) {
            return TSDataType.DOUBLE;
        }
        if (o instanceof String) {
            return TSDataType.TEXT;
        }
        if (o instanceof Boolean) {
            return TSDataType.BOOLEAN;
        }
        throw new UDFOutputSeriesDataTypeNotValidException(0, "[Number, String, Boolean]");
    }

    @Override
    public void transform(Row row, PointCollector collector) throws IOException, UDFOutputSeriesDataTypeNotValidException, UDFInputSeriesDataTypeNotValidException {
        switch (this.outputDataType) {
            case DOUBLE: {
                this.evaluator.evaluateDouble(row, collector);
                break;
            }
            case TEXT: {
                this.evaluator.evaluateText(row, collector);
                break;
            }
            case BOOLEAN: {
                this.evaluator.evaluateBoolean(row, collector);
                break;
            }
            default: {
                throw new UDFOutputSeriesDataTypeNotValidException(0, "[Number, String, Boolean]");
            }
        }
    }

    private class EvaluatorMulInput
    implements Evaluator {
        Object[] values;

        private EvaluatorMulInput() {
            this.values = new Object[UDTFJexl.this.inputSeriesNumber];
        }

        @Override
        public void evaluateDouble(Row row, PointCollector collector) throws IOException, UDFInputSeriesDataTypeNotValidException {
            this.getValues(row);
            collector.putDouble(row.getTime(), ((Number)UDTFJexl.this.script.execute(null, this.values)).doubleValue());
        }

        @Override
        public void evaluateText(Row row, PointCollector collector) throws IOException, UDFInputSeriesDataTypeNotValidException {
            this.getValues(row);
            collector.putString(row.getTime(), (String)UDTFJexl.this.script.execute(null, this.values));
        }

        @Override
        public void evaluateBoolean(Row row, PointCollector collector) throws IOException, UDFInputSeriesDataTypeNotValidException {
            this.getValues(row);
            collector.putBoolean(row.getTime(), (Boolean)UDTFJexl.this.script.execute(null, this.values));
        }

        public void getValues(Row row) throws IOException, UDFInputSeriesDataTypeNotValidException {
            block8: for (int i = 0; i < UDTFJexl.this.inputSeriesNumber; ++i) {
                switch (UDTFJexl.this.inputDataType[i]) {
                    case INT32: {
                        this.values[i] = row.getInt(i);
                        continue block8;
                    }
                    case INT64: {
                        this.values[i] = row.getLong(i);
                        continue block8;
                    }
                    case FLOAT: {
                        this.values[i] = Float.valueOf(row.getFloat(i));
                        continue block8;
                    }
                    case DOUBLE: {
                        this.values[i] = row.getDouble(i);
                        continue block8;
                    }
                    case TEXT: {
                        this.values[i] = row.getString(i);
                        continue block8;
                    }
                    case BOOLEAN: {
                        this.values[i] = row.getBoolean(i);
                        continue block8;
                    }
                    default: {
                        throw new UDFInputSeriesDataTypeNotValidException(i, UDFDataTypeTransformer.transformToUDFDataType(UDTFJexl.this.inputDataType[i]), Type.INT32, Type.INT64, Type.FLOAT, Type.DOUBLE, Type.TEXT, Type.BOOLEAN);
                    }
                }
            }
        }
    }

    private class EvaluatorBooleanInput
    implements Evaluator {
        private EvaluatorBooleanInput() {
        }

        @Override
        public void evaluateDouble(Row row, PointCollector collector) throws IOException {
            collector.putDouble(row.getTime(), ((Number)UDTFJexl.this.script.execute(null, row.getBoolean(0))).doubleValue());
        }

        @Override
        public void evaluateText(Row row, PointCollector collector) throws IOException {
            collector.putString(row.getTime(), (String)UDTFJexl.this.script.execute(null, row.getBoolean(0)));
        }

        @Override
        public void evaluateBoolean(Row row, PointCollector collector) throws IOException {
            collector.putBoolean(row.getTime(), (Boolean)UDTFJexl.this.script.execute(null, row.getBoolean(0)));
        }
    }

    private class EvaluatorStringInput
    implements Evaluator {
        private EvaluatorStringInput() {
        }

        @Override
        public void evaluateDouble(Row row, PointCollector collector) throws IOException {
            collector.putDouble(row.getTime(), ((Number)UDTFJexl.this.script.execute(null, row.getString(0))).doubleValue());
        }

        @Override
        public void evaluateText(Row row, PointCollector collector) throws IOException {
            collector.putString(row.getTime(), (String)UDTFJexl.this.script.execute(null, row.getString(0)));
        }

        @Override
        public void evaluateBoolean(Row row, PointCollector collector) throws IOException {
            collector.putBoolean(row.getTime(), (Boolean)UDTFJexl.this.script.execute(null, row.getString(0)));
        }
    }

    private class EvaluatorDoubleInput
    implements Evaluator {
        private EvaluatorDoubleInput() {
        }

        @Override
        public void evaluateDouble(Row row, PointCollector collector) throws IOException {
            collector.putDouble(row.getTime(), ((Number)UDTFJexl.this.script.execute(null, row.getDouble(0))).doubleValue());
        }

        @Override
        public void evaluateText(Row row, PointCollector collector) throws IOException {
            collector.putString(row.getTime(), (String)UDTFJexl.this.script.execute(null, row.getDouble(0)));
        }

        @Override
        public void evaluateBoolean(Row row, PointCollector collector) throws IOException {
            collector.putBoolean(row.getTime(), (Boolean)UDTFJexl.this.script.execute(null, row.getDouble(0)));
        }
    }

    private class EvaluatorFloatInput
    implements Evaluator {
        private EvaluatorFloatInput() {
        }

        @Override
        public void evaluateDouble(Row row, PointCollector collector) throws IOException {
            collector.putDouble(row.getTime(), ((Number)UDTFJexl.this.script.execute(null, Float.valueOf(row.getFloat(0)))).doubleValue());
        }

        @Override
        public void evaluateText(Row row, PointCollector collector) throws IOException {
            collector.putString(row.getTime(), (String)UDTFJexl.this.script.execute(null, Float.valueOf(row.getFloat(0))));
        }

        @Override
        public void evaluateBoolean(Row row, PointCollector collector) throws IOException {
            collector.putBoolean(row.getTime(), (Boolean)UDTFJexl.this.script.execute(null, Float.valueOf(row.getFloat(0))));
        }
    }

    private class EvaluatorLongInput
    implements Evaluator {
        private EvaluatorLongInput() {
        }

        @Override
        public void evaluateDouble(Row row, PointCollector collector) throws IOException {
            collector.putDouble(row.getTime(), ((Number)UDTFJexl.this.script.execute(null, row.getLong(0))).doubleValue());
        }

        @Override
        public void evaluateText(Row row, PointCollector collector) throws IOException {
            collector.putString(row.getTime(), (String)UDTFJexl.this.script.execute(null, row.getLong(0)));
        }

        @Override
        public void evaluateBoolean(Row row, PointCollector collector) throws IOException {
            collector.putBoolean(row.getTime(), (Boolean)UDTFJexl.this.script.execute(null, row.getLong(0)));
        }
    }

    private class EvaluatorIntInput
    implements Evaluator {
        private EvaluatorIntInput() {
        }

        @Override
        public void evaluateDouble(Row row, PointCollector collector) throws IOException {
            collector.putDouble(row.getTime(), ((Number)UDTFJexl.this.script.execute(null, row.getInt(0))).doubleValue());
        }

        @Override
        public void evaluateText(Row row, PointCollector collector) throws IOException {
            collector.putString(row.getTime(), (String)UDTFJexl.this.script.execute(null, row.getInt(0)));
        }

        @Override
        public void evaluateBoolean(Row row, PointCollector collector) throws IOException {
            collector.putBoolean(row.getTime(), (Boolean)UDTFJexl.this.script.execute(null, row.getInt(0)));
        }
    }

    private static interface Evaluator {
        public void evaluateDouble(Row var1, PointCollector var2) throws IOException, UDFInputSeriesDataTypeNotValidException;

        public void evaluateText(Row var1, PointCollector var2) throws IOException, UDFInputSeriesDataTypeNotValidException;

        public void evaluateBoolean(Row var1, PointCollector var2) throws IOException, UDFInputSeriesDataTypeNotValidException;
    }
}

