/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.udf.builtin;

import java.io.IOException;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.udf.builtin.UDTFMath;
import org.apache.iotdb.commons.udf.utils.UDFDataTypeTransformer;
import org.apache.iotdb.tsfile.read.common.block.column.Column;
import org.apache.iotdb.tsfile.read.common.block.column.ColumnBuilder;
import org.apache.iotdb.udf.api.access.Row;
import org.apache.iotdb.udf.api.collector.PointCollector;
import org.apache.iotdb.udf.api.customizer.config.UDTFConfigurations;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameters;
import org.apache.iotdb.udf.api.customizer.strategy.MappableRowByRowAccessStrategy;
import org.apache.iotdb.udf.api.exception.UDFInputSeriesDataTypeNotValidException;
import org.apache.iotdb.udf.api.type.Type;

public class UDTFAbs
extends UDTFMath {
    @Override
    public void beforeStart(UDFParameters parameters, UDTFConfigurations configurations) throws MetadataException {
        this.dataType = UDFDataTypeTransformer.transformToTsDataType(parameters.getDataType(0));
        configurations.setAccessStrategy(new MappableRowByRowAccessStrategy()).setOutputDataType(UDFDataTypeTransformer.transformToUDFDataType(this.dataType));
    }

    @Override
    public void transform(Row row, PointCollector collector) throws UDFInputSeriesDataTypeNotValidException, IOException {
        long time = row.getTime();
        switch (this.dataType) {
            case INT32: {
                collector.putInt(time, Math.abs(row.getInt(0)));
                break;
            }
            case INT64: {
                collector.putLong(time, Math.abs(row.getLong(0)));
                break;
            }
            case FLOAT: {
                collector.putFloat(time, Math.abs(row.getFloat(0)));
                break;
            }
            case DOUBLE: {
                collector.putDouble(time, Math.abs(row.getDouble(0)));
                break;
            }
            default: {
                throw new UDFInputSeriesDataTypeNotValidException(0, UDFDataTypeTransformer.transformToUDFDataType(this.dataType), Type.INT32, Type.INT64, Type.FLOAT, Type.DOUBLE);
            }
        }
    }

    @Override
    public Object transform(Row row) throws IOException {
        if (row.isNull(0)) {
            return null;
        }
        switch (this.dataType) {
            case INT32: {
                return Math.abs(row.getInt(0));
            }
            case INT64: {
                return Math.abs(row.getLong(0));
            }
            case FLOAT: {
                return Float.valueOf(Math.abs(row.getFloat(0)));
            }
            case DOUBLE: {
                return Math.abs(row.getDouble(0));
            }
        }
        throw new UDFInputSeriesDataTypeNotValidException(0, UDFDataTypeTransformer.transformToUDFDataType(this.dataType), Type.INT32, Type.INT64, Type.FLOAT, Type.DOUBLE);
    }

    @Override
    public void transform(Column[] columns, ColumnBuilder builder) throws Exception {
        switch (this.dataType) {
            case INT32: {
                this.transformInt(columns, builder);
                return;
            }
            case INT64: {
                this.transformLong(columns, builder);
                return;
            }
            case FLOAT: {
                this.transformFloat(columns, builder);
                return;
            }
            case DOUBLE: {
                this.transformDouble(columns, builder);
                return;
            }
        }
        throw new UDFInputSeriesDataTypeNotValidException(0, UDFDataTypeTransformer.transformToUDFDataType(this.dataType), Type.INT32, Type.INT64, Type.FLOAT, Type.DOUBLE);
    }

    @Override
    protected void setTransformer() {
        throw new UnsupportedOperationException("UDTFAbs#setTransformer()");
    }

    protected void transformInt(Column[] columns, ColumnBuilder builder) {
        int[] inputs = columns[0].getInts();
        boolean[] isNulls = columns[0].isNull();
        int count = columns[0].getPositionCount();
        for (int i = 0; i < count; ++i) {
            if (isNulls[i]) {
                builder.appendNull();
                continue;
            }
            builder.writeInt(Math.abs(inputs[i]));
        }
    }

    protected void transformLong(Column[] columns, ColumnBuilder builder) {
        long[] inputs = columns[0].getLongs();
        boolean[] isNulls = columns[0].isNull();
        int count = columns[0].getPositionCount();
        for (int i = 0; i < count; ++i) {
            if (isNulls[i]) {
                builder.appendNull();
                continue;
            }
            builder.writeLong(Math.abs(inputs[i]));
        }
    }

    protected void transformFloat(Column[] columns, ColumnBuilder builder) {
        float[] inputs = columns[0].getFloats();
        boolean[] isNulls = columns[0].isNull();
        int count = columns[0].getPositionCount();
        for (int i = 0; i < count; ++i) {
            if (isNulls[i]) {
                builder.appendNull();
                continue;
            }
            builder.writeFloat(Math.abs(inputs[i]));
        }
    }

    protected void transformDouble(Column[] columns, ColumnBuilder builder) {
        double[] inputs = columns[0].getDoubles();
        boolean[] isNulls = columns[0].isNull();
        int count = columns[0].getPositionCount();
        for (int i = 0; i < count; ++i) {
            if (isNulls[i]) {
                builder.appendNull();
                continue;
            }
            builder.writeDouble(Math.abs(inputs[i]));
        }
    }
}

