/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.schema.view.viewExpression.unary;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.regex.Pattern;
import org.apache.iotdb.commons.schema.view.viewExpression.ViewExpression;
import org.apache.iotdb.commons.schema.view.viewExpression.ViewExpressionType;
import org.apache.iotdb.commons.schema.view.viewExpression.unary.UnaryViewExpression;
import org.apache.iotdb.commons.schema.view.viewExpression.visitor.ViewExpressionVisitor;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class LikeViewExpression
extends UnaryViewExpression {
    private final String patternString;
    private final Pattern pattern;
    private final boolean isNot;

    public LikeViewExpression(ViewExpression expression, String patternString, boolean isNot) {
        super(expression);
        this.patternString = patternString;
        this.isNot = isNot;
        this.pattern = this.compile();
    }

    public LikeViewExpression(ViewExpression expression, String patternString, Pattern pattern, boolean isNot) {
        super(expression);
        this.patternString = patternString;
        this.pattern = pattern;
        this.isNot = isNot;
    }

    public LikeViewExpression(ByteBuffer byteBuffer) {
        super(ViewExpression.deserialize(byteBuffer));
        this.patternString = ReadWriteIOUtils.readString(byteBuffer);
        this.isNot = ReadWriteIOUtils.readBool(byteBuffer);
        this.pattern = this.compile();
    }

    public LikeViewExpression(InputStream inputStream) {
        super(ViewExpression.deserialize(inputStream));
        try {
            this.patternString = ReadWriteIOUtils.readString(inputStream);
            this.isNot = ReadWriteIOUtils.readBool(inputStream);
            this.pattern = this.compile();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <R, C> R accept(ViewExpressionVisitor<R, C> visitor, C context) {
        return visitor.visitLikeExpression(this, context);
    }

    @Override
    public ViewExpressionType getExpressionType() {
        return ViewExpressionType.LIKE;
    }

    @Override
    public String toString(boolean isRoot) {
        String basicString = this.expression.toString(false) + (this.isNot ? "NOT LIKE " : "LIKE ") + this.patternString;
        if (isRoot) {
            return basicString;
        }
        return "( " + basicString + " )";
    }

    @Override
    protected void serialize(ByteBuffer byteBuffer) {
        super.serialize(byteBuffer);
        ReadWriteIOUtils.write(this.patternString, byteBuffer);
        ReadWriteIOUtils.write((Boolean)this.isNot, byteBuffer);
    }

    @Override
    protected void serialize(OutputStream stream) throws IOException {
        super.serialize(stream);
        ReadWriteIOUtils.write(this.patternString, stream);
        ReadWriteIOUtils.write((Boolean)this.isNot, stream);
    }

    public String getPatternString() {
        return this.patternString;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public boolean isNot() {
        return this.isNot;
    }

    private String unescapeString(String value) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < value.length(); ++i) {
            String ch = String.valueOf(value.charAt(i));
            if ("\\".equals(ch)) {
                if (i >= value.length() - 1) continue;
                String nextChar = String.valueOf(value.charAt(i + 1));
                if ("%".equals(nextChar) || "_".equals(nextChar) || "\\".equals(nextChar)) {
                    stringBuilder.append(ch);
                }
                if (!"\\".equals(nextChar)) continue;
                ++i;
                continue;
            }
            stringBuilder.append(ch);
        }
        return stringBuilder.toString();
    }

    private Pattern compile() {
        String unescapeValue = this.unescapeString(this.patternString);
        String specialRegexString = ".^$*+?{}[]|()";
        StringBuilder patternBuilder = new StringBuilder();
        patternBuilder.append("^");
        for (int i = 0; i < unescapeValue.length(); ++i) {
            String ch = String.valueOf(unescapeValue.charAt(i));
            if (specialRegexString.contains(ch)) {
                ch = "\\" + unescapeValue.charAt(i);
            }
            if (i == 0 || !"\\".equals(String.valueOf(unescapeValue.charAt(i - 1))) || i >= 2 && "\\\\".equals(patternBuilder.substring(patternBuilder.length() - 2, patternBuilder.length()))) {
                patternBuilder.append(ch.replace("%", ".*?").replace("_", "."));
                continue;
            }
            patternBuilder.append(ch);
        }
        patternBuilder.append("$");
        return Pattern.compile(patternBuilder.toString());
    }
}

