/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.schema.view.viewExpression.leaf;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.commons.lang3.Validate;
import org.apache.iotdb.commons.schema.view.viewExpression.ViewExpressionType;
import org.apache.iotdb.commons.schema.view.viewExpression.leaf.LeafViewOperand;
import org.apache.iotdb.commons.schema.view.viewExpression.visitor.ViewExpressionVisitor;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class ConstantViewOperand
extends LeafViewOperand {
    private final String valueString;
    private final TSDataType dataType;

    public ConstantViewOperand(TSDataType dataType, String valueString) {
        this.dataType = Validate.notNull(dataType);
        this.valueString = Validate.notNull(valueString);
    }

    public ConstantViewOperand(ByteBuffer byteBuffer) {
        this.dataType = TSDataType.deserializeFrom(byteBuffer);
        this.valueString = ReadWriteIOUtils.readString(byteBuffer);
    }

    public ConstantViewOperand(InputStream inputStream) {
        try {
            this.dataType = TSDataType.deserialize(ReadWriteIOUtils.readByte(inputStream));
            this.valueString = ReadWriteIOUtils.readString(inputStream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <R, C> R accept(ViewExpressionVisitor<R, C> visitor, C context) {
        return visitor.visitConstantOperand(this, context);
    }

    @Override
    public ViewExpressionType getExpressionType() {
        return ViewExpressionType.CONSTANT;
    }

    @Override
    public String toString(boolean isRoot) {
        return this.valueString;
    }

    @Override
    protected void serialize(ByteBuffer byteBuffer) {
        this.dataType.serializeTo(byteBuffer);
        ReadWriteIOUtils.write(this.valueString, byteBuffer);
    }

    @Override
    protected void serialize(OutputStream stream) throws IOException {
        stream.write(this.dataType.serialize());
        ReadWriteIOUtils.write(this.valueString, stream);
    }

    public TSDataType getDataType() {
        return this.dataType;
    }

    public String getValueString() {
        return this.valueString;
    }
}

