/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.path.fa;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import org.apache.iotdb.commons.path.fa.IPatternFA;
import org.apache.iotdb.commons.path.fa.dfa.PatternDFA;
import org.apache.iotdb.commons.path.fa.nfa.SimpleNFA;
import org.apache.iotdb.commons.schema.SchemaConstant;

public class FAFactory {
    private final LoadingCache<IPatternFA.Builder, PatternDFA> dfaCache = Caffeine.newBuilder().maximumSize(20L).build(builder -> {
        if (builder.getPatternTree() != null) {
            if (builder.getPatternTree().equals(SchemaConstant.ALL_MATCH_SCOPE)) {
                return SchemaConstant.ALL_MATCH_DFA;
            }
            return new PatternDFA(builder.getPatternTree());
        }
        return new PatternDFA(builder.getPathPattern(), builder.isPrefixMatch());
    });
    private static final int DFA_CACHE_SIZE = 20;

    public IPatternFA constructDFA(IPatternFA.Builder builder) {
        return this.dfaCache.get(builder);
    }

    public IPatternFA constructNFA(IPatternFA.Builder builder) {
        return new SimpleNFA(builder.getPathPattern(), builder.isPrefixMatch());
    }

    private FAFactory() {
    }

    public static FAFactory getInstance() {
        return FAFactoryHolder.INSTANCE;
    }

    private static class FAFactoryHolder {
        private static final FAFactory INSTANCE = new FAFactory();

        private FAFactoryHolder() {
        }
    }
}

