/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.consensus.ratis.metrics;

import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupType;
import org.apache.iotdb.commons.service.metric.MetricService;
import org.apache.iotdb.commons.service.metric.enums.Metric;
import org.apache.iotdb.commons.service.metric.enums.Tag;
import org.apache.iotdb.metrics.utils.MetricLevel;

public class RatisMetricsManager {
    private final MetricService metricService = MetricService.getInstance();

    public TimeReporter startWriteLocallyTimer(TConsensusGroupType consensusGroupType) {
        return new TimeReporter(this::recordWriteLocallyCost, consensusGroupType);
    }

    public TimeReporter startWriteRemotelyTimer(TConsensusGroupType consensusGroupType) {
        return new TimeReporter(this::recordWriteRemotelyCost, consensusGroupType);
    }

    public TimeReporter startReadTimer(TConsensusGroupType consensusGroupType) {
        return new TimeReporter(this::recordReadRequestCost, consensusGroupType);
    }

    private void recordWriteLocallyCost(long costTimeInNanos, TConsensusGroupType consensusGroupType) {
        this.metricService.timer(costTimeInNanos, TimeUnit.NANOSECONDS, consensusGroupType.toString() + "_" + Metric.RATIS_CONSENSUS_WRITE, MetricLevel.IMPORTANT, new String[]{Tag.STAGE.toString(), "writeLocally"});
    }

    private void recordWriteRemotelyCost(long costTimeInNanos, TConsensusGroupType consensusGroupType) {
        this.metricService.timer(costTimeInNanos, TimeUnit.NANOSECONDS, consensusGroupType.toString() + "_" + Metric.RATIS_CONSENSUS_WRITE, MetricLevel.IMPORTANT, new String[]{Tag.STAGE.toString(), "writeRemotely"});
    }

    private void recordReadRequestCost(long costTimeInNanos, TConsensusGroupType consensusGroupType) {
        this.metricService.timer(costTimeInNanos, TimeUnit.NANOSECONDS, consensusGroupType.toString() + "_" + Metric.RATIS_CONSENSUS_READ, MetricLevel.IMPORTANT, new String[]{Tag.STAGE.toString(), "submitReadRequest"});
    }

    public void recordWriteStateMachineCost(long costTimeInNanos, TConsensusGroupType consensusGroupType) {
        this.metricService.timer(costTimeInNanos, TimeUnit.NANOSECONDS, consensusGroupType.toString() + "_" + Metric.RATIS_CONSENSUS_WRITE, MetricLevel.IMPORTANT, new String[]{Tag.STAGE.toString(), "writeStateMachine"});
    }

    private RatisMetricsManager() {
    }

    public static RatisMetricsManager getInstance() {
        return RatisMetricsManagerHolder.INSTANCE;
    }

    private static class RatisMetricsManagerHolder {
        private static final RatisMetricsManager INSTANCE = new RatisMetricsManager();

        private RatisMetricsManagerHolder() {
        }
    }

    public static class TimeReporter
    implements AutoCloseable {
        private final long startMoment;
        private final TConsensusGroupType groupType;
        private final BiConsumer<Long, TConsensusGroupType> reporter;

        private TimeReporter(BiConsumer<Long, TConsensusGroupType> reporter, TConsensusGroupType groupType) {
            this.reporter = reporter;
            this.groupType = groupType;
            this.startMoment = System.nanoTime();
        }

        void stopAndReport() {
            long timeElapsed = System.nanoTime() - this.startMoment;
            this.reporter.accept(timeElapsed, this.groupType);
        }

        @Override
        public void close() throws Exception {
            this.stopAndReport();
        }
    }
}

