/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.pipe.connector.client;

import org.apache.iotdb.commons.client.ThriftClient;
import org.apache.iotdb.commons.client.property.ThriftClientProperty;
import org.apache.iotdb.rpc.RpcTransportFactory;
import org.apache.iotdb.rpc.TimeoutChangeableTransport;
import org.apache.iotdb.service.rpc.thrift.IClientRPCService;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;

public class IoTDBThriftSyncConnectorClient
extends IClientRPCService.Client
implements ThriftClient,
AutoCloseable {
    public IoTDBThriftSyncConnectorClient(ThriftClientProperty property, String ipAddress, int port, boolean useSSL, String trustStore, String trustStorePwd) throws TTransportException {
        super(property.getProtocolFactory().getProtocol(useSSL ? RpcTransportFactory.INSTANCE.getTransport(ipAddress, port, property.getConnectionTimeoutMs(), trustStore, trustStorePwd) : RpcTransportFactory.INSTANCE.getTransport(ipAddress, port, property.getConnectionTimeoutMs())));
        TTransport transport = this.getInputProtocol().getTransport();
        if (!transport.isOpen()) {
            transport.open();
        }
    }

    public void setTimeout(int timeout) {
        ((TimeoutChangeableTransport)this.getInputProtocol().getTransport()).setTimeout(timeout);
    }

    @Override
    public void close() throws Exception {
        this.invalidate();
    }

    @Override
    public void invalidate() {
        if (this.getInputProtocol().getTransport().isOpen()) {
            this.getInputProtocol().getTransport().close();
        }
    }

    @Override
    public void invalidateAll() {
        this.invalidate();
    }

    @Override
    public boolean printLogWhenEncounterException() {
        return true;
    }
}

