/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.client.property;

import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.apache.commons.pool2.impl.GenericKeyedObjectPoolConfig;

public class ClientPoolProperty<V> {
    private final GenericKeyedObjectPoolConfig<V> config;

    private ClientPoolProperty(GenericKeyedObjectPoolConfig<V> config) {
        this.config = config;
    }

    public GenericKeyedObjectPoolConfig<V> getConfig() {
        return this.config;
    }

    public static class DefaultProperty {
        public static final long WAIT_CLIENT_TIMEOUT_MS = TimeUnit.SECONDS.toMillis(10L);
        public static final long MIN_IDLE_TIME_FOR_CLIENT_MS = TimeUnit.MINUTES.toMillis(1L);
        public static final long TIME_BETWEEN_EVICTION_RUNS_MS = TimeUnit.MINUTES.toMillis(1L);
        public static final int MAX_CLIENT_NUM_FOR_EACH_NODE = 300;

        private DefaultProperty() {
        }
    }

    public static class Builder<V> {
        private long waitClientTimeoutMs = DefaultProperty.WAIT_CLIENT_TIMEOUT_MS;
        private int maxClientNumForEachNode = 300;
        private long minIdleTimeForClient = DefaultProperty.MIN_IDLE_TIME_FOR_CLIENT_MS;
        private long timeBetweenEvictionRuns = DefaultProperty.TIME_BETWEEN_EVICTION_RUNS_MS;

        public Builder<V> setWaitClientTimeoutMs(long waitClientTimeoutMs) {
            this.waitClientTimeoutMs = waitClientTimeoutMs;
            return this;
        }

        public Builder<V> setMaxClientNumForEachNode(int maxClientNumForEachNode) {
            this.maxClientNumForEachNode = maxClientNumForEachNode;
            return this;
        }

        public Builder<V> setMinIdleTimeForClient(long minIdleTimeForClient) {
            this.minIdleTimeForClient = minIdleTimeForClient;
            return this;
        }

        public Builder<V> setTimeBetweenEvictionRuns(long timeBetweenEvictionRuns) {
            this.timeBetweenEvictionRuns = timeBetweenEvictionRuns;
            return this;
        }

        public ClientPoolProperty<V> build() {
            GenericKeyedObjectPoolConfig poolConfig = new GenericKeyedObjectPoolConfig();
            poolConfig.setMaxTotalPerKey(this.maxClientNumForEachNode);
            poolConfig.setMaxIdlePerKey(this.maxClientNumForEachNode);
            poolConfig.setTimeBetweenEvictionRuns(Duration.ofMillis(this.timeBetweenEvictionRuns));
            poolConfig.setMinEvictableIdleTime(Duration.ofMillis(this.minIdleTimeForClient));
            poolConfig.setMaxWait(Duration.ofMillis(this.waitClientTimeoutMs));
            poolConfig.setTestOnReturn(true);
            poolConfig.setTestOnBorrow(true);
            return new ClientPoolProperty(poolConfig);
        }
    }
}

