/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.read;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.iotdb.tsfile.exception.TsFileSequenceReaderTimeseriesMetadataIteratorException;
import org.apache.iotdb.tsfile.file.metadata.MetadataIndexEntry;
import org.apache.iotdb.tsfile.file.metadata.MetadataIndexNode;
import org.apache.iotdb.tsfile.file.metadata.TimeseriesMetadata;
import org.apache.iotdb.tsfile.file.metadata.enums.MetadataIndexNodeType;
import org.apache.iotdb.tsfile.read.TsFileSequenceReader;

public class TsFileSequenceReaderTimeseriesMetadataIterator
implements Iterator<Map<String, List<TimeseriesMetadata>>> {
    private static final int DEFAULT_TIMESERIES_BATCH_READ_NUMBER = 4000;
    private final TsFileSequenceReader reader;
    private final boolean needChunkMetadata;
    private final int timeseriesBatchReadNumber;
    private ByteBuffer currentBuffer = null;
    private long currentEndOffset = Long.MIN_VALUE;
    private final Deque<MetadataIndexEntryInfo> metadataIndexEntryStack = new ArrayDeque<MetadataIndexEntryInfo>();
    private String currentDeviceId;
    private int currentTimeseriesMetadataCount = 0;

    public TsFileSequenceReaderTimeseriesMetadataIterator(TsFileSequenceReader reader, boolean needChunkMetadata, int timeseriesBatchReadNumber) throws IOException {
        this.reader = reader;
        this.needChunkMetadata = needChunkMetadata;
        this.timeseriesBatchReadNumber = timeseriesBatchReadNumber;
        if (this.reader.tsFileMetaData == null) {
            this.reader.readFileMetadata();
        }
        MetadataIndexNode metadataIndexNode = reader.tsFileMetaData.getMetadataIndex();
        long curEntryEndOffset = metadataIndexNode.getEndOffset();
        List<MetadataIndexEntry> metadataIndexEntryList = metadataIndexNode.getChildren();
        for (int i = metadataIndexEntryList.size() - 1; i >= 0; --i) {
            this.metadataIndexEntryStack.push(new MetadataIndexEntryInfo(metadataIndexEntryList.get(i), metadataIndexNode.getNodeType(), curEntryEndOffset));
            curEntryEndOffset = metadataIndexEntryList.get(i).getOffset();
        }
    }

    public TsFileSequenceReaderTimeseriesMetadataIterator(TsFileSequenceReader reader, boolean needChunkMetadata) throws IOException {
        this(reader, needChunkMetadata, 4000);
    }

    @Override
    public boolean hasNext() {
        return !this.metadataIndexEntryStack.isEmpty() || this.currentBuffer != null && this.currentBuffer.hasRemaining();
    }

    @Override
    public Map<String, List<TimeseriesMetadata>> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        HashMap<String, List<TimeseriesMetadata>> timeseriesMetadataMap = new HashMap<String, List<TimeseriesMetadata>>();
        while (this.currentTimeseriesMetadataCount < this.timeseriesBatchReadNumber) {
            if (this.currentBuffer != null && this.currentBuffer.hasRemaining()) {
                timeseriesMetadataMap.computeIfAbsent(this.currentDeviceId, k -> new ArrayList()).addAll(this.deserializeTimeseriesMetadata());
            } else if (this.currentEndOffset > Long.MIN_VALUE) {
                try {
                    timeseriesMetadataMap.computeIfAbsent(this.currentDeviceId, k -> new ArrayList()).addAll(this.deserializeTimeseriesMetadataUsingTsFileInput(this.currentEndOffset));
                }
                catch (IOException e) {
                    throw new TsFileSequenceReaderTimeseriesMetadataIteratorException(String.format("TsFileSequenceReaderTimeseriesMetadataIterator: deserializeTimeseriesMetadataUsingTsFileInput failed, currentEndOffset: %d, " + e.getMessage(), this.currentEndOffset));
                }
            }
            if (this.currentTimeseriesMetadataCount >= this.timeseriesBatchReadNumber || this.metadataIndexEntryStack.isEmpty()) break;
            MetadataIndexEntryInfo indexEntryInfo = this.metadataIndexEntryStack.pop();
            try {
                this.deserializeMetadataIndexEntry(indexEntryInfo, timeseriesMetadataMap);
            }
            catch (IOException e) {
                throw new TsFileSequenceReaderTimeseriesMetadataIteratorException(String.format("TsFileSequenceReaderTimeseriesMetadataIterator: deserializeMetadataIndexEntry failed, MetadataIndexEntryInfo: %s, " + e.getMessage(), indexEntryInfo));
            }
        }
        if (this.currentTimeseriesMetadataCount >= this.timeseriesBatchReadNumber) {
            this.currentTimeseriesMetadataCount = 0;
        }
        return timeseriesMetadataMap;
    }

    private void deserializeMetadataIndexEntry(MetadataIndexEntryInfo metadataIndexEntryInfo, Map<String, List<TimeseriesMetadata>> timeseriesMetadataMap) throws IOException {
        if (metadataIndexEntryInfo.getMetadataIndexNodeType().equals((Object)MetadataIndexNodeType.LEAF_MEASUREMENT)) {
            this.deserializeLeafMeasurement(metadataIndexEntryInfo.getMetadataIndexEntry(), metadataIndexEntryInfo.getEndOffset(), timeseriesMetadataMap);
        } else {
            this.deserializeInternalNode(metadataIndexEntryInfo.getMetadataIndexEntry(), metadataIndexEntryInfo.getEndOffset(), metadataIndexEntryInfo.getMetadataIndexNodeType().equals((Object)MetadataIndexNodeType.LEAF_DEVICE));
        }
    }

    private void deserializeLeafMeasurement(MetadataIndexEntry metadataIndexEntry, long endOffset, Map<String, List<TimeseriesMetadata>> timeseriesMetadataMap) throws IOException {
        if (this.currentBuffer != null && this.currentBuffer.hasRemaining()) {
            throw new TsFileSequenceReaderTimeseriesMetadataIteratorException("currentBuffer still has some data left before deserializeLeafMeasurement");
        }
        if (endOffset - metadataIndexEntry.getOffset() < Integer.MAX_VALUE) {
            this.currentBuffer = this.reader.readData(metadataIndexEntry.getOffset(), endOffset);
            timeseriesMetadataMap.computeIfAbsent(this.currentDeviceId, k -> new ArrayList()).addAll(this.deserializeTimeseriesMetadata());
        } else {
            this.currentEndOffset = endOffset;
            this.reader.position(metadataIndexEntry.getOffset());
            timeseriesMetadataMap.computeIfAbsent(this.currentDeviceId, k -> new ArrayList()).addAll(this.deserializeTimeseriesMetadataUsingTsFileInput(endOffset));
        }
    }

    private List<TimeseriesMetadata> deserializeTimeseriesMetadata() {
        ArrayList<TimeseriesMetadata> timeseriesMetadataList = new ArrayList<TimeseriesMetadata>();
        while (this.currentBuffer.hasRemaining() && this.currentTimeseriesMetadataCount < this.timeseriesBatchReadNumber) {
            timeseriesMetadataList.add(TimeseriesMetadata.deserializeFrom(this.currentBuffer, this.needChunkMetadata));
            ++this.currentTimeseriesMetadataCount;
        }
        return timeseriesMetadataList;
    }

    private List<TimeseriesMetadata> deserializeTimeseriesMetadataUsingTsFileInput(long endOffset) throws IOException {
        ArrayList<TimeseriesMetadata> timeseriesMetadataList = new ArrayList<TimeseriesMetadata>();
        while (this.reader.position() < endOffset && this.currentTimeseriesMetadataCount < 4000) {
            timeseriesMetadataList.add(TimeseriesMetadata.deserializeFrom(this.reader.tsFileInput, this.needChunkMetadata));
            ++this.currentTimeseriesMetadataCount;
        }
        if (this.reader.position() >= endOffset) {
            this.currentEndOffset = Long.MIN_VALUE;
        }
        return timeseriesMetadataList;
    }

    private void deserializeInternalNode(MetadataIndexEntry metadataIndexEntry, long endOffset, boolean isLeafDevice) throws IOException {
        if (isLeafDevice) {
            this.currentDeviceId = metadataIndexEntry.getName();
        }
        MetadataIndexNode metadataIndexNode = MetadataIndexNode.deserializeFrom(this.reader.readData(metadataIndexEntry.getOffset(), endOffset));
        MetadataIndexNodeType metadataIndexNodeType = metadataIndexNode.getNodeType();
        List<MetadataIndexEntry> children = metadataIndexNode.getChildren();
        long curEntryEndOffset = metadataIndexNode.getEndOffset();
        for (int i = children.size() - 1; i >= 0; --i) {
            this.metadataIndexEntryStack.push(new MetadataIndexEntryInfo(children.get(i), metadataIndexNodeType, curEntryEndOffset));
            curEntryEndOffset = children.get(i).getOffset();
        }
    }

    private static class MetadataIndexEntryInfo {
        private final MetadataIndexEntry metadataIndexEntry;
        private final MetadataIndexNodeType metadataIndexNodeType;
        private final long endOffset;

        public MetadataIndexEntryInfo(MetadataIndexEntry metadataIndexEntry, MetadataIndexNodeType metadataIndexNodeType, long endOffset) {
            this.metadataIndexEntry = metadataIndexEntry;
            this.metadataIndexNodeType = metadataIndexNodeType;
            this.endOffset = endOffset;
        }

        public MetadataIndexEntry getMetadataIndexEntry() {
            return this.metadataIndexEntry;
        }

        public MetadataIndexNodeType getMetadataIndexNodeType() {
            return this.metadataIndexNodeType;
        }

        public long getEndOffset() {
            return this.endOffset;
        }
    }
}

