/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils.columngenerator.parameter;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.GroupByTimeParameter;
import org.apache.iotdb.db.utils.columngenerator.ColumnGeneratorType;
import org.apache.iotdb.db.utils.columngenerator.parameter.ColumnGeneratorParameter;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class SlidingTimeColumnGeneratorParameter
extends ColumnGeneratorParameter {
    private final boolean ascending;
    private final GroupByTimeParameter groupByTimeParameter;

    public SlidingTimeColumnGeneratorParameter(GroupByTimeParameter groupByTimeParameter, boolean ascending) {
        super(ColumnGeneratorType.SLIDING_TIME);
        this.groupByTimeParameter = groupByTimeParameter;
        this.ascending = ascending;
    }

    public GroupByTimeParameter getGroupByTimeParameter() {
        return this.groupByTimeParameter;
    }

    public boolean isAscending() {
        return this.ascending;
    }

    @Override
    protected void serializeAttributes(ByteBuffer buffer) {
        this.groupByTimeParameter.serialize(buffer);
        ReadWriteIOUtils.write((Boolean)this.ascending, (ByteBuffer)buffer);
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
        this.groupByTimeParameter.serialize(stream);
        ReadWriteIOUtils.write((Boolean)this.ascending, (OutputStream)stream);
    }

    @Override
    public List<String> getColumnNames() {
        return Collections.singletonList("__endTime");
    }

    @Override
    public List<TSDataType> getColumnTypes() {
        return Collections.singletonList(TSDataType.INT64);
    }

    public static SlidingTimeColumnGeneratorParameter deserialize(ByteBuffer byteBuffer) {
        GroupByTimeParameter groupByTimeParameter = GroupByTimeParameter.deserialize(byteBuffer);
        boolean ascending = ReadWriteIOUtils.readBool((ByteBuffer)byteBuffer);
        return new SlidingTimeColumnGeneratorParameter(groupByTimeParameter, ascending);
    }
}

