/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.tsfile.generator;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.iotdb.db.exception.DiskSpaceInsufficientException;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResourceStatus;
import org.apache.iotdb.db.storageengine.rescon.disk.TierManager;
import org.apache.iotdb.tsfile.fileSystem.FSFactoryProducer;
import org.apache.iotdb.tsfile.fileSystem.fsFactory.FSFactory;

public class TsFileNameGenerator {
    private static FSFactory fsFactory = FSFactoryProducer.getFSFactory();

    public static String generateNewTsFilePath(String tsFileDir, long time, long version, int innerSpaceCompactionCount, int crossSpaceCompactionCount) {
        return tsFileDir + File.separator + TsFileNameGenerator.generateNewTsFileName(time, version, innerSpaceCompactionCount, crossSpaceCompactionCount);
    }

    public static String generateNewTsFilePathWithMkdir(boolean sequence, String logicalStorageGroup, String virtualStorageGroup, long timePartitionId, long time, long version, int innerSpaceCompactionCount, int crossSpaceCompactionCount) throws DiskSpaceInsufficientException {
        String tsFileDir = TsFileNameGenerator.generateTsFileDir(sequence, logicalStorageGroup, virtualStorageGroup, timePartitionId);
        fsFactory.getFile(tsFileDir).mkdirs();
        return tsFileDir + File.separator + TsFileNameGenerator.generateNewTsFileName(time, version, innerSpaceCompactionCount, crossSpaceCompactionCount);
    }

    public static String generateTsFileDir(boolean sequence, String logicalStorageGroup, String virtualStorageGroup, long timePartitionId) throws DiskSpaceInsufficientException {
        TierManager tierManager = TierManager.getInstance();
        String baseDir = tierManager.getNextFolderForTsFile(0, sequence);
        return baseDir + File.separator + logicalStorageGroup + File.separator + virtualStorageGroup + File.separator + timePartitionId;
    }

    public static String generateNewTsFileName(long time, long version, int innerSpaceCompactionCount, int crossSpaceCompactionCount) {
        return time + "-" + version + "-" + innerSpaceCompactionCount + "-" + crossSpaceCompactionCount + ".tsfile";
    }

    public static TsFileName getTsFileName(String fileName) throws IOException {
        Matcher matcher = TsFileName.FILE_NAME_MATCHER.matcher(fileName);
        if (matcher.find()) {
            try {
                TsFileName tsFileName = new TsFileName(Long.parseLong(matcher.group(1)), Long.parseLong(matcher.group(2)), Integer.parseInt(matcher.group(3)), Integer.parseInt(matcher.group(4)));
                return tsFileName;
            }
            catch (NumberFormatException e) {
                throw new IOException("tsfile file name format is incorrect:" + fileName);
            }
        }
        throw new IOException("tsfile file name format is incorrect:" + fileName);
    }

    public static TsFileResource increaseCrossCompactionCnt(TsFileResource tsFileResource) throws IOException {
        File tsFile = tsFileResource.getTsFile();
        String path = tsFile.getParent();
        TsFileName tsFileName = TsFileNameGenerator.getTsFileName(tsFileResource.getTsFile().getName());
        tsFileName.setCrossCompactionCnt(tsFileName.getCrossCompactionCnt() + 1);
        tsFileResource.setFile(new File(path, tsFileName.time + "-" + tsFileName.version + "-" + tsFileName.innerCompactionCnt + "-" + tsFileName.crossCompactionCnt + ".tsfile"));
        return tsFileResource;
    }

    public static TsFileResource increaseInnerCompactionCnt(TsFileResource tsFileResource) throws IOException {
        File tsFile = tsFileResource.getTsFile();
        String path = tsFile.getParent();
        TsFileName tsFileName = TsFileNameGenerator.getTsFileName(tsFileResource.getTsFile().getName());
        tsFileName.setInnerCompactionCnt(tsFileName.getInnerCompactionCnt() + 1);
        tsFileResource.setFile(new File(path, tsFileName.time + "-" + tsFileName.version + "-" + tsFileName.innerCompactionCnt + "-" + tsFileName.crossCompactionCnt + ".tsfile"));
        return tsFileResource;
    }

    public static File increaseCrossCompactionCnt(File tsFile) throws IOException {
        String path = tsFile.getParent();
        TsFileName tsFileName = TsFileNameGenerator.getTsFileName(tsFile.getName());
        tsFileName.setCrossCompactionCnt(tsFileName.getCrossCompactionCnt() + 1);
        return new File(path, tsFileName.time + "-" + tsFileName.version + "-" + tsFileName.innerCompactionCnt + "-" + tsFileName.crossCompactionCnt + ".tsfile");
    }

    public static List<TsFileResource> getCrossCompactionTargetFileResources(List<TsFileResource> seqResources) throws IOException {
        ArrayList<TsFileResource> targetFileResources = new ArrayList<TsFileResource>();
        for (TsFileResource resource : seqResources) {
            TsFileName tsFileName = TsFileNameGenerator.getTsFileName(resource.getTsFile().getName());
            tsFileName.setCrossCompactionCnt(tsFileName.getCrossCompactionCnt() + 1);
            targetFileResources.add(new TsFileResource(new File(resource.getTsFile().getParent(), tsFileName.time + "-" + tsFileName.version + "-" + tsFileName.innerCompactionCnt + "-" + tsFileName.crossCompactionCnt + ".cross"), TsFileResourceStatus.COMPACTING));
        }
        return targetFileResources;
    }

    public static TsFileResource getInnerCompactionTargetFileResource(List<TsFileResource> tsFileResources, boolean sequence) throws IOException {
        long minTime = Long.MAX_VALUE;
        long maxTime = Long.MIN_VALUE;
        long minVersion = Long.MAX_VALUE;
        long maxVersion = Long.MIN_VALUE;
        long maxInnerMergeCount = Long.MIN_VALUE;
        long maxCrossMergeCount = Long.MIN_VALUE;
        for (TsFileResource resource : tsFileResources) {
            TsFileName tsFileName = TsFileNameGenerator.getTsFileName(resource.getTsFile().getName());
            minTime = Math.min(tsFileName.time, minTime);
            maxTime = Math.max(tsFileName.time, maxTime);
            minVersion = Math.min(tsFileName.version, minVersion);
            maxVersion = Math.max(tsFileName.version, maxVersion);
            maxInnerMergeCount = Math.max((long)tsFileName.innerCompactionCnt, maxInnerMergeCount);
            maxCrossMergeCount = Math.max((long)tsFileName.crossCompactionCnt, maxCrossMergeCount);
        }
        TsFileResource resource = sequence ? new TsFileResource(new File(tsFileResources.get(0).getTsFile().getParent(), minTime + "-" + minVersion + "-" + (maxInnerMergeCount + 1L) + "-" + maxCrossMergeCount + ".inner"), TsFileResourceStatus.COMPACTING) : new TsFileResource(new File(tsFileResources.get(0).getTsFile().getParent(), maxTime + "-" + maxVersion + "-" + (maxInnerMergeCount + 1L) + "-" + maxCrossMergeCount + ".inner"), TsFileResourceStatus.COMPACTING);
        resource.setSeq(sequence);
        return resource;
    }

    public static class TsFileName {
        private static final String FILE_NAME_PATTERN = "(\\d+)-(\\d+)-(\\d+)-(\\d+).tsfile$";
        private static final Pattern FILE_NAME_MATCHER = Pattern.compile("(\\d+)-(\\d+)-(\\d+)-(\\d+).tsfile$");
        private long time;
        private long version;
        private int innerCompactionCnt;
        private int crossCompactionCnt;

        public TsFileName(long time, long version, int innerCompactionCnt, int crossCompactionCnt) {
            this.time = time;
            this.version = version;
            this.innerCompactionCnt = innerCompactionCnt;
            this.crossCompactionCnt = crossCompactionCnt;
        }

        public long getTime() {
            return this.time;
        }

        public long getVersion() {
            return this.version;
        }

        public int getInnerCompactionCnt() {
            return this.innerCompactionCnt;
        }

        public int getCrossCompactionCnt() {
            return this.crossCompactionCnt;
        }

        public void setTime(long time) {
            this.time = time;
        }

        public void setVersion(long version) {
            this.version = version;
        }

        public void setInnerCompactionCnt(int innerCompactionCnt) {
            this.innerCompactionCnt = innerCompactionCnt;
        }

        public void setCrossCompactionCnt(int crossCompactionCnt) {
            this.crossCompactionCnt = crossCompactionCnt;
        }
    }
}

