/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.schedule;

import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.iotdb.commons.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.commons.concurrent.ThreadName;
import org.apache.iotdb.commons.exception.StartupException;
import org.apache.iotdb.commons.service.IService;
import org.apache.iotdb.commons.service.ServiceType;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.storageengine.dataregion.DataRegion;
import org.apache.iotdb.db.storageengine.dataregion.compaction.repair.RepairTaskStatus;
import org.apache.iotdb.db.storageengine.dataregion.compaction.repair.RepairTimePartitionScanTask;
import org.apache.iotdb.db.storageengine.dataregion.compaction.schedule.CompactionScheduleTaskWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompactionScheduleTaskManager
implements IService {
    private int workerNum = IoTDBDescriptor.getInstance().getConfig().getCompactionScheduleThreadNum();
    private ExecutorService compactionScheduleTaskThreadPool;
    private static final Logger logger = LoggerFactory.getLogger(CompactionScheduleTaskManager.class);
    private static final CompactionScheduleTaskManager INSTANCE = new CompactionScheduleTaskManager();
    private static final List<DataRegion> dataRegionList = new Vector<DataRegion>();
    private final RepairDataTaskManager REPAIR_TASK_MANAGER_INSTANCE = new RepairDataTaskManager();
    private final Set<Future<Void>> submitCompactionScheduleTaskFutures = ConcurrentHashMap.newKeySet();
    private ReentrantLock lock = new ReentrantLock();
    private volatile boolean init = false;

    public void start() throws StartupException {
        if (this.init) {
            return;
        }
        this.initThreadPool();
        this.startScheduleTasks();
        logger.info("Compaction schedule task manager started.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopCompactionScheduleTasks() {
        this.lock.lock();
        try {
            for (Future<Void> task : this.submitCompactionScheduleTaskFutures) {
                task.cancel(true);
            }
            for (Future<Void> task : this.submitCompactionScheduleTaskFutures) {
                if (task.isDone()) continue;
                try {
                    task.get();
                }
                catch (Exception exception) {}
            }
            this.submitCompactionScheduleTaskFutures.clear();
            this.checkAndMayApplyConfigurationChange();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void checkAndMayApplyConfigurationChange() {
        this.lock.lock();
        try {
            if (this.REPAIR_TASK_MANAGER_INSTANCE.hasRunningRepairTask()) {
                return;
            }
            int workerNumInCurrentConfig = IoTDBDescriptor.getInstance().getConfig().getCompactionScheduleThreadNum();
            if (this.workerNum == workerNumInCurrentConfig) {
                return;
            }
            this.workerNum = workerNumInCurrentConfig;
            this.restartThreadPool();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void startScheduleTasks() {
        this.lock.lock();
        try {
            for (int workerId = 0; workerId < this.workerNum; ++workerId) {
                Future<Void> future = this.compactionScheduleTaskThreadPool.submit(new CompactionScheduleTaskWorker(dataRegionList, workerId, this.workerNum));
                this.submitCompactionScheduleTaskFutures.add(future);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void stop() {
        this.lock.lock();
        try {
            if (!this.init) {
                return;
            }
            this.compactionScheduleTaskThreadPool.shutdownNow();
            logger.info("Waiting for compaction schedule task thread pool to shut down");
            this.waitForThreadPoolTerminated();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitAndStop(long milliseconds) {
        this.lock.lock();
        try {
            if (!this.init) {
                return;
            }
            try {
                this.compactionScheduleTaskThreadPool.shutdownNow();
                if (!this.compactionScheduleTaskThreadPool.awaitTermination(milliseconds, TimeUnit.MILLISECONDS)) {
                    throw new InterruptedException();
                }
            }
            catch (InterruptedException e) {
                logger.warn("compaction schedule task thread pool can not be closed in {} ms", (Object)milliseconds);
                Thread.currentThread().interrupt();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void initThreadPool() {
        this.compactionScheduleTaskThreadPool = IoTDBThreadPoolFactory.newFixedThreadPool((int)this.workerNum, (String)ThreadName.COMPACTION_SCHEDULE.getName());
        this.init = true;
    }

    private void restartThreadPool() {
        this.stopCompactionScheduleTasks();
        this.compactionScheduleTaskThreadPool.shutdownNow();
        this.waitForThreadPoolTerminated();
        this.compactionScheduleTaskThreadPool = IoTDBThreadPoolFactory.newFixedThreadPool((int)this.workerNum, (String)ThreadName.COMPACTION_SCHEDULE.getName());
        this.startScheduleTasks();
    }

    private void waitForThreadPoolTerminated() {
        long startTime = System.currentTimeMillis();
        int timeMillis = 0;
        while (!this.compactionScheduleTaskThreadPool.isTerminated()) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            long time = System.currentTimeMillis() - startTime;
            if ((timeMillis += 200) % 60000 != 0) continue;
            logger.info("CompactionScheduleTaskManager has wait for {} seconds to stop", (Object)(time / 1000L));
        }
        logger.info("CompactionScheduleTaskManager stopped");
    }

    public ServiceType getID() {
        return ServiceType.COMPACTION_SCHEDULE_SERVICE;
    }

    public static CompactionScheduleTaskManager getInstance() {
        return INSTANCE;
    }

    public static RepairDataTaskManager getRepairTaskManagerInstance() {
        return CompactionScheduleTaskManager.INSTANCE.REPAIR_TASK_MANAGER_INSTANCE;
    }

    public void registerDataRegion(DataRegion dataRegion) {
        dataRegionList.add(dataRegion);
    }

    public void unregisterDataRegion(DataRegion dataRegion) {
        dataRegionList.remove(dataRegion);
    }

    public class RepairDataTaskManager {
        private final AtomicReference<RepairTaskStatus> repairTaskStatus = new AtomicReference<RepairTaskStatus>(RepairTaskStatus.STOPPED);
        private final Set<Future<Void>> submitRepairScanTaskFutures = ConcurrentHashMap.newKeySet();

        public boolean markRepairTaskStart() {
            return this.repairTaskStatus.compareAndSet(RepairTaskStatus.STOPPED, RepairTaskStatus.RUNNING);
        }

        public boolean hasRunningRepairTask() {
            return this.repairTaskStatus.get() != RepairTaskStatus.STOPPED;
        }

        public RepairTaskStatus getRepairTaskStatus() {
            return this.repairTaskStatus.get();
        }

        public void markRepairTaskFinish() {
            if (this.repairTaskStatus.compareAndSet(RepairTaskStatus.RUNNING, RepairTaskStatus.STOPPED)) {
                return;
            }
            if (this.repairTaskStatus.compareAndSet(RepairTaskStatus.STOPPING, RepairTaskStatus.STOPPED)) {
                String repairLogDirPath = IoTDBDescriptor.getInstance().getConfig().getSystemDir() + File.separator + "repair";
                File progressFile = new File(repairLogDirPath + File.separator + "repair-data.progress");
                File stoppedFile = new File(repairLogDirPath + File.separator + "repair-data.stopped");
                if (progressFile.exists()) {
                    try {
                        Files.move(progressFile.toPath(), stoppedFile.toPath(), new CopyOption[0]);
                    }
                    catch (IOException e) {
                        logger.error("[RepairTaskManager] Failed to rename repair data progress file");
                    }
                }
            }
        }

        public void markRepairTaskStopping() throws IOException {
            this.repairTaskStatus.compareAndSet(RepairTaskStatus.RUNNING, RepairTaskStatus.STOPPING);
        }

        public void abortRepairTask() {
            if (this.repairTaskStatus.get() == RepairTaskStatus.STOPPED) {
                return;
            }
            for (Future<Void> task : this.submitRepairScanTaskFutures) {
                task.cancel(true);
            }
            for (Future<Void> task : this.submitRepairScanTaskFutures) {
                if (task.isDone()) continue;
                try {
                    task.get();
                }
                catch (Exception exception) {}
            }
            this.submitRepairScanTaskFutures.clear();
            CompactionScheduleTaskManager.this.checkAndMayApplyConfigurationChange();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Future<Void> submitRepairScanTask(RepairTimePartitionScanTask scanTask) {
            CompactionScheduleTaskManager.this.lock.lock();
            try {
                if (this.repairTaskStatus.get() != RepairTaskStatus.RUNNING) {
                    logger.info("[RepairTaskManager] skip current task because repair task is stopping");
                    Future<Void> future = null;
                    return future;
                }
                Future<Void> future = CompactionScheduleTaskManager.this.compactionScheduleTaskThreadPool.submit(scanTask);
                this.submitRepairScanTaskFutures.add(future);
                Future<Void> future2 = future;
                return future2;
            }
            finally {
                CompactionScheduleTaskManager.this.lock.unlock();
            }
        }

        public void waitRepairTaskFinish() {
            for (Future<Void> result : this.submitRepairScanTaskFutures) {
                try {
                    result.get();
                }
                catch (CancellationException cancellationException) {
                    logger.info("[RepairScheduler] scan task is cancelled");
                }
                catch (Exception e) {
                    logger.error("[RepairScheduler] Meet errors when scan time partition files", (Throwable)e);
                }
            }
            this.submitRepairScanTaskFutures.clear();
        }
    }
}

