/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.executor.fast.element;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.executor.fast.element.ChunkMetadataElement;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.executor.fast.element.PageElement;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.executor.fast.reader.CompactionChunkReader;
import org.apache.iotdb.tsfile.file.header.PageHeader;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;

public class NonAlignedPageElement
extends PageElement {
    private final PageHeader pageHeader;
    private final ByteBuffer pageData;
    private final CompactionChunkReader chunkReader;

    public NonAlignedPageElement(PageHeader pageHeader, ByteBuffer pageData, CompactionChunkReader chunkReader, ChunkMetadataElement chunkMetadataElement, boolean isLastPage, long priority) {
        super(chunkMetadataElement, isLastPage, priority);
        this.pageHeader = pageHeader;
        this.pageData = pageData;
        this.chunkReader = chunkReader;
    }

    @Override
    public void deserializePage() throws IOException {
        TsBlock batchData = this.chunkReader.readPageData(this.pageHeader, this.pageData);
        this.pointReader = batchData.getTsBlockSingleColumnIterator();
    }

    @Override
    public long getStartTime() {
        return this.pageHeader.getStartTime();
    }

    @Override
    public long getEndTime() {
        return this.pageHeader.getEndTime();
    }

    public PageHeader getPageHeader() {
        return this.pageHeader;
    }

    public ByteBuffer getPageData() {
        return this.pageData;
    }
}

