/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.transformation.dag.transformer.unary;

import java.io.IOException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.queryengine.transformation.api.LayerPointReader;
import org.apache.iotdb.db.queryengine.transformation.api.YieldableState;
import org.apache.iotdb.db.queryengine.transformation.dag.transformer.Transformer;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;

public abstract class UnaryTransformer
extends Transformer {
    protected final LayerPointReader layerPointReader;
    protected final TSDataType layerPointReaderDataType;
    protected final boolean isLayerPointReaderConstant;

    protected UnaryTransformer(LayerPointReader layerPointReader) {
        this.layerPointReader = layerPointReader;
        this.layerPointReaderDataType = layerPointReader.getDataType();
        this.isLayerPointReaderConstant = layerPointReader.isConstantPointReader();
    }

    @Override
    public final boolean isConstantPointReader() {
        return this.isLayerPointReaderConstant;
    }

    @Override
    public YieldableState yieldValue() throws Exception {
        YieldableState yieldableState = this.layerPointReader.yield();
        if (!YieldableState.YIELDABLE.equals((Object)yieldableState)) {
            return yieldableState;
        }
        if (!this.isLayerPointReaderConstant) {
            this.cachedTime = this.layerPointReader.currentTime();
        }
        if (this.layerPointReader.isCurrentNull()) {
            this.currentNull = true;
        } else {
            this.transformAndCache();
        }
        this.layerPointReader.readyForNext();
        return YieldableState.YIELDABLE;
    }

    @Override
    protected final boolean cacheValue() throws QueryProcessException, IOException {
        if (!this.layerPointReader.next()) {
            return false;
        }
        if (!this.isLayerPointReaderConstant) {
            this.cachedTime = this.layerPointReader.currentTime();
        }
        if (this.layerPointReader.isCurrentNull()) {
            this.currentNull = true;
        } else {
            this.transformAndCache();
        }
        this.layerPointReader.readyForNext();
        return true;
    }

    protected abstract void transformAndCache() throws QueryProcessException, IOException;
}

