/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.planner.plan.node.sink;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.iotdb.db.queryengine.execution.exchange.sink.DownStreamChannelLocation;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.sink.MultiChildrenSinkNode;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class IdentitySinkNode
extends MultiChildrenSinkNode {
    public IdentitySinkNode(PlanNodeId id) {
        super(id);
    }

    public IdentitySinkNode(PlanNodeId id, List<DownStreamChannelLocation> downStreamChannelLocationList) {
        super(id, downStreamChannelLocationList);
    }

    public IdentitySinkNode(PlanNodeId id, List<PlanNode> children, List<DownStreamChannelLocation> downStreamChannelLocationList) {
        super(id, children, downStreamChannelLocationList);
    }

    @Override
    public PlanNode clone() {
        return new IdentitySinkNode(this.getPlanNodeId(), this.getDownStreamChannelLocationList());
    }

    @Override
    public List<String> getOutputColumnNames() {
        return this.children.stream().map(PlanNode::getOutputColumnNames).flatMap(Collection::stream).collect(Collectors.toList());
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitIdentitySink(this, context);
    }

    @Override
    protected void serializeAttributes(ByteBuffer byteBuffer) {
        PlanNodeType.IDENTITY_SINK.serialize(byteBuffer);
        ReadWriteIOUtils.write((int)this.downStreamChannelLocationList.size(), (ByteBuffer)byteBuffer);
        for (DownStreamChannelLocation downStreamChannelLocation : this.downStreamChannelLocationList) {
            downStreamChannelLocation.serialize(byteBuffer);
        }
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
        PlanNodeType.IDENTITY_SINK.serialize(stream);
        ReadWriteIOUtils.write((int)this.downStreamChannelLocationList.size(), (OutputStream)stream);
        for (DownStreamChannelLocation downStreamChannelLocation : this.downStreamChannelLocationList) {
            downStreamChannelLocation.serialize(stream);
        }
    }

    public String toString() {
        return String.format("IdentitySinkNode-%s", this.getPlanNodeId());
    }

    public static IdentitySinkNode deserialize(ByteBuffer byteBuffer) {
        int size = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        ArrayList<DownStreamChannelLocation> downStreamChannelLocationList = new ArrayList<DownStreamChannelLocation>();
        for (int i = 0; i < size; ++i) {
            downStreamChannelLocationList.add(DownStreamChannelLocation.deserialize(byteBuffer));
        }
        PlanNodeId planNodeId = PlanNodeId.deserialize(byteBuffer);
        return new IdentitySinkNode(planNodeId, downStreamChannelLocationList);
    }
}

