/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.expression.visitor;

import java.util.ArrayList;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.queryengine.plan.analyze.Analysis;
import org.apache.iotdb.db.queryengine.plan.expression.Expression;
import org.apache.iotdb.db.queryengine.plan.expression.leaf.TimeSeriesOperand;
import org.apache.iotdb.db.queryengine.plan.expression.multi.FunctionExpression;
import org.apache.iotdb.db.queryengine.plan.expression.visitor.ReconstructVisitor;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;

public class ReplaceSubTreeWithViewVisitor
extends ReconstructVisitor<Analysis> {
    @Override
    public Expression process(Expression expression, Analysis analysis) {
        if (expression.isViewExpression()) {
            TSDataType dataType = analysis.getType(expression);
            return new TimeSeriesOperand((PartialPath)new MeasurementPath(expression.getViewPath(), dataType));
        }
        return expression.accept(this, analysis);
    }

    @Override
    public Expression visitFunctionExpression(FunctionExpression functionExpression, Analysis analysis) {
        ArrayList<Expression> childResult = new ArrayList<Expression>();
        functionExpression.getExpressions().forEach(child -> childResult.add(this.process((Expression)child, analysis)));
        return new FunctionExpression(functionExpression.getFunctionName(), functionExpression.getFunctionAttributes(), childResult, functionExpression.getCountTimeExpressions());
    }

    @Override
    public Expression visitTimeSeriesOperand(TimeSeriesOperand timeSeriesOperand, Analysis analysis) {
        return timeSeriesOperand;
    }
}

