/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.expression.multi.builtin.helper;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.iotdb.db.exception.sql.SemanticException;
import org.apache.iotdb.db.queryengine.plan.expression.multi.FunctionExpression;
import org.apache.iotdb.db.queryengine.plan.expression.multi.builtin.BuiltInScalarFunctionHelper;
import org.apache.iotdb.db.queryengine.transformation.api.LayerPointReader;
import org.apache.iotdb.db.queryengine.transformation.dag.column.ColumnTransformer;
import org.apache.iotdb.db.queryengine.transformation.dag.column.unary.scalar.SubStringFunctionColumnTransformer;
import org.apache.iotdb.db.queryengine.transformation.dag.transformer.Transformer;
import org.apache.iotdb.db.queryengine.transformation.dag.transformer.unary.scalar.SubStringFunctionTransformer;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.type.TypeFactory;

public class SubStringFunctionHelper
implements BuiltInScalarFunctionHelper {
    public static final String BLANK_STRING = " ";
    public static final String COMMA_STRING = ",";
    public static final String NULL_STRING = "null";

    @Override
    public void checkBuiltInScalarFunctionInputSize(FunctionExpression functionExpression) throws SemanticException {
        if (functionExpression.getFunctionAttributes().isEmpty() || functionExpression.getExpressions().size() != 1) {
            throw new SemanticException("Argument exception,the scalar function [SUBSTRING] needs at least one argument,it must be a signed integer");
        }
        if (functionExpression.getExpressionString().contains(NULL_STRING)) {
            throw new SemanticException("Syntax error,please check that the parameters of the function are correct");
        }
    }

    @Override
    public void checkBuiltInScalarFunctionInputDataType(TSDataType tsDataType) throws SemanticException {
        if (tsDataType.getType() == TSDataType.TEXT.getType()) {
            return;
        }
        throw new SemanticException("Input series of Scalar function [SUBSTRING] only supports numeric data types [TEXT]");
    }

    @Override
    public TSDataType getBuiltInScalarFunctionReturnType(FunctionExpression functionExpression) {
        return TSDataType.TEXT;
    }

    @Override
    public ColumnTransformer getBuiltInScalarFunctionColumnTransformer(FunctionExpression expression, ColumnTransformer columnTransformer) {
        LinkedHashMap<String, String> functionAttributes = expression.getFunctionAttributes();
        int subStringLength = Integer.parseInt(functionAttributes.getOrDefault("length", String.valueOf(Integer.MAX_VALUE)));
        int subStringStart = Integer.parseInt(functionAttributes.getOrDefault("startPosition", "0"));
        if (subStringLength < 0 || subStringStart < 0) {
            throw new SemanticException("Argument exception,the scalar function [SUBSTRING] beginPosition and length must be greater than 0");
        }
        return new SubStringFunctionColumnTransformer(TypeFactory.getType((TSDataType)this.getBuiltInScalarFunctionReturnType(expression)), columnTransformer, subStringStart, subStringLength);
    }

    @Override
    public Transformer getBuiltInScalarFunctionTransformer(FunctionExpression expression, LayerPointReader layerPointReader) {
        LinkedHashMap<String, String> functionAttributes = expression.getFunctionAttributes();
        int subStringLength = Integer.parseInt(functionAttributes.getOrDefault("length", String.valueOf(Integer.MAX_VALUE)));
        int subStringStart = Integer.parseInt(functionAttributes.getOrDefault("startPosition", "0"));
        if (subStringLength < 0 || subStringStart < 0) {
            throw new SemanticException("Argument exception,the scalar function [SUBSTRING] beginPosition and length must be greater than 0");
        }
        return new SubStringFunctionTransformer(layerPointReader, subStringStart, subStringLength);
    }

    @Override
    public void appendFunctionAttributes(boolean hasExpression, StringBuilder builder, Map<String, String> functionAttributes) {
        if (functionAttributes.containsKey("isStandard")) {
            builder.append(BLANK_STRING).append("FROM").append(BLANK_STRING).append(functionAttributes.get("startPosition"));
            if (functionAttributes.containsKey("length")) {
                builder.append(BLANK_STRING).append("FOR").append(BLANK_STRING).append(functionAttributes.get("length"));
            }
        } else {
            builder.append(COMMA_STRING).append(functionAttributes.get("startPosition"));
            if (functionAttributes.containsKey("length")) {
                builder.append(COMMA_STRING).append(functionAttributes.get("length"));
            }
        }
    }
}

