/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.analyze;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.iotdb.db.queryengine.plan.expression.Expression;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.InputLocation;
import org.apache.iotdb.db.queryengine.plan.statement.component.Ordering;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.apache.iotdb.tsfile.write.schema.IMeasurementSchema;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;

public class TemplatedInfo {
    private List<String> measurementList;
    private List<IMeasurementSchema> schemaList;
    private List<TSDataType> dataTypes;
    private Set<String> allSensors;
    private Ordering scanOrder;
    private boolean queryAllSensors;
    private List<String> selectMeasurements;
    private List<Integer> deviceToMeasurementIndexes;
    private final long offsetValue;
    private long limitValue;
    private final Expression predicate;
    private ZoneId zoneId;
    private boolean keepNull;
    private Map<String, IMeasurementSchema> schemaMap;
    private Map<String, List<InputLocation>> layoutMap;

    public TemplatedInfo(List<String> measurementList, List<IMeasurementSchema> schemaList, List<TSDataType> dataTypes, Set<String> allSensors, Ordering scanOrder, boolean queryAllSensors, List<String> selectMeasurements, List<Integer> deviceToMeasurementIndexes, long offsetValue, long limitValue, Expression predicate, ZoneId zoneId, Map<String, IMeasurementSchema> schemaMap, Map<String, List<InputLocation>> layoutMap) {
        this.measurementList = measurementList;
        this.schemaList = schemaList;
        this.dataTypes = dataTypes;
        this.allSensors = allSensors;
        this.scanOrder = scanOrder;
        this.queryAllSensors = queryAllSensors;
        this.selectMeasurements = selectMeasurements;
        this.deviceToMeasurementIndexes = deviceToMeasurementIndexes;
        this.offsetValue = offsetValue;
        this.limitValue = limitValue;
        this.predicate = predicate;
        if (predicate != null) {
            this.zoneId = zoneId;
            this.schemaMap = schemaMap;
            this.layoutMap = layoutMap;
        }
    }

    public void setMeasurementList(List<String> measurementList) {
        this.measurementList = measurementList;
    }

    public List<String> getMeasurementList() {
        return this.measurementList;
    }

    public void setSchemaList(List<IMeasurementSchema> schemaList) {
        this.schemaList = schemaList;
    }

    public List<IMeasurementSchema> getSchemaList() {
        return this.schemaList;
    }

    public void setDataTypes(List<TSDataType> dataTypes) {
        this.dataTypes = dataTypes;
    }

    public List<TSDataType> getDataTypes() {
        return this.dataTypes;
    }

    public void setAllSensors(Set<String> allSensors) {
        this.allSensors = allSensors;
    }

    public Set<String> getAllSensors() {
        return this.allSensors;
    }

    public void setScanOrder(Ordering scanOrder) {
        this.scanOrder = scanOrder;
    }

    public Ordering getScanOrder() {
        return this.scanOrder;
    }

    public void setQueryAllSensors(boolean queryAllSensors) {
        this.queryAllSensors = queryAllSensors;
    }

    public boolean isQueryAllSensors() {
        return this.queryAllSensors;
    }

    public void setSelectMeasurements(List<String> selectMeasurements) {
        this.selectMeasurements = selectMeasurements;
    }

    public List<String> getSelectMeasurements() {
        return this.selectMeasurements;
    }

    public void setDeviceToMeasurementIndexes(List<Integer> deviceToMeasurementIndexes) {
        this.deviceToMeasurementIndexes = deviceToMeasurementIndexes;
    }

    public long getOffsetValue() {
        return this.offsetValue;
    }

    public void setLimitValue(long limitValue) {
        this.limitValue = limitValue;
    }

    public long getLimitValue() {
        return this.limitValue;
    }

    public List<Integer> getDeviceToMeasurementIndexes() {
        return this.deviceToMeasurementIndexes;
    }

    public Expression getPredicate() {
        return this.predicate;
    }

    public ZoneId getZoneId() {
        return this.zoneId;
    }

    public boolean isKeepNull() {
        return this.keepNull;
    }

    public Map<String, IMeasurementSchema> getSchemaMap() {
        return this.schemaMap;
    }

    public Map<String, List<InputLocation>> getLayoutMap() {
        return this.layoutMap;
    }

    public static Map<String, List<InputLocation>> makeLayout(List<String> measurementList) {
        LinkedHashMap<String, List<InputLocation>> outputMappings = new LinkedHashMap<String, List<InputLocation>>();
        int tsBlockIndex = 0;
        outputMappings.computeIfAbsent("Time", key -> new ArrayList()).add(new InputLocation(tsBlockIndex, -1));
        int valueColumnIndex = 0;
        for (String columnName : measurementList) {
            outputMappings.computeIfAbsent(columnName, key -> new ArrayList()).add(new InputLocation(tsBlockIndex, valueColumnIndex));
            ++valueColumnIndex;
        }
        return outputMappings;
    }

    public void serialize(ByteBuffer byteBuffer) {
        ReadWriteIOUtils.write((int)this.measurementList.size(), (ByteBuffer)byteBuffer);
        for (String string : this.measurementList) {
            ReadWriteIOUtils.write((String)string, (ByteBuffer)byteBuffer);
        }
        for (IMeasurementSchema iMeasurementSchema : this.schemaList) {
            iMeasurementSchema.serializeTo(byteBuffer);
        }
        for (TSDataType tSDataType : this.dataTypes) {
            ReadWriteIOUtils.write((TSDataType)tSDataType, (ByteBuffer)byteBuffer);
        }
        ReadWriteIOUtils.write((int)this.allSensors.size(), (ByteBuffer)byteBuffer);
        for (String string : this.allSensors) {
            ReadWriteIOUtils.write((String)string, (ByteBuffer)byteBuffer);
        }
        ReadWriteIOUtils.write((int)this.scanOrder.ordinal(), (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write((Boolean)this.queryAllSensors, (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write((int)this.selectMeasurements.size(), (ByteBuffer)byteBuffer);
        for (String string : this.selectMeasurements) {
            ReadWriteIOUtils.write((String)string, (ByteBuffer)byteBuffer);
        }
        ReadWriteIOUtils.write((int)this.deviceToMeasurementIndexes.size(), (ByteBuffer)byteBuffer);
        Iterator<Object> iterator = this.deviceToMeasurementIndexes.iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            ReadWriteIOUtils.write((int)n, (ByteBuffer)byteBuffer);
        }
        ReadWriteIOUtils.write((long)this.offsetValue, (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write((long)this.limitValue, (ByteBuffer)byteBuffer);
        if (this.predicate != null) {
            ReadWriteIOUtils.write((byte)1, (ByteBuffer)byteBuffer);
            Expression.serialize(this.predicate, byteBuffer);
            ReadWriteIOUtils.write((String)this.zoneId.getId(), (ByteBuffer)byteBuffer);
        } else {
            ReadWriteIOUtils.write((byte)0, (ByteBuffer)byteBuffer);
        }
    }

    public void serialize(DataOutputStream stream) throws IOException {
        ReadWriteIOUtils.write((int)this.measurementList.size(), (OutputStream)stream);
        for (String string : this.measurementList) {
            ReadWriteIOUtils.write((String)string, (OutputStream)stream);
        }
        for (IMeasurementSchema iMeasurementSchema : this.schemaList) {
            iMeasurementSchema.serializeTo((OutputStream)stream);
        }
        for (TSDataType tSDataType : this.dataTypes) {
            ReadWriteIOUtils.write((TSDataType)tSDataType, (OutputStream)stream);
        }
        ReadWriteIOUtils.write((int)this.allSensors.size(), (OutputStream)stream);
        for (String string : this.allSensors) {
            ReadWriteIOUtils.write((String)string, (OutputStream)stream);
        }
        ReadWriteIOUtils.write((int)this.scanOrder.ordinal(), (OutputStream)stream);
        ReadWriteIOUtils.write((Boolean)this.queryAllSensors, (OutputStream)stream);
        ReadWriteIOUtils.write((int)this.selectMeasurements.size(), (OutputStream)stream);
        for (String string : this.selectMeasurements) {
            ReadWriteIOUtils.write((String)string, (OutputStream)stream);
        }
        ReadWriteIOUtils.write((int)this.deviceToMeasurementIndexes.size(), (OutputStream)stream);
        Iterator<Object> iterator = this.deviceToMeasurementIndexes.iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            ReadWriteIOUtils.write((int)n, (OutputStream)stream);
        }
        ReadWriteIOUtils.write((long)this.offsetValue, (OutputStream)stream);
        ReadWriteIOUtils.write((long)this.limitValue, (OutputStream)stream);
        if (this.predicate != null) {
            ReadWriteIOUtils.write((byte)1, (OutputStream)stream);
            Expression.serialize(this.predicate, stream);
            ReadWriteIOUtils.write((String)this.zoneId.getId(), (OutputStream)stream);
        } else {
            ReadWriteIOUtils.write((byte)0, (OutputStream)stream);
        }
    }

    public static TemplatedInfo deserialize(ByteBuffer byteBuffer) {
        int measurementSize = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        ArrayList<String> measurementList = new ArrayList<String>();
        int cnt = measurementSize;
        while (cnt-- > 0) {
            measurementList.add(ReadWriteIOUtils.readString((ByteBuffer)byteBuffer));
        }
        cnt = measurementSize;
        ArrayList<IMeasurementSchema> measurementSchemaList = new ArrayList<IMeasurementSchema>();
        while (cnt-- > 0) {
            measurementSchemaList.add((IMeasurementSchema)MeasurementSchema.deserializeFrom((ByteBuffer)byteBuffer));
        }
        cnt = measurementSize;
        ArrayList<TSDataType> dataTypeList = new ArrayList<TSDataType>();
        while (cnt-- > 0) {
            dataTypeList.add(ReadWriteIOUtils.readDataType((ByteBuffer)byteBuffer));
        }
        int allSensorSize = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        HashSet<String> allSensorSet = new HashSet<String>();
        while (allSensorSize-- > 0) {
            allSensorSet.add(ReadWriteIOUtils.readString((ByteBuffer)byteBuffer));
        }
        Ordering scanOrder = Ordering.values()[ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer)];
        boolean queryAllSensors = ReadWriteIOUtils.readBool((ByteBuffer)byteBuffer);
        int listSize = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        ArrayList<String> selectMeasurements = new ArrayList<String>(listSize);
        while (listSize-- > 0) {
            selectMeasurements.add(ReadWriteIOUtils.readString((ByteBuffer)byteBuffer));
        }
        listSize = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        ArrayList<Integer> deviceToMeasurementIndexes = new ArrayList<Integer>(listSize);
        while (listSize-- > 0) {
            deviceToMeasurementIndexes.add(ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer));
        }
        long offsetValue = ReadWriteIOUtils.readLong((ByteBuffer)byteBuffer);
        long limitValue = ReadWriteIOUtils.readLong((ByteBuffer)byteBuffer);
        Expression predicate = null;
        ZoneId zone = null;
        byte hasFilter = ReadWriteIOUtils.readByte((ByteBuffer)byteBuffer);
        HashMap<String, IMeasurementSchema> currentSchemaMap = null;
        Map<String, List<InputLocation>> layoutMap = null;
        if (hasFilter == 1) {
            predicate = Expression.deserialize(byteBuffer);
            zone = ZoneId.of(Objects.requireNonNull(ReadWriteIOUtils.readString((ByteBuffer)byteBuffer)));
            currentSchemaMap = new HashMap<String, IMeasurementSchema>();
            for (IMeasurementSchema measurementSchema : measurementSchemaList) {
                currentSchemaMap.put(measurementSchema.getMeasurementId(), measurementSchema);
            }
            layoutMap = TemplatedInfo.makeLayout(measurementList);
        }
        return new TemplatedInfo(measurementList, measurementSchemaList, dataTypeList, allSensorSet, scanOrder, queryAllSensors, selectMeasurements, deviceToMeasurementIndexes, offsetValue, limitValue, predicate, zone, currentSchemaMap, layoutMap);
    }
}

