/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.metric;

import org.apache.iotdb.commons.service.metric.enums.Metric;
import org.apache.iotdb.commons.service.metric.enums.Tag;
import org.apache.iotdb.db.queryengine.execution.exchange.MPPDataExchangeService;
import org.apache.iotdb.db.queryengine.execution.memory.MemoryPool;
import org.apache.iotdb.db.queryengine.plan.Coordinator;
import org.apache.iotdb.db.queryengine.plan.planner.LocalExecutionPlanner;
import org.apache.iotdb.metrics.AbstractMetricService;
import org.apache.iotdb.metrics.impl.DoNothingMetricManager;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.iotdb.metrics.type.Histogram;
import org.apache.iotdb.metrics.type.Timer;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.metrics.utils.MetricType;

public class QueryRelatedResourceMetricSet
implements IMetricSet {
    private static final Coordinator coordinator = Coordinator.getInstance();
    private static final String METRIC_COORDINATOR = Metric.COORDINATOR.toString();
    private static final String QUERY_EXECUTION_MAP_SIZE = "query_execution_map_size";
    private static final String FRAGMENT_INSTANCE_TIME = "fragment_instance_time";
    private static final String FRAGMENT_INSTANCE_EXECUTION_TIME = "fragment_instance_execution_time";
    private static final String FRAGMENT_INSTANCE_SIZE = "fragment_instance_size";
    private static final String FRAGMENT_INSTANCE_CONTEXT_SIZE = "fragment_instance_context_size";
    private static final String FRAGMENT_INSTANCE_EXECUTION_SIZE = "fragment_instance_execution_size";
    private static final String FRAGMENT_INSTANCE_DRIVER_SIZE = "fragment_instance_driver_size";
    private Timer fragmentInstanceExecutionTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Histogram fragmentInstanceContextSizeHistogram = DoNothingMetricManager.DO_NOTHING_HISTOGRAM;
    private Histogram fragmentInstanceExecutionSizeHistogram = DoNothingMetricManager.DO_NOTHING_HISTOGRAM;
    private Histogram fragmentInstanceDriverSizeHistogram = DoNothingMetricManager.DO_NOTHING_HISTOGRAM;
    private static final MemoryPool memoryPool = MPPDataExchangeService.getInstance().getMPPDataExchangeManager().getLocalMemoryManager().getQueryPool();
    private static final String MEMORY_POOL = Metric.MEMORY_POOL.toString();
    private static final String MAX_BYTES = "max_bytes";
    private static final String REMAINING_BYTES = "remaining_bytes";
    private static final String QUERY_MEMORY_RESERVATION_SIZE = "query_memory_reservation_size";
    private static final String MEMORY_RESERVATION_SIZE = "memory_reservation_size";
    private static final LocalExecutionPlanner localExecutionPlanner = LocalExecutionPlanner.getInstance();
    private static final String LOCAL_EXECUTION_PLANNER = Metric.LOCAL_EXECUTION_PLANNER.toString();
    private static final String FREE_MEMORY_FOR_OPERATORS = "free_memory_for_operators";

    public static QueryRelatedResourceMetricSet getInstance() {
        return InstanceHolder.INSTANCE;
    }

    public void updateFragmentInstanceCount(long fragmentInstanceContextSize, long fragmentInstanceExecutionSize, long fragmentInstanceDriverSize) {
        this.fragmentInstanceContextSizeHistogram.update(fragmentInstanceContextSize);
        this.fragmentInstanceExecutionSizeHistogram.update(fragmentInstanceExecutionSize);
        this.fragmentInstanceDriverSizeHistogram.update(fragmentInstanceDriverSize);
    }

    public void updateFragmentInstanceTime(long cost) {
        this.fragmentInstanceExecutionTimer.updateMillis(cost);
    }

    public void bindTo(AbstractMetricService metricService) {
        metricService.createAutoGauge(METRIC_COORDINATOR, MetricLevel.IMPORTANT, (Object)coordinator, Coordinator::getQueryExecutionMapSize, new String[]{Tag.NAME.toString(), QUERY_EXECUTION_MAP_SIZE});
        this.fragmentInstanceExecutionTimer = metricService.getOrCreateTimer(Metric.FRAGMENT_INSTANCE_MANAGER.toString(), MetricLevel.IMPORTANT, new String[]{Tag.TYPE.toString(), FRAGMENT_INSTANCE_TIME, Tag.NAME.toString(), FRAGMENT_INSTANCE_EXECUTION_TIME});
        this.fragmentInstanceContextSizeHistogram = metricService.getOrCreateHistogram(Metric.FRAGMENT_INSTANCE_MANAGER.toString(), MetricLevel.IMPORTANT, new String[]{Tag.TYPE.toString(), FRAGMENT_INSTANCE_SIZE, Tag.NAME.toString(), FRAGMENT_INSTANCE_CONTEXT_SIZE});
        this.fragmentInstanceExecutionSizeHistogram = metricService.getOrCreateHistogram(Metric.FRAGMENT_INSTANCE_MANAGER.toString(), MetricLevel.IMPORTANT, new String[]{Tag.TYPE.toString(), FRAGMENT_INSTANCE_SIZE, Tag.NAME.toString(), FRAGMENT_INSTANCE_EXECUTION_SIZE});
        this.fragmentInstanceDriverSizeHistogram = metricService.getOrCreateHistogram(Metric.FRAGMENT_INSTANCE_MANAGER.toString(), MetricLevel.IMPORTANT, new String[]{Tag.TYPE.toString(), FRAGMENT_INSTANCE_SIZE, Tag.NAME.toString(), FRAGMENT_INSTANCE_DRIVER_SIZE});
        metricService.getOrCreateGauge(MEMORY_POOL, MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), MAX_BYTES}).set(memoryPool.getMaxBytes());
        metricService.createAutoGauge(MEMORY_POOL, MetricLevel.IMPORTANT, (Object)memoryPool, MemoryPool::getRemainingBytes, new String[]{Tag.NAME.toString(), REMAINING_BYTES});
        metricService.createAutoGauge(MEMORY_POOL, MetricLevel.IMPORTANT, (Object)memoryPool, MemoryPool::getQueryMemoryReservationSize, new String[]{Tag.NAME.toString(), QUERY_MEMORY_RESERVATION_SIZE});
        metricService.createAutoGauge(MEMORY_POOL, MetricLevel.IMPORTANT, (Object)memoryPool, MemoryPool::getMemoryReservationSize, new String[]{Tag.NAME.toString(), MEMORY_RESERVATION_SIZE});
        metricService.createAutoGauge(LOCAL_EXECUTION_PLANNER, MetricLevel.IMPORTANT, (Object)localExecutionPlanner, LocalExecutionPlanner::getFreeMemoryForOperators, new String[]{Tag.NAME.toString(), FREE_MEMORY_FOR_OPERATORS});
    }

    public void unbindFrom(AbstractMetricService metricService) {
        metricService.remove(MetricType.AUTO_GAUGE, METRIC_COORDINATOR, new String[]{Tag.NAME.toString(), QUERY_EXECUTION_MAP_SIZE});
        metricService.remove(MetricType.TIMER, Metric.FRAGMENT_INSTANCE_MANAGER.toString(), new String[]{Tag.TYPE.toString(), FRAGMENT_INSTANCE_TIME, Tag.NAME.toString(), FRAGMENT_INSTANCE_EXECUTION_TIME});
        metricService.remove(MetricType.HISTOGRAM, Metric.FRAGMENT_INSTANCE_MANAGER.toString(), new String[]{Tag.TYPE.toString(), FRAGMENT_INSTANCE_SIZE, Tag.NAME.toString(), FRAGMENT_INSTANCE_CONTEXT_SIZE});
        metricService.remove(MetricType.HISTOGRAM, Metric.FRAGMENT_INSTANCE_MANAGER.toString(), new String[]{Tag.TYPE.toString(), FRAGMENT_INSTANCE_SIZE, Tag.NAME.toString(), FRAGMENT_INSTANCE_EXECUTION_SIZE});
        metricService.remove(MetricType.HISTOGRAM, Metric.FRAGMENT_INSTANCE_MANAGER.toString(), new String[]{Tag.TYPE.toString(), FRAGMENT_INSTANCE_SIZE, Tag.NAME.toString(), FRAGMENT_INSTANCE_DRIVER_SIZE});
        metricService.remove(MetricType.GAUGE, MEMORY_POOL, new String[]{Tag.NAME.toString(), MAX_BYTES});
        metricService.remove(MetricType.AUTO_GAUGE, MEMORY_POOL, new String[]{Tag.NAME.toString(), REMAINING_BYTES});
        metricService.remove(MetricType.AUTO_GAUGE, MEMORY_POOL, new String[]{Tag.NAME.toString(), QUERY_MEMORY_RESERVATION_SIZE});
        metricService.remove(MetricType.AUTO_GAUGE, MEMORY_POOL, new String[]{Tag.NAME.toString(), MEMORY_RESERVATION_SIZE});
        metricService.remove(MetricType.AUTO_GAUGE, LOCAL_EXECUTION_PLANNER, new String[]{Tag.NAME.toString(), FREE_MEMORY_FOR_OPERATORS});
    }

    private QueryRelatedResourceMetricSet() {
    }

    private static class InstanceHolder {
        private static final QueryRelatedResourceMetricSet INSTANCE = new QueryRelatedResourceMetricSet();

        private InstanceHolder() {
        }
    }
}

