/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.source;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.queryengine.execution.operator.OperatorContext;
import org.apache.iotdb.db.queryengine.execution.operator.source.AbstractDataSourceOperator;
import org.apache.iotdb.db.queryengine.execution.operator.source.SeriesScanUtil;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.SeriesScanOptions;
import org.apache.iotdb.db.queryengine.plan.statement.component.Ordering;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.common.block.column.Column;
import org.apache.iotdb.tsfile.read.common.block.column.ColumnBuilder;
import org.apache.iotdb.tsfile.read.common.block.column.TimeColumn;
import org.apache.iotdb.tsfile.read.common.block.column.TimeColumnBuilder;

public class SeriesScanOperator
extends AbstractDataSourceOperator {
    private boolean finished = false;

    public SeriesScanOperator(OperatorContext context, PlanNodeId sourceId, PartialPath seriesPath, Ordering scanOrder, SeriesScanOptions seriesScanOptions) {
        this.sourceId = sourceId;
        this.operatorContext = context;
        this.seriesScanUtil = new SeriesScanUtil(seriesPath, scanOrder, seriesScanOptions, context.getInstanceContext());
        this.maxReturnSize = Math.min(this.maxReturnSize, (long)TSFileDescriptor.getInstance().getConfig().getPageSizeInByte());
    }

    @Override
    public TsBlock next() throws Exception {
        if (this.retainedTsBlock != null) {
            return this.getResultFromRetainedTsBlock();
        }
        this.resultTsBlock = this.resultTsBlockBuilder.build();
        this.resultTsBlockBuilder.reset();
        return this.checkTsBlockSizeAndGetResult();
    }

    @Override
    public boolean hasNext() throws Exception {
        if (this.retainedTsBlock != null) {
            return true;
        }
        try {
            long maxRuntime = this.operatorContext.getMaxRunTime().roundTo(TimeUnit.NANOSECONDS);
            long start = System.nanoTime();
            while ((this.readPageData() || this.readChunkData() || this.readFileData()) && System.nanoTime() - start < maxRuntime && !this.resultTsBlockBuilder.isFull()) {
            }
            this.finished = this.resultTsBlockBuilder.isEmpty();
            return !this.finished;
        }
        catch (IOException e) {
            throw new RuntimeException("Error happened while scanning the file", e);
        }
    }

    @Override
    public boolean isFinished() throws Exception {
        return this.finished;
    }

    @Override
    public long calculateMaxPeekMemory() {
        return Math.max(this.maxReturnSize, (long)TSFileDescriptor.getInstance().getConfig().getPageSizeInByte() * 3L);
    }

    @Override
    public long calculateMaxReturnSize() {
        return this.maxReturnSize;
    }

    @Override
    public long calculateRetainedSizeAfterCallingNext() {
        return this.calculateMaxPeekMemory() - this.calculateMaxReturnSize();
    }

    private boolean readFileData() throws IOException {
        while (this.seriesScanUtil.hasNextFile()) {
            if (!this.readChunkData()) continue;
            return true;
        }
        return false;
    }

    private boolean readChunkData() throws IOException {
        while (this.seriesScanUtil.hasNextChunk()) {
            if (!this.readPageData()) continue;
            return true;
        }
        return false;
    }

    private boolean readPageData() throws IOException {
        while (this.seriesScanUtil.hasNextPage()) {
            TsBlock tsBlock = this.seriesScanUtil.nextPage();
            if (this.isEmpty(tsBlock)) continue;
            this.appendToBuilder(tsBlock);
            return true;
        }
        return false;
    }

    private void appendToBuilder(TsBlock tsBlock) {
        TimeColumnBuilder timeColumnBuilder = this.resultTsBlockBuilder.getTimeColumnBuilder();
        TimeColumn timeColumn = tsBlock.getTimeColumn();
        ColumnBuilder columnBuilder = this.resultTsBlockBuilder.getColumnBuilder(0);
        Column column = tsBlock.getColumn(0);
        if (column.mayHaveNull()) {
            int size = tsBlock.getPositionCount();
            for (int i = 0; i < size; ++i) {
                timeColumnBuilder.writeLong(timeColumn.getLong(i));
                if (column.isNull(i)) {
                    columnBuilder.appendNull();
                } else {
                    columnBuilder.write(column, i);
                }
                this.resultTsBlockBuilder.declarePosition();
            }
        } else {
            int size = tsBlock.getPositionCount();
            for (int i = 0; i < size; ++i) {
                timeColumnBuilder.writeLong(timeColumn.getLong(i));
                columnBuilder.write(column, i);
                this.resultTsBlockBuilder.declarePosition();
            }
        }
    }

    private boolean isEmpty(TsBlock tsBlock) {
        return tsBlock == null || tsBlock.isEmpty();
    }

    @Override
    protected List<TSDataType> getResultDataTypes() {
        return this.seriesScanUtil.getTsDataTypeList();
    }
}

