/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import org.apache.iotdb.db.queryengine.execution.operator.OperatorContext;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;

public interface Operator
extends AutoCloseable {
    public static final ListenableFuture<?> NOT_BLOCKED = Futures.immediateVoidFuture();

    public OperatorContext getOperatorContext();

    default public ListenableFuture<?> isBlocked() {
        return NOT_BLOCKED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public TsBlock nextWithTimer() throws Exception {
        OperatorContext context = this.getOperatorContext();
        long startTime = System.nanoTime();
        try {
            TsBlock tsBlock = this.next();
            return tsBlock;
        }
        finally {
            context.recordExecutionTime(System.nanoTime() - startTime);
            context.recordNextCalled();
        }
    }

    public TsBlock next() throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public boolean hasNextWithTimer() throws Exception {
        OperatorContext context = this.getOperatorContext();
        long startTime = System.nanoTime();
        try {
            boolean bl = this.hasNext();
            return bl;
        }
        finally {
            context.recordExecutionTime(System.nanoTime() - startTime);
        }
    }

    public boolean hasNext() throws Exception;

    @Override
    public void close() throws Exception;

    public boolean isFinished() throws Exception;

    public long calculateMaxPeekMemory();

    public long calculateMaxReturnSize();

    public long calculateRetainedSizeAfterCallingNext();
}

