/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.task.subtask.connector;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.iotdb.commons.pipe.config.PipeConfig;
import org.apache.iotdb.commons.pipe.config.constant.PipeConnectorConstant;
import org.apache.iotdb.commons.pipe.config.plugin.configuraion.PipeTaskRuntimeConfiguration;
import org.apache.iotdb.commons.pipe.config.plugin.env.PipeTaskConnectorRuntimeEnvironment;
import org.apache.iotdb.commons.pipe.metric.PipeEventCounter;
import org.apache.iotdb.commons.pipe.plugin.builtin.BuiltinPipePlugin;
import org.apache.iotdb.commons.pipe.task.connection.BoundedBlockingPendingQueue;
import org.apache.iotdb.db.pipe.agent.PipeAgent;
import org.apache.iotdb.db.pipe.execution.executor.PipeConnectorSubtaskExecutor;
import org.apache.iotdb.db.pipe.metric.PipeDataRegionEventCounter;
import org.apache.iotdb.db.pipe.progress.committer.PipeEventCommitManager;
import org.apache.iotdb.db.pipe.task.subtask.connector.PipeConnectorSubtask;
import org.apache.iotdb.db.pipe.task.subtask.connector.PipeConnectorSubtaskLifeCycle;
import org.apache.iotdb.pipe.api.PipeConnector;
import org.apache.iotdb.pipe.api.customizer.configuration.PipeConnectorRuntimeConfiguration;
import org.apache.iotdb.pipe.api.customizer.configuration.PipeRuntimeEnvironment;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameterValidator;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameters;
import org.apache.iotdb.pipe.api.event.Event;
import org.apache.iotdb.pipe.api.exception.PipeException;

public class PipeConnectorSubtaskManager {
    private static final String FAILED_TO_DEREGISTER_EXCEPTION_MESSAGE = "Failed to deregister PipeConnectorSubtask. No such subtask: ";
    private final Map<String, List<PipeConnectorSubtaskLifeCycle>> attributeSortedString2SubtaskLifeCycleMap = new HashMap<String, List<PipeConnectorSubtaskLifeCycle>>();

    public synchronized String register(PipeConnectorSubtaskExecutor executor, PipeParameters pipeConnectorParameters, PipeTaskConnectorRuntimeEnvironment environment) {
        String connectorKey = pipeConnectorParameters.getStringOrDefault(Arrays.asList("connector", "sink"), BuiltinPipePlugin.IOTDB_THRIFT_CONNECTOR.getPipePluginName()).toLowerCase();
        PipeEventCommitManager.getInstance().register(environment.getPipeName(), environment.getRegionId(), connectorKey);
        String attributeSortedString = new TreeMap(pipeConnectorParameters.getAttribute()).toString();
        if (!this.attributeSortedString2SubtaskLifeCycleMap.containsKey(attributeSortedString)) {
            int connectorNum = pipeConnectorParameters.getIntOrDefault(Arrays.asList("connector.parallel.tasks", "sink.parallel.tasks"), PipeConnectorConstant.CONNECTOR_IOTDB_PARALLEL_TASKS_DEFAULT_VALUE);
            ArrayList<PipeConnectorSubtaskLifeCycle> pipeConnectorSubtaskLifeCycleList = new ArrayList<PipeConnectorSubtaskLifeCycle>(connectorNum);
            BoundedBlockingPendingQueue pendingQueue = new BoundedBlockingPendingQueue(PipeConfig.getInstance().getPipeConnectorPendingQueueSize(), (PipeEventCounter)new PipeDataRegionEventCounter());
            for (int connectorIndex = 0; connectorIndex < connectorNum; ++connectorIndex) {
                PipeConnector pipeConnector = PipeAgent.plugin().dataRegion().reflectConnector(pipeConnectorParameters);
                try {
                    pipeConnector.validate(new PipeParameterValidator(pipeConnectorParameters));
                    pipeConnector.customize(pipeConnectorParameters, (PipeConnectorRuntimeConfiguration)new PipeTaskRuntimeConfiguration((PipeRuntimeEnvironment)environment));
                    pipeConnector.handshake();
                }
                catch (Exception e) {
                    throw new PipeException("Failed to construct PipeConnector, because of " + e.getMessage(), (Throwable)e);
                }
                PipeConnectorSubtask pipeConnectorSubtask = new PipeConnectorSubtask(String.format("%s_%s_%s", attributeSortedString, environment.getCreationTime(), connectorIndex), environment.getCreationTime(), attributeSortedString, connectorIndex, (BoundedBlockingPendingQueue<Event>)pendingQueue, pipeConnector);
                PipeConnectorSubtaskLifeCycle pipeConnectorSubtaskLifeCycle = new PipeConnectorSubtaskLifeCycle(executor, pipeConnectorSubtask, (BoundedBlockingPendingQueue<Event>)pendingQueue);
                pipeConnectorSubtaskLifeCycleList.add(pipeConnectorSubtaskLifeCycle);
            }
            this.attributeSortedString2SubtaskLifeCycleMap.put(attributeSortedString, pipeConnectorSubtaskLifeCycleList);
        }
        for (PipeConnectorSubtaskLifeCycle lifeCycle : this.attributeSortedString2SubtaskLifeCycleMap.get(attributeSortedString)) {
            lifeCycle.register();
        }
        return attributeSortedString;
    }

    public synchronized void deregister(String pipeName, int dataRegionId, String attributeSortedString) {
        if (!this.attributeSortedString2SubtaskLifeCycleMap.containsKey(attributeSortedString)) {
            throw new PipeException(FAILED_TO_DEREGISTER_EXCEPTION_MESSAGE + attributeSortedString);
        }
        List<PipeConnectorSubtaskLifeCycle> lifeCycles = this.attributeSortedString2SubtaskLifeCycleMap.get(attributeSortedString);
        lifeCycles.removeIf(o -> o.deregister(pipeName));
        if (lifeCycles.isEmpty()) {
            this.attributeSortedString2SubtaskLifeCycleMap.remove(attributeSortedString);
        }
        PipeEventCommitManager.getInstance().deregister(pipeName, dataRegionId);
    }

    public synchronized void start(String attributeSortedString) {
        if (!this.attributeSortedString2SubtaskLifeCycleMap.containsKey(attributeSortedString)) {
            throw new PipeException(FAILED_TO_DEREGISTER_EXCEPTION_MESSAGE + attributeSortedString);
        }
        for (PipeConnectorSubtaskLifeCycle lifeCycle : this.attributeSortedString2SubtaskLifeCycleMap.get(attributeSortedString)) {
            lifeCycle.start();
        }
    }

    public synchronized void stop(String attributeSortedString) {
        if (!this.attributeSortedString2SubtaskLifeCycleMap.containsKey(attributeSortedString)) {
            throw new PipeException(FAILED_TO_DEREGISTER_EXCEPTION_MESSAGE + attributeSortedString);
        }
        for (PipeConnectorSubtaskLifeCycle lifeCycle : this.attributeSortedString2SubtaskLifeCycleMap.get(attributeSortedString)) {
            lifeCycle.stop();
        }
    }

    public BoundedBlockingPendingQueue<Event> getPipeConnectorPendingQueue(String attributeSortedString) {
        if (!this.attributeSortedString2SubtaskLifeCycleMap.containsKey(attributeSortedString)) {
            throw new PipeException("Failed to get PendingQueue. No such subtask: " + attributeSortedString);
        }
        return this.attributeSortedString2SubtaskLifeCycleMap.get(attributeSortedString).get(0).getPendingQueue();
    }

    private PipeConnectorSubtaskManager() {
    }

    public static PipeConnectorSubtaskManager instance() {
        return PipeSubtaskManagerHolder.INSTANCE;
    }

    private static class PipeSubtaskManagerHolder {
        private static final PipeConnectorSubtaskManager INSTANCE = new PipeConnectorSubtaskManager();

        private PipeSubtaskManagerHolder() {
        }
    }
}

